/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.util.List;
import net.sf.okapi.common.Util;

public class IdGenerator {
    public static final String START_DOCUMENT = "sd";
    public static final String END_DOCUMENT = "ed";
    public static final String START_GROUP = "sg";
    public static final String END_GROUP = "eg";
    public static final String TEXT_UNIT = "tu";
    public static final String DOCUMENT_PART = "dp";
    public static final String START_SUBDOCUMENT = "ssd";
    public static final String END_SUBDOCUMENT = "esd";
    public static final String START_SUBFILTER = "ssf";
    public static final String END_SUBFILTER = "esf";
    public static final String DEFAULT_ROOT_ID = "noDocName";
    private long seq = 0L;
    private String rootId;
    private String prefix;
    private String lastId;

    public IdGenerator(String root) {
        this.create(root, "");
    }

    public IdGenerator(String root, String prefix) {
        this.create(root, prefix);
    }

    public String toString() {
        return this.getLastId();
    }

    public String createId() {
        this.lastId = this.rootId == null ? this.prefix + Long.toString(++this.seq) : this.rootId + "-" + this.prefix + Long.toString(++this.seq);
        return this.lastId;
    }

    public String createIdNotInList(List<String> list) {
        String tmp = this.createId();
        while (list.contains(tmp)) {
            tmp = this.createId();
        }
        return tmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createId(String prefix) {
        String orginalPrefix = this.prefix;
        this.prefix = prefix;
        try {
            this.lastId = this.rootId == null ? prefix + Long.toString(++this.seq) : this.rootId + "-" + prefix + Long.toString(++this.seq);
            String string = this.lastId;
            return string;
        }
        finally {
            this.prefix = orginalPrefix;
        }
    }

    public void setLastId(String lastId) {
        this.lastId = lastId;
    }

    public String getLastId() {
        if (this.lastId == null) {
            throw new RuntimeException("The method createId() has not been called yet.");
        }
        return this.lastId;
    }

    public String getRootId() {
        return this.rootId;
    }

    public void setSequence(long sequence) {
        this.seq = sequence;
    }

    public long getSequence() {
        return this.seq;
    }

    public void reset(String rootId) {
        this.seq = 0L;
        this.create(rootId, this.prefix);
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix == null ? "" : prefix;
    }

    private void create(String root, String prefix) {
        this.rootId = Util.isEmpty(root) ? null : Util.makeId(root);
        this.setPrefix(prefix);
    }
}

