/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;

public class StreamUtil {
    private static final int IO_BUFFER_SIZE = 8192;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = null;){
            int len;
            out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        return out.toByteArray();
    }

    public static void copy(InputStream in, OutputStream out) {
        byte[] b = new byte[8192];
        try {
            int read;
            while ((read = in.read(b)) != -1) {
                out.write(b, 0, read);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static void copy(File in, OutputStream out) {
        try {
            StreamUtil.copy((InputStream)new FileInputStream(in), out);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
    }

    public static void copy(InputStream in, File out) {
        try {
            StreamUtil.copy(in, (OutputStream)new FileOutputStream(out));
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
    }

    public static void copy(File in, File out) {
        try {
            StreamUtil.copy((InputStream)new FileInputStream(in), (OutputStream)new FileOutputStream(out));
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
    }

    public static String streamAsString(InputStream in, String encoding) {
        BufferedReader reader = null;
        StringBuilder tmp = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, encoding));
            tmp = new StringBuilder();
            char[] buf = new char[2048];
            int count = 0;
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return Util.normalizeNewlines(tmp.toString());
    }

    public static String streamAsString(InputStream in) {
        return StreamUtil.streamAsString(in, "UTF-8");
    }

    public static InputStream stringAsStream(String str) {
        return new ByteArrayInputStream(str.getBytes());
    }

    public static InputStream stringAsStream(String str, String encoding) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(str.getBytes(encoding));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return is;
    }

    public static long calcCRC(InputStream in) {
        CheckedInputStream cis = new CheckedInputStream(in, new CRC32());
        byte[] buf = new byte[1024];
        try {
            while (cis.read(buf) >= 0) {
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return cis.getChecksum().getValue();
    }
}

