/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.tm.pensieve.tmx;

import java.io.IOException;
import java.net.URI;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.tm.pensieve.common.PensieveUtil;
import net.sf.okapi.tm.pensieve.common.TranslationUnit;
import net.sf.okapi.tm.pensieve.tmx.ITmxImporter;
import net.sf.okapi.tm.pensieve.writer.ITmWriter;

public class OkapiTmxImporter
implements ITmxImporter {
    private IFilter tmxFilter;
    private LocaleId sourceLang;

    public OkapiTmxImporter(LocaleId sourceLang, IFilter tmxFilter) {
        this.tmxFilter = tmxFilter;
        this.sourceLang = sourceLang;
        if (Util.isNullOrEmpty(sourceLang)) {
            throw new IllegalArgumentException("'sourceLang' must be set");
        }
        if (tmxFilter == null) {
            throw new IllegalArgumentException("'filter' must be set");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void importTmx(URI tmxUri, LocaleId targetLang, ITmWriter tmWriter) throws IOException {
        this.checkImportTmxParams(tmxUri, targetLang, tmWriter);
        try {
            this.tmxFilter.open(new RawDocument(tmxUri, null, this.sourceLang, targetLang));
            while (this.tmxFilter.hasNext()) {
                Event event = this.tmxFilter.next();
                this.indexEvent(targetLang, tmWriter, event);
            }
        }
        finally {
            this.tmxFilter.close();
        }
    }

    private void checkImportTmxParams(URI tmxUri, LocaleId targetLang, ITmWriter tmWriter) {
        if (Util.isNullOrEmpty(targetLang)) {
            throw new IllegalArgumentException("'targetLang' was not set");
        }
        if (tmxUri == null) {
            throw new IllegalArgumentException("'tmxUri' was not set");
        }
        if (tmWriter == null) {
            throw new IllegalArgumentException("'tmWriter' was not set");
        }
    }

    private void indexEvent(LocaleId targetLang, ITmWriter tmWriter, Event event) throws IOException {
        if (event.getEventType() == EventType.TEXT_UNIT) {
            TranslationUnit tu = PensieveUtil.convertToTranslationUnit(this.sourceLang, targetLang, event.getTextUnit());
            tmWriter.indexTranslationUnit(tu);
        }
    }
}

