/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.lib;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;

public class FormatManager {
    Map<String, String> pairs;

    public void load(String p_sPath) {
        this.pairs = new Hashtable<String, String>();
        this.pairs.put(".xlf", "okf_xliff");
        this.pairs.put(".xml", "okf_xml");
        this.pairs.put(".html", "okf_html");
        this.pairs.put(".htm", "okf_html");
        this.pairs.put(".properties", "okf_properties");
        this.pairs.put(".lang", "okf_properties-skypeLang");
        this.pairs.put(".tmx", "okf_tmx");
        this.pairs.put(".mif", "okf_mif");
        this.pairs.put(".rtf", "okf_tradosrtf");
        this.pairs.put(".idml", "okf_idml");
        this.pairs.put(".po", "okf_po");
        this.pairs.put(".pot", "okf_po");
        this.pairs.put(".docx", "okf_openxml");
        this.pairs.put(".docm", "okf_openxml");
        this.pairs.put(".dotm", "okf_openxml");
        this.pairs.put(".xlsx", "okf_openxml");
        this.pairs.put(".pptx", "okf_openxml");
        this.pairs.put(".odt", "okf_openoffice");
        this.pairs.put(".ott", "okf_openoffice");
        this.pairs.put(".sxw", "okf_openoffice");
        this.pairs.put(".stw", "okf_openoffice");
        this.pairs.put(".odp", "okf_openoffice");
        this.pairs.put(".otp", "okf_openoffice");
        this.pairs.put(".sxi", "okf_openoffice");
        this.pairs.put(".sti", "okf_openoffice");
        this.pairs.put(".ods", "okf_openoffice");
        this.pairs.put(".ots", "okf_openoffice");
        this.pairs.put(".sxc", "okf_openoffice");
        this.pairs.put(".stc", "okf_openoffice");
        this.pairs.put(".odg", "okf_openoffice");
        this.pairs.put(".otg", "okf_openoffice");
        this.pairs.put(".sxd", "okf_openoffice");
        this.pairs.put(".std", "okf_openoffice");
        this.pairs.put(".sdlxlf", "okf_xliff");
        this.pairs.put(".xliff", "okf_xliff");
        this.pairs.put(".dtd", "okf_dtd");
        this.pairs.put(".ts", "okf_ts");
        this.pairs.put(".txt", "okf_plaintext");
        this.pairs.put(".srt", "okf_regex-srt");
        this.pairs.put(".json", "okf_json");
        this.pairs.put(".ttx", "okf_ttx");
        this.pairs.put(".pentm", "okf_pensieve");
        this.pairs.put(".yml", "okf_railsyaml");
        this.pairs.put(".vrsz", "okf_versifiedtxt");
        this.pairs.put(".rkm", "okf_rainbowkit");
        this.pairs.put(".rkp", "okf_rainbowkit-package");
        this.pairs.put(".txp", "okf_transifex");
        this.pairs.put(".txml", "okf_txml");
        this.pairs.put(".strings", "okf_regex-macStrings");
        this.pairs.put(".h", "okf_doxygen");
        this.pairs.put(".c", "okf_doxygen");
        this.pairs.put(".cpp", "okf_doxygen");
        this.pairs.put(".java", "okf_doxygen");
        this.pairs.put(".py", "okf_doxygen");
        this.pairs.put(".m", "okf_doxygen");
    }

    public String[] guessFormat(String p_sPath) {
        String[] aRes = new String[2];
        String sExt = Util.getExtension(p_sPath).toLowerCase();
        aRes[0] = null;
        aRes[1] = this.pairs.get(sExt);
        return aRes;
    }

    public void addExtensionMapping(FilterConfiguration config) {
        for (String ext : ListUtil.stringAsList(config.extensions, ";")) {
            if (Util.isEmpty(ext) || this.pairs.containsKey(ext)) continue;
            this.pairs.put(ext, config.configId);
        }
    }

    public void addConfigurations(IFilterConfigurationMapper fcMapper) {
        Iterator<FilterConfiguration> iterator = fcMapper.getAllConfigurations();
        while (iterator.hasNext()) {
            FilterConfiguration config = iterator.next();
            this.addExtensionMapping(config);
        }
    }
}

