/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.logger;

import net.sf.okapi.applications.rainbow.lib.ILog;
import net.sf.okapi.applications.rainbow.logger.ILogHandler;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;

class LogHandlerLog4j
extends AppenderSkeleton
implements ILogHandler {
    private ILog log;

    protected LogHandlerLog4j() {
    }

    @Override
    public void initialize(ILog log) {
        if (log == null) {
            return;
        }
        this.log = log;
        this.setThreshold((Priority)Level.INFO);
        Logger.getRootLogger().addAppender((Appender)this);
    }

    @Override
    public void setLogLevel(int level) {
        switch (level) {
            case 2: {
                this.setThreshold((Priority)Level.DEBUG);
                Logger.getRootLogger().setLevel(Level.DEBUG);
                break;
            }
            case 1: {
                this.setThreshold((Priority)Level.TRACE);
                Logger.getRootLogger().setLevel(Level.TRACE);
                break;
            }
            default: {
                this.setThreshold((Priority)Level.INFO);
                Logger.getRootLogger().setLevel(Level.INFO);
            }
        }
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return false;
    }

    protected void append(LoggingEvent record) {
        if (this.log == null) {
            return;
        }
        Level lev = record.getLevel();
        if (lev == Level.ERROR || lev == Level.FATAL) {
            this.log.error(record.getRenderedMessage());
            ThrowableInformation e = record.getThrowableInformation();
            if (e != null) {
                this.log.message(" @ " + e.toString());
            }
        } else if (lev == Level.WARN) {
            if ("org.apache.axis.utils.JavaUtils".equals(record.getLoggerName())) {
                return;
            }
            this.log.warning(record.getRenderedMessage());
        } else {
            this.log.message(record.getRenderedMessage());
        }
    }
}

