/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.io.FileCachedInputStream;

public class StreamUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] inputStreamToBytes(InputStream in) throws IOException {
        ByteArrayOutputStream out = null;
        try {
            int len;
            out = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((len = in.read(buffer)) >= 0) {
                out.write(buffer, 0, len);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                out.close();
            }
        }
        return out.toByteArray();
    }

    public static void copy(File in, OutputStream out) {
        try {
            StreamUtil.copy((InputStream)new FileInputStream(in), out);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException(e);
        }
    }

    public static String streamAsString(InputStream in, String encoding) {
        BufferedReader reader = null;
        StringBuilder tmp = null;
        try {
            reader = new BufferedReader(new InputStreamReader(in, encoding));
            tmp = new StringBuilder();
            char[] buf = new char[2048];
            int count = 0;
            while ((count = reader.read(buf)) != -1) {
                tmp.append(buf, 0, count);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {}
            }
        }
        return Util.normalizeNewlines(tmp.toString());
    }

    public static String streamUtf8AsString(InputStream in) {
        return StreamUtil.streamAsString(in, "UTF-8");
    }

    public static InputStream stringAsStream(String str, String encoding) {
        ByteArrayInputStream is = null;
        try {
            is = new ByteArrayInputStream(str.getBytes(encoding));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return is;
    }

    public static long calcCRC(InputStream in) {
        CheckedInputStream cis = new CheckedInputStream(in, new CRC32());
        byte[] buf = new byte[1024];
        try {
            while (cis.read(buf) >= 0) {
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return cis.getChecksum().getValue();
    }

    public static void copy(ReadableByteChannel inChannel, WritableByteChannel outChannel) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(16384);
        try {
            while (inChannel.read(buffer) != -1) {
                buffer.flip();
                outChannel.write(buffer);
                buffer.compact();
            }
            buffer.flip();
            while (buffer.hasRemaining()) {
                outChannel.write(buffer);
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static void copy(InputStream in, File outputFile) {
        try {
            if (!outputFile.exists()) {
                Util.createDirectories(outputFile.getAbsolutePath());
                outputFile.createNewFile();
            }
            StreamUtil.copy(in, (OutputStream)new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static void copy(InputStream is, String outputPath) {
        ReadableByteChannel inChannel = null;
        Channel outChannel = null;
        try {
            inChannel = Channels.newChannel(is);
            outChannel = new FileOutputStream(new File(outputPath)).getChannel();
            StreamUtil.copy(inChannel, (WritableByteChannel)outChannel);
        }
        catch (FileNotFoundException e) {
            throw new OkapiIOException(e);
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream is, OutputStream outputStream) {
        ReadableByteChannel inChannel = null;
        WritableByteChannel outChannel = null;
        try {
            inChannel = Channels.newChannel(is);
            outChannel = Channels.newChannel(outputStream);
            StreamUtil.copy(inChannel, outChannel);
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(File in, File out) {
        FileChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            StreamUtil.copy(inChannel, (WritableByteChannel)((Object)outChannel));
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            try {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static void copy(String fromPath, String toPath, boolean move) {
        AbstractInterruptibleChannel ic = null;
        AbstractInterruptibleChannel oc = null;
        try {
            Util.createDirectories(toPath);
            ic = new FileInputStream(fromPath).getChannel();
            oc = new FileOutputStream(toPath).getChannel();
            StreamUtil.copy((ReadableByteChannel)((Object)ic), (WritableByteChannel)((Object)oc));
            if (move) {
                ic.close();
                ic = null;
                File file = new File(fromPath);
                file.delete();
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        finally {
            try {
                if (ic != null) {
                    ic.close();
                }
                if (oc != null) {
                    oc.close();
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
        }
    }

    public static FileCachedInputStream createResettableStream(InputStream is, int bufferSize) throws IOException {
        FileCachedInputStream ifcis;
        try {
            ifcis = new FileCachedInputStream(bufferSize);
            StreamUtil.copy(Channels.newChannel(is), ifcis);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error copying inputstream to FileCachedInputStream", e);
        }
        finally {
            is.close();
        }
        ifcis.mark(Integer.MAX_VALUE);
        return ifcis;
    }

    public boolean isCompressed(byte[] bytes) throws IOException {
        if (bytes == null || bytes.length < 2) {
            return false;
        }
        return bytes[0] == 31 && bytes[1] == -117;
    }
}

