/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiFileNotFoundException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.common.skeleton.ZipSkeleton;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.OpenXMLContentSkeletonWriter;
import net.sf.okapi.filters.openxml.OpenXMLSubDoc;
import net.sf.okapi.filters.openxml.YamlParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenXMLZipFilterWriter
implements IFilterWriter {
    public static final int MSWORD = 1;
    public static final int MSEXCEL = 2;
    public static final int MSPOWERPOINT = 3;
    public static final int MSWORDCHART = 4;
    public static final int MSEXCELCOMMENT = 5;
    public static final int MSWORDDOCPROPERTIES = 6;
    private String outputPath;
    private ZipFile zipOriginal;
    private ZipOutputStream zipOut;
    private byte[] buffer;
    private LocaleId srcLoc;
    private LocaleId outTargetLang;
    private File tempFile;
    private File tempZip;
    private YamlParameters params;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private EncoderManager encoderManager;
    private ZipEntry subDocEntry;
    private IFilterWriter subDocWriter;
    private OpenXMLContentSkeletonWriter subSkelWriter;
    private TreeMap<Integer, OpenXMLSubDoc> tmSubDoc = new TreeMap();
    private int ndxSubDoc = 0;
    private OutputStream outputStream;

    @Override
    public void cancel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.zipOut == null) {
            return;
        }
        IOException err = null;
        InputStream orig = null;
        OutputStream dest = null;
        try {
            if (this.zipOriginal != null) {
                this.zipOriginal.close();
                this.zipOriginal = null;
            }
            this.zipOut.close();
            this.zipOut = null;
            if (this.tempZip != null) {
                int len;
                dest = new FileOutputStream(this.outputPath);
                orig = new FileInputStream(this.tempZip);
                while ((len = orig.read(this.buffer)) > 0) {
                    dest.write(this.buffer, 0, len);
                }
            }
            this.buffer = null;
        }
        catch (IOException e) {
            err = e;
        }
        finally {
            if (dest != null) {
                try {
                    dest.close();
                }
                catch (IOException e) {
                    err = e;
                }
                dest = null;
            }
            if (orig != null) {
                try {
                    orig.close();
                }
                catch (IOException e) {
                    err = e;
                }
                orig = null;
                if (err != null) {
                    throw new OkapiIOException("Error closing MS Office 2007 file.");
                }
                if (this.tempZip != null) {
                    this.tempZip.delete();
                    this.tempZip = null;
                }
            }
        }
    }

    @Override
    public String getName() {
        return "OpenXMLZipFilterWriter";
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setAllKnownMappings();
        }
        return this.encoderManager;
    }

    @Override
    public ISkeletonWriter getSkeletonWriter() {
        return this.subSkelWriter;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_DOCUMENT: {
                this.processStartDocument((StartDocument)event.getResource());
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument();
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument((StartSubDocument)event.getResource());
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument((Ending)event.getResource());
                break;
            }
            case TEXT_UNIT: 
            case START_GROUP: 
            case END_GROUP: 
            case START_SUBFILTER: 
            case END_SUBFILTER: {
                try {
                    this.subDocWriter.handleEvent(event);
                    break;
                }
                catch (Throwable e) {
                    String mess = e.getMessage();
                    throw new OkapiNotImplementedException(mess);
                }
            }
        }
        return event;
    }

    @Override
    public void setOptions(LocaleId language, String defaultEncoding) {
        this.outTargetLang = language;
    }

    @Override
    public void setOutput(String path) {
        this.outputPath = path;
    }

    @Override
    public void setOutput(OutputStream output) {
        this.outputStream = output;
    }

    private void processStartDocument(StartDocument res) {
        try {
            this.buffer = new byte[2048];
            this.srcLoc = res.getLocale();
            ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
            this.zipOriginal = skel.getOriginal();
            File fZip = new File(this.zipOriginal.getName());
            this.zipOriginal = new ZipFile(fZip, 1);
            this.tempZip = null;
            boolean useTemp = false;
            OutputStream os = this.outputStream;
            if (this.outputStream == null) {
                File f = new File(this.outputPath);
                if (f.exists()) {
                    boolean bl = useTemp = !f.delete();
                }
                if (useTemp) {
                    this.tempZip = File.createTempFile("~okapi-24_zfwTmpZip_", null);
                    os = new FileOutputStream(this.tempZip.getAbsolutePath());
                } else {
                    Util.createDirectories(this.outputPath);
                    os = new FileOutputStream(this.outputPath);
                }
            } else {
                os = this.outputStream;
            }
            this.zipOut = new ZipOutputStream(os);
        }
        catch (FileNotFoundException e) {
            throw new OkapiFileNotFoundException("Existing file could not be overwritten.");
        }
        catch (IOException e) {
            throw new OkapiIOException("File could not be written.");
        }
    }

    private void processEndDocument() {
        this.close();
    }

    private void processDocumentPart(Event event) {
        DocumentPart res = (DocumentPart)event.getResource();
        if (res.getSkeleton() instanceof ZipSkeleton) {
            ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
            ZipEntry entry = skel.getEntry();
            try {
                int len;
                String naym = entry.getName();
                ZipEntry entree = new ZipEntry(naym);
                this.zipOut.putNextEntry(entree);
                InputStream input = this.zipOriginal.getInputStream(entry);
                while ((len = input.read(this.buffer)) > 0) {
                    this.zipOut.write(this.buffer, 0, len);
                }
                input.close();
                this.zipOut.closeEntry();
            }
            catch (IOException e) {
                throw new OkapiIOException("Error writing zip file entry.");
            }
        } else {
            this.subDocWriter.handleEvent(event);
        }
    }

    private void processStartSubDocument(StartSubDocument res) {
        int nZipType = 0;
        ++this.ndxSubDoc;
        OpenXMLSubDoc openXMLSubDoc = new OpenXMLSubDoc();
        this.tmSubDoc.put(new Integer(this.ndxSubDoc), openXMLSubDoc);
        ZipSkeleton skel = (ZipSkeleton)res.getSkeleton();
        this.subDocEntry = skel.getEntry();
        try {
            this.tempFile = File.createTempFile("~okapi-25_zfwTmp" + this.ndxSubDoc + "_", null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error opening temporary zip output file.");
        }
        nZipType = ((ConditionalParameters)res.getFilterParameters()).nFileType;
        this.subSkelWriter = new OpenXMLContentSkeletonWriter(nZipType);
        this.subDocWriter = new GenericFilterWriter(this.subSkelWriter, this.getEncoderManager());
        this.subDocWriter.setOptions(this.outTargetLang, "UTF-8");
        this.subDocWriter.setOutput(this.tempFile.getAbsolutePath());
        StartDocument sd = new StartDocument("sd");
        sd.setLineBreak("\n");
        sd.setSkeleton(res.getSkeleton());
        sd.setLocale(this.srcLoc);
        this.subDocWriter.handleEvent(new Event(EventType.START_DOCUMENT, sd));
        openXMLSubDoc.setSubDocEntry(this.subSkelWriter);
        openXMLSubDoc.setSubDocEntry(this.subDocEntry);
        openXMLSubDoc.setSubDocWriter(this.subDocWriter);
        openXMLSubDoc.setSubTempFile(this.tempFile);
    }

    private void processEndSubDocument(Ending res) {
        try {
            int len;
            OpenXMLSubDoc openXMLSubDoc = this.tmSubDoc.get(new Integer(this.ndxSubDoc--));
            this.subDocWriter = openXMLSubDoc.getSubDocWriter();
            this.subDocEntry = openXMLSubDoc.getSubDocEntry();
            this.subSkelWriter = openXMLSubDoc.getSubSkelWriter();
            this.tempFile = openXMLSubDoc.getSubDocTempFile();
            this.subDocWriter.handleEvent(new Event(EventType.END_DOCUMENT, res));
            this.subDocWriter.close();
            this.zipOut.putNextEntry(new ZipEntry(this.subDocEntry.getName()));
            FileInputStream input = new FileInputStream(this.tempFile);
            while ((len = ((InputStream)input).read(this.buffer)) > 0) {
                this.zipOut.write(this.buffer, 0, len);
            }
            ((InputStream)input).close();
            this.zipOut.closeEntry();
            this.tempFile.delete();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing zip output file.");
        }
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (YamlParameters)params;
    }

    @Override
    public YamlParameters getParameters() {
        return this.params;
    }
}

