/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.ts;

import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends StringParameters {
    private static final String ESCAPEGT = "escapeGT";
    private static final String DECODEBYTEVALUES = "decodeByteValues";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public boolean getEscapeGT() {
        return this.getBoolean(ESCAPEGT);
    }

    public void setEscapeGT(boolean escapeGT) {
        this.setBoolean(ESCAPEGT, escapeGT);
    }

    public boolean getDecodeByteValues() {
        return this.getBoolean(DECODEBYTEVALUES);
    }

    public void setDecodeByteValues(boolean decodeByteValues) {
        this.setBoolean(DECODEBYTEVALUES, decodeByteValues);
    }

    @Override
    public void reset() {
        super.reset();
        this.setEscapeGT(false);
        this.setDecodeByteValues(false);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("%s, %d, {1}, \\n, \\r, \\t, etc.");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("%(([-0+#]?)[-0+#]?)((\\d\\$)?)(([\\d\\*]*)(\\.[\\d\\*]*)?)[dioxXucsfeEgGpn]");
        this.codeFinder.addRule("(\\\\r\\\\n)|\\\\a|\\\\b|\\\\f|\\\\n|\\\\r|\\\\t|\\\\v");
        this.codeFinder.addRule("\\{\\d[^\\\\]*?\\}");
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

