/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.xliff;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import net.sf.okapi.common.BOMNewlineEncodingDetector;
import net.sf.okapi.common.ClassUtil;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.annotation.ITSLQIAnnotations;
import net.sf.okapi.common.annotation.ITSProvenanceAnnotations;
import net.sf.okapi.common.annotation.XLIFFPhase;
import net.sf.okapi.common.annotation.XLIFFPhaseAnnotation;
import net.sf.okapi.common.annotation.XLIFFTool;
import net.sf.okapi.common.annotation.XLIFFToolAnnotation;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiIllegalFilterOperationException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.GenericFilterWriter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.filterwriter.ITSAnnotatorsRefContext;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.PipelineParameters;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.StartSubDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.xliff.Parameters;
import net.sf.okapi.filters.xliff.XLIFFITSFilterExtension;
import net.sf.okapi.filters.xliff.XLIFFSkeletonWriter;
import net.sf.okapi.filters.xliff.its.IITSDataStore;
import net.sf.okapi.filters.xliff.its.ITSDefaultDataStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UsingParameters(value=Parameters.class)
public class XLIFFFilter
implements IFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String PROP_BUILDNUM = "build-num";
    public static final String PROP_EXTRADATA = "extradata";
    public static final String PROP_WASSEGMENTED = "wassegmented";
    private static final String ALTTRANSTYPE_PROPOSAL = "proposal";
    private boolean hasNext;
    private XMLStreamReader reader;
    private RawDocument input;
    private String docName;
    private int tuId;
    private IdGenerator otherId;
    private IdGenerator groupId;
    private String startDocId;
    private LocaleId srcLang;
    private LocaleId trgLang;
    private LinkedList<Event> queue;
    private boolean canceled;
    private GenericSkeleton skel;
    private GenericSkeletonPart itsLQISource;
    private GenericSkeletonPart itsLQITarget;
    private GenericSkeletonPart itsProvSource;
    private GenericSkeletonPart itsProvTarget;
    private GenericSkeletonPart itsMtConfTarget;
    private Stack<String> inITSStandoff = new Stack();
    private StartSubDocument startSubDoc;
    private ITextUnit tu;
    private int approved;
    private Parameters params = new Parameters();
    private boolean sourceDone;
    private boolean targetDone;
    private boolean altTransDone;
    private boolean segSourceDone;
    private String encoding;
    private Stack<String> parentIds;
    private List<String> groupUsedIds;
    private AltTranslationsAnnotation altTrans;
    private int altTransQuality;
    private MatchType altTransMatchType;
    private String altTransOrigin;
    private String altTransEngine;
    private boolean inAltTrans;
    private boolean processAltTrans;
    private Stack<Boolean> preserveSpaces;
    private String lineBreak;
    private boolean hasUTF8BOM;
    private EncoderManager encoderManager;
    private int autoMid;
    private XLIFFITSFilterExtension itsFilterHandler;
    private ITSAnnotatorsRefContext annotatorsRef;
    private int extraId;
    private StartDocument startDoc;

    @Override
    public void cancel() {
        this.canceled = true;
    }

    @Override
    public void close() {
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            this.hasNext = false;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public String getName() {
        return "okf_xliff";
    }

    @Override
    public String getDisplayName() {
        return "XLIFF Filter";
    }

    @Override
    public String getMimeType() {
        return "application/x-xliff+xml";
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), "application/x-xliff+xml", this.getClass().getName(), "XLIFF", "Configuration for XML Localisation Interchange File Format (XLIFF) documents.", null, ".xlf;.xliff;.sdlxliff;.mxliff"));
        return list;
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("application/x-xliff+xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    public LocaleId getCurrentTargetLocale() {
        return this.trgLang;
    }

    @Override
    public Event next() {
        try {
            if (this.canceled) {
                this.queue.clear();
                this.queue.add(new Event(EventType.CANCELED));
                this.hasNext = false;
            }
            if (this.queue.isEmpty() && !this.read()) {
                Ending ending = new Ending(this.otherId.createId());
                ending.setSkeleton(this.skel);
                this.queue.add(new Event(EventType.END_DOCUMENT, ending));
            }
            if (this.queue.peek().getEventType() == EventType.END_DOCUMENT) {
                this.hasNext = false;
            }
            return this.queue.poll();
        }
        catch (IOException | XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.open(input, generateSkeleton, new ITSDefaultDataStore());
    }

    public void open(RawDocument input, boolean generateSkeleton, IITSDataStore datastore) {
        try {
            InputStreamReader inStreamReader;
            this.canceled = false;
            this.input = input;
            XMLInputFactory fact = null;
            if (this.params.getUseCustomParser()) {
                Class<?> factClass = ClassUtil.getClass(this.params.getFactoryClass());
                fact = (XMLInputFactory)factClass.newInstance();
            } else {
                fact = XMLInputFactory.newInstance();
            }
            this.logger.debug("XMLInputFactory: {}", (Object)fact.getClass().getName());
            fact.setProperty("javax.xml.stream.isCoalescing", true);
            fact.setProperty("javax.xml.stream.supportDTD", false);
            input.setEncoding("UTF-8");
            BOMNewlineEncodingDetector detector = new BOMNewlineEncodingDetector(input.getStream(), input.getEncoding());
            detector.detectBom();
            String inStreamCharset = "UTF-8";
            if (detector.isAutodetected()) {
                inStreamCharset = detector.getEncoding();
            }
            try {
                inStreamReader = this.createStreamReader(input, inStreamCharset);
                Throwable throwable = null;
                try {
                    XMLEventReader eventReader = null != input.getInputURI() ? fact.createXMLEventReader(input.getInputURI().toString(), inStreamReader) : fact.createXMLEventReader(inStreamReader);
                    this.itsFilterHandler = new XLIFFITSFilterExtension(fact, datastore, input.getInputURI(), this);
                    this.itsFilterHandler.parseInDocumentITSStandoff(eventReader, inStreamCharset);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inStreamReader != null) {
                        if (throwable != null) {
                            try {
                                inStreamReader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            inStreamReader.close();
                        }
                    }
                }
            }
            catch (IOException e) {
                throw new OkapiIOException(e);
            }
            inStreamReader = this.createStreamReader(input, inStreamCharset);
            this.reader = null != input.getInputURI() ? fact.createXMLStreamReader(input.getInputURI().toString(), inStreamReader) : fact.createXMLStreamReader(inStreamReader);
            this.itsFilterHandler.setXLIFFReader(this.reader);
            String realEnc = this.reader.getCharacterEncodingScheme();
            this.encoding = realEnc != null ? realEnc : input.getEncoding();
            this.annotatorsRef = new ITSAnnotatorsRefContext(this.reader);
            this.srcLang = input.getSourceLocale();
            if (this.srcLang == null) {
                throw new NullPointerException("Source language not set.");
            }
            this.trgLang = input.getTargetLocale();
            if (this.trgLang == null) {
                throw new NullPointerException("Target language not set.");
            }
            this.hasUTF8BOM = detector.hasUtf8Bom();
            this.lineBreak = detector.getNewlineType().toString();
            if (input.getInputURI() != null) {
                this.docName = input.getInputURI().getPath();
            }
            this.preserveSpaces = new Stack();
            this.preserveSpaces.push(false);
            this.parentIds = new Stack();
            this.parentIds.push("p0");
            this.tuId = 0;
            this.groupId = new IdGenerator(null, "g");
            this.otherId = new IdGenerator(null, "d");
            this.hasNext = true;
            this.queue = new LinkedList();
            this.groupUsedIds = new ArrayList<String>();
            this.startDocId = this.otherId.createId();
            this.startDoc = new StartDocument(this.startDocId);
            this.startDoc.setName(this.docName);
            this.startDoc.setEncoding(this.encoding, this.hasUTF8BOM);
            this.startDoc.setLocale(this.srcLang);
            this.startDoc.setFilterParameters(this.getParameters());
            this.startDoc.setFilterWriter(this.createFilterWriter());
            this.startDoc.setType("application/x-xliff+xml");
            this.startDoc.setMimeType("application/x-xliff+xml");
            this.startDoc.setMultilingual(true);
            this.startDoc.setLineBreak(this.lineBreak);
            this.queue.add(new Event(EventType.START_DOCUMENT, this.startDoc));
            this.skel = new GenericSkeleton();
            this.startDoc.setProperty(new Property("encoding", this.encoding, false));
            this.skel.append("<?xml version=\"1.0\" encoding=\"");
            this.skel.addValuePlaceholder(this.startDoc, "encoding", LocaleId.EMPTY);
            this.skel.append("\"?>");
            this.startDoc.setSkeleton(this.skel);
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new OkapiIOException("Cannot open XML document.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        XLIFFSkeletonWriter writer = new XLIFFSkeletonWriter(this.params);
        if (this.itsFilterHandler != null && this.itsFilterHandler.getITSStandoffManager() != null) {
            writer.setITSStandoffManager(this.itsFilterHandler.getITSStandoffManager());
        }
        return writer;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new GenericFilterWriter(this.createSkeletonWriter(), this.getEncoderManager());
    }

    public InputStreamReader createStreamReader(RawDocument input, String charset) {
        InputStreamReader inputStreamReader;
        try {
            inputStreamReader = new InputStreamReader(input.getStream(), charset);
        }
        catch (UnsupportedEncodingException e) {
            this.logger.warn("Invalid encoding '{}', using default.", (Object)charset);
            inputStreamReader = new InputStreamReader(input.getStream());
        }
        return inputStreamReader;
    }

    private boolean read() throws XMLStreamException, IOException {
        this.skel = new GenericSkeleton();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    String name = this.reader.getLocalName();
                    if ("trans-unit".equals(name)) {
                        return this.processTransUnit();
                    }
                    if ("file".equals(name)) {
                        return this.processStartFile();
                    }
                    if ("group".equals(name)) {
                        if (!this.processStartGroup()) break;
                        return true;
                    }
                    if ("bin-unit".equals(name)) {
                        if (!this.processStartBinUnit()) break;
                        return true;
                    }
                    this.storeStartElement(false, false, false);
                    break;
                }
                case 2: {
                    this.storeEndElement();
                    if ("file".equals(this.reader.getLocalName())) {
                        return this.processEndFile();
                    }
                    if ("group".equals(this.reader.getLocalName())) {
                        return this.processEndGroup();
                    }
                    if (!"bin-unit".equals(this.reader.getLocalName())) break;
                    return this.processEndBinUnit();
                }
                case 6: 
                case 12: {
                    if (!this.inITSStandoff.isEmpty()) break;
                    this.skel.append(this.reader.getText().replace("\n", this.lineBreak));
                    break;
                }
                case 4: {
                    if (!this.inITSStandoff.isEmpty()) break;
                    this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                    break;
                }
                case 5: {
                    this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                    break;
                }
                case 3: {
                    this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    break;
                }
                case 11: {
                    break;
                }
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
                case 7: {
                    break;
                }
            }
        }
        return false;
    }

    private boolean processStartFile() {
        if (!this.skel.isEmpty(true)) {
            DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
            this.skel = new GenericSkeleton();
            this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
        }
        this.startSubDoc = new StartSubDocument(this.startDocId, this.otherId.createId());
        this.storeStartElementFile(this.startSubDoc);
        String tmp = this.reader.getAttributeValue(null, "original");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'original'.");
        }
        this.startSubDoc.setName(tmp);
        tmp = this.reader.getAttributeValue(null, "source-language");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'source-language'.");
        }
        LocaleId srcXliffLang = LocaleId.fromString(tmp);
        if (!LocaleId.EMPTY.equals(this.input.getSourceLocale()) && !srcXliffLang.equals(this.srcLang)) {
            this.logger.warn("The source language declared in <file> is '{}' not '{}'.", (Object)tmp, (Object)this.srcLang);
        }
        Property prop = this.startSubDoc.getProperty("targetLanguage");
        LocaleId trgXliffLang = null;
        if (prop != null) {
            trgXliffLang = LocaleId.fromString(prop.getValue());
            if (this.params.getOverrideTargetLanguage()) {
                prop.setValue(this.trgLang.toBCP47());
            } else if (!LocaleId.EMPTY.equals(this.input.getTargetLocale()) && !trgXliffLang.sameLanguageAs(this.trgLang)) {
                this.logger.warn("The target language declared in <file> is '{}' not '{}'. '{}' will be used.", prop.getValue(), this.trgLang, prop.getValue());
                this.trgLang = trgXliffLang;
            }
        }
        if ((tmp = this.reader.getAttributeValue(null, "datatype")) != null) {
            if (tmp.equals("x-undefined")) {
                tmp = null;
            } else if (tmp.equals("html")) {
                tmp = "text/html";
            } else if (tmp.equals("xml")) {
                tmp = "text/xml";
            }
            this.startSubDoc.setMimeType(tmp);
        }
        if ((tmp = this.reader.getAttributeValue(null, PROP_BUILDNUM)) != null) {
            this.startSubDoc.setProperty(new Property(PROP_BUILDNUM, tmp, true));
        }
        if (this.annotatorsRef.peek() != null) {
            GenericAnnotations.addAnnotations(this.startSubDoc, new GenericAnnotations(this.annotatorsRef.getAnnotation()));
        }
        try {
            Stack<String> xmlDOMPosition = new Stack<String>();
            xmlDOMPosition.push("file");
            boolean addedToolProp = false;
            XLIFFToolAnnotation toolAnn = null;
            XLIFFTool tool = null;
            boolean addedPhaseProp = false;
            XLIFFPhaseAnnotation phaseAnn = null;
            XLIFFPhase phase = null;
            ITSProvenanceAnnotations prov = this.itsFilterHandler.readITSProvenance();
            ITSProvenanceAnnotations.addAnnotations(this.startSubDoc, prov);
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        String startElementName = this.reader.getLocalName();
                        if ("tool".equals(startElementName)) {
                            this.removeEndingSkeletonWhitespace();
                            tool = new XLIFFTool(this.reader.getAttributeValue(null, "tool-id"), this.reader.getAttributeValue(null, "tool-name"));
                            tool.setVersion(this.reader.getAttributeValue(null, "tool-version"));
                            tool.setCompany(this.reader.getAttributeValue(null, "tool-company"));
                            toolAnn = this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class) == null ? new XLIFFToolAnnotation() : this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class);
                            toolAnn.add(tool, this.startSubDoc);
                            this.startSubDoc.setAnnotation(toolAnn);
                        } else if ("phase-group".equals(startElementName)) {
                            this.removeEndingSkeletonWhitespace();
                        } else if ("phase".equals(startElementName)) {
                            this.removeEndingSkeletonWhitespace();
                            phase = new XLIFFPhase(this.reader.getAttributeValue(null, "phase-name"), this.reader.getAttributeValue(null, "process-name"));
                            phaseAnn = this.startSubDoc.getAnnotation(XLIFFPhaseAnnotation.class) == null ? new XLIFFPhaseAnnotation() : this.startSubDoc.getAnnotation(XLIFFPhaseAnnotation.class);
                            phaseAnn.add(phase, this.startSubDoc);
                            this.startSubDoc.setAnnotation(phaseAnn);
                        } else if (!("sk1".equals(startElementName) || "glossary".equals(startElementName) || "reference".equals(startElementName) || "count-group".equals(startElementName) || "prop-group".equals(startElementName) || "note".equals(startElementName) || !((String)xmlDOMPosition.peek()).equals("header"))) {
                            if (!addedPhaseProp) {
                                this.addPhasePropertyPlaceholder(this.skel, this.startSubDoc, phaseAnn);
                                addedPhaseProp = true;
                            }
                            if (!addedToolProp) {
                                this.addToolPropertyPlaceholder(this.skel, this.startSubDoc, toolAnn);
                                addedToolProp = true;
                            }
                            this.storeStartElement(false, false, false);
                        } else {
                            if ("body".equals(startElementName)) {
                                this.storeStartElement(false, false, false);
                                this.startSubDoc.setSkeleton(this.skel);
                                this.queue.add(new Event(EventType.START_SUBDOCUMENT, this.startSubDoc));
                                PipelineParameters pp = null;
                                if (LocaleId.EMPTY.equals(this.input.getSourceLocale()) || LocaleId.EMPTY.equals(this.input.getTargetLocale())) {
                                    pp = new PipelineParameters(this.startDoc, this.input, null, null);
                                }
                                if (LocaleId.EMPTY.equals(this.input.getSourceLocale())) {
                                    this.srcLang = srcXliffLang;
                                    pp.setSourceLocale(this.srcLang);
                                }
                                if (LocaleId.EMPTY.equals(this.input.getTargetLocale())) {
                                    this.trgLang = trgXliffLang;
                                    pp.setTargetLocale(this.trgLang);
                                }
                                if (pp != null) {
                                    this.queue.add(new Event(EventType.PIPELINE_PARAMETERS, pp));
                                }
                                return true;
                            }
                            if ("trans-unit".equals(startElementName) || "group".equals(startElementName)) {
                                throw new OkapiIOException("Missing <body> element.");
                            }
                            this.storeStartElement(false, false, false);
                        }
                        xmlDOMPosition.push(startElementName);
                        break;
                    }
                    case 2: {
                        String startElement;
                        String prefix;
                        StringBuilder endElementXML;
                        String endElementName = this.reader.getLocalName();
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            if (!endElementName.equals("tool")) {
                                endElementXML = new StringBuilder();
                                prefix = this.reader.getPrefix();
                                endElementXML.append("</").append(prefix != null && prefix.length() > 0 ? prefix + ":" : "").append(endElementName).append(">");
                                tool.addSkeletonContent(endElementXML.toString());
                            }
                        } else if (!((String)xmlDOMPosition.peek()).equals("phase-group")) {
                            if (((String)xmlDOMPosition.peek()).equals("phase")) {
                                if (!endElementName.equals("phase")) {
                                    endElementXML = new StringBuilder();
                                    prefix = this.reader.getPrefix();
                                    endElementXML.append("</").append(prefix != null && prefix.length() > 0 ? prefix + ":" : "").append(endElementName).append(">");
                                    phase.addSkeletonContent(endElementXML.toString());
                                }
                            } else if (endElementName.equals("header")) {
                                if (!addedPhaseProp) {
                                    this.addPhasePropertyPlaceholder(this.skel, this.startSubDoc, phaseAnn);
                                    addedPhaseProp = true;
                                }
                                if (!addedToolProp) {
                                    this.addToolPropertyPlaceholder(this.skel, this.startSubDoc, toolAnn);
                                    addedToolProp = true;
                                }
                                this.storeEndElement();
                            } else {
                                this.storeEndElement();
                            }
                        }
                        if ((startElement = (String)xmlDOMPosition.pop()).equals(endElementName)) break;
                        throw new OkapiIOException("Mismatch in start and end element XML stream events: " + startElement + " != " + endElementName);
                    }
                    case 6: 
                    case 12: {
                        String cdata = this.reader.getText().replace("\n", this.lineBreak);
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(cdata);
                            break;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(cdata);
                            break;
                        }
                        this.skel.append(cdata);
                        break;
                    }
                    case 4: {
                        String skelChars = Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null);
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(skelChars);
                            break;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(skelChars);
                            break;
                        }
                        this.skel.append(skelChars);
                        break;
                    }
                    case 5: {
                        String skelComment = "<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->";
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(skelComment);
                            break;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(skelComment);
                            break;
                        }
                        this.skel.append(skelComment);
                        break;
                    }
                    case 3: {
                        String skelPI = "<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>";
                        if (((String)xmlDOMPosition.peek()).equals("tool")) {
                            tool.addSkeletonContent(skelPI);
                            break;
                        }
                        if (((String)xmlDOMPosition.peek()).equals("phase")) {
                            phase.addSkeletonContent(skelPI);
                            break;
                        }
                        this.skel.append(skelPI);
                        break;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
        return true;
    }

    private void addToolPropertyPlaceholder(GenericSkeleton skeleton, StartSubDocument startSubDoc, XLIFFToolAnnotation toolAnn) {
        this.addPropertyPlaceholder(skeleton, "tool", startSubDoc, toolAnn != null ? toolAnn.toXML() : "");
    }

    private void addPhasePropertyPlaceholder(GenericSkeleton skeleton, StartSubDocument startSubDoc, XLIFFPhaseAnnotation phaseAnn) {
        this.addPropertyPlaceholder(skeleton, "phase", startSubDoc, phaseAnn != null ? phaseAnn.toXML() : "");
    }

    private void addPropertyPlaceholder(GenericSkeleton skeleton, String propertyName, INameable referent, String initialValue) {
        Property property;
        skeleton.addValuePlaceholder(referent, propertyName, LocaleId.EMPTY);
        Property property2 = property = referent.getProperty(propertyName) != null ? referent.getProperty(propertyName) : new Property(propertyName, "");
        if (initialValue != null) {
            property.setValue(initialValue);
        }
        referent.setProperty(property);
    }

    private boolean processEndFile() {
        Ending ending = new Ending(this.otherId.createId());
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_SUBDOCUMENT, ending));
        return true;
    }

    private void removeEndingSkeletonWhitespace() {
        GenericSkeletonPart part = this.skel.getLastPart();
        if (part != null) {
            part.setData(part.toString().replaceAll("[\\s\\n\\r]+$", ""));
        }
    }

    private void storeStartElement(boolean updateLangWithTarget, boolean addApprovedIfNeeded, boolean mtConfTarget) {
        this.annotatorsRef.readAndPush();
        String prefix = this.reader.getPrefix();
        if (!"its".equals(prefix)) {
            this.storeElementName(prefix);
            boolean ps = this.preserveSpaces.peek();
            String itsLQIRef = "";
            String itsProvRef = "";
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                String attrPrefix = this.reader.getAttributePrefix(i);
                String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.reader.getAttributeLocalName(i);
                String attrValue = this.reader.getAttributeValue(i);
                if (attrName.equals("xml:lang") && updateLangWithTarget) {
                    attrValue = this.trgLang.toBCP47();
                }
                if (attrName.equals("xml:space")) {
                    ps = attrValue.equals("preserve");
                }
                if ("approved".equals(this.reader.getAttributeLocalName(i))) {
                    this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
                    addApprovedIfNeeded = false;
                    continue;
                }
                if (attrName.equals("its:locQualityIssuesRef")) {
                    itsLQIRef = " its:locQualityIssuesRef=\"" + attrValue + "\"";
                    continue;
                }
                if (attrName.startsWith("its:locQuality")) {
                    itsLQIRef = " its:locQualityIssuesRef=\"\"";
                    continue;
                }
                if (attrName.equals("its:provenanceRecordsRef")) {
                    itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                    continue;
                }
                if (mtConfTarget && attrName.equals("its:mtConfidence") || mtConfTarget && attrName.equals("its:annotatorsRef") && attrValue.startsWith("mt-confidence|")) continue;
                if (attrName.startsWith("its:rev") || attrName.startsWith("its:person") || attrName.startsWith("its:org") || attrName.startsWith("its:tool") || attrName.startsWith("its:prov")) {
                    itsProvRef = " its:provenanceRecordsRef=\"\"";
                    continue;
                }
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
                this.skel.append("\"");
            }
            if (this.reader.getLocalName().equals("trans-unit")) {
                this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                this.tu.setProperty(new Property("locQualityIssuesRef", itsLQIRef));
                this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
                this.tu.setProperty(new Property("provenanceRecordsRef", itsProvRef));
            } else if (this.reader.getLocalName().equals("source")) {
                this.itsLQISource = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                this.itsProvSource = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
            } else if (this.reader.getLocalName().equals("target")) {
                if (mtConfTarget) {
                    this.itsMtConfTarget = this.skel.addValuePlaceholder(this.tu, "mtConfidence", LocaleId.EMPTY);
                }
                this.itsLQITarget = this.skel.addValuePlaceholder(this.tu, "locQualityIssuesRef", LocaleId.EMPTY);
                this.itsProvTarget = this.skel.addValuePlaceholder(this.tu, "provenanceRecordsRef", LocaleId.EMPTY);
            }
            if (addApprovedIfNeeded) {
                this.skel.addValuePlaceholder(this.tu, "approved", this.trgLang);
            }
            this.skel.append(">");
            this.preserveSpaces.push(ps);
        } else {
            this.removeEndingSkeletonWhitespace();
            this.inITSStandoff.push(prefix);
        }
    }

    private void storeStartElementFile(StartSubDocument startSubDoc) {
        this.annotatorsRef.readAndPush();
        this.storeElementName(this.reader.getPrefix());
        boolean ps = this.preserveSpaces.peek();
        boolean hasTargetlanguage = false;
        String itsProvRef = "";
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.reader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.reader.getAttributeLocalName(i);
            String attrValue = this.reader.getAttributeValue(i);
            if (this.reader.getAttributeLocalName(i).equals("target-language")) {
                hasTargetlanguage = true;
                startSubDoc.setProperty(new Property("targetLanguage", attrValue, false));
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.addValuePlaceholder(startSubDoc, "targetLanguage", LocaleId.EMPTY);
                this.skel.append("\"");
                continue;
            }
            if (this.reader.getAttributeLocalName(i).equals("source-language")) {
                startSubDoc.setProperty(new Property("sourceLanguage", attrValue));
                this.skel.append(" ");
                this.skel.append(attrName);
                this.skel.append("=\"");
                this.skel.addValuePlaceholder(startSubDoc, "sourceLanguage", LocaleId.EMPTY);
                this.skel.append("\"");
                continue;
            }
            if (attrName.equals("its:provenanceRecordsRef")) {
                itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                continue;
            }
            if (attrName.startsWith("its:rev") || attrName.startsWith("its:person") || attrName.startsWith("its:org") || attrName.startsWith("its:tool") || attrName.startsWith("its:prov")) {
                itsProvRef = " its:provenanceRecordsRef=\"\"";
                continue;
            }
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            this.skel.append("\"");
            if (!attrName.equals("xml:space")) continue;
            ps = attrValue.equals("preserve");
        }
        this.skel.addValuePlaceholder(startSubDoc, "provenanceRecordsRef", LocaleId.EMPTY);
        startSubDoc.setProperty(new Property("provenanceRecordsRef", itsProvRef));
        if (this.params.getAddTargetLanguage() && !hasTargetlanguage) {
            startSubDoc.setProperty(new Property("targetLanguage", this.trgLang.toBCP47(), false));
            this.skel.append(" target-language=\"");
            this.skel.addValuePlaceholder(startSubDoc, "targetLanguage", LocaleId.EMPTY);
            this.skel.append("\"");
        }
        this.skel.append(">");
        this.preserveSpaces.push(ps);
    }

    private void storeStartElementGroup(StartGroup group) {
        this.annotatorsRef.readAndPush();
        this.storeElementName(this.reader.getPrefix());
        boolean ps = this.preserveSpaces.peek();
        String itsProvRef = "";
        int count = this.reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            String attrPrefix = this.reader.getAttributePrefix(i);
            String attrName = (attrPrefix == null || attrPrefix.length() == 0 ? "" : attrPrefix + ":") + this.reader.getAttributeLocalName(i);
            String attrValue = this.reader.getAttributeValue(i);
            if (attrName.equals("xml:space")) {
                ps = attrValue.equals("preserve");
            }
            if (attrName.equals("its:provenanceRecordsRef")) {
                itsProvRef = " its:provenanceRecordsRef=\"" + attrValue + "\"";
                continue;
            }
            if (attrName.startsWith("its:rev") || attrName.startsWith("its:person") || attrName.startsWith("its:org") || attrName.startsWith("its:tool") || attrName.startsWith("its:prov")) {
                itsProvRef = " its:provenanceRecordsRef=\"\"";
                continue;
            }
            this.skel.append(" ");
            this.skel.append(attrName);
            this.skel.append("=\"");
            this.skel.append(Util.escapeToXML(attrValue.replace("\n", this.lineBreak), 3, this.params.getEscapeGT(), null));
            this.skel.append("\"");
        }
        this.skel.addValuePlaceholder(group, "provenanceRecordsRef", LocaleId.EMPTY);
        group.setProperty(new Property("provenanceRecordsRef", itsProvRef));
        this.skel.append(">");
        this.preserveSpaces.push(ps);
    }

    private void storeElementName(String prefix) {
        if (prefix == null || prefix.length() == 0) {
            this.skel.append("<" + this.reader.getLocalName());
        } else {
            this.skel.append("<" + prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (int i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            this.skel.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                this.skel.append(":" + prefix);
            }
            this.skel.append("=\"");
            this.skel.append(this.reader.getNamespaceURI(i));
            this.skel.append("\"");
        }
    }

    private void storeEndElement() {
        String prefix = this.reader.getPrefix();
        if (!"its".equals(prefix)) {
            if (prefix != null && prefix.length() > 0) {
                this.skel.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
            } else {
                this.skel.append("</" + this.reader.getLocalName() + ">");
            }
            this.preserveSpaces.pop();
        } else {
            this.inITSStandoff.pop();
        }
        this.annotatorsRef.pop();
    }

    private boolean processTransUnit() throws IOException {
        try {
            XLIFFPhaseAnnotation phaseAnn;
            if (!this.skel.isEmpty(true)) {
                DocumentPart dp = new DocumentPart(this.otherId.createId(), false, this.skel);
                this.skel = new GenericSkeleton();
                this.queue.add(new Event(EventType.DOCUMENT_PART, dp));
            }
            this.sourceDone = false;
            this.targetDone = false;
            this.altTransDone = false;
            this.segSourceDone = false;
            this.altTrans = null;
            this.processAltTrans = false;
            this.inAltTrans = false;
            this.segSourceDone = false;
            this.extraId = Integer.MAX_VALUE;
            this.tu = new TextUnit(String.valueOf(++this.tuId));
            this.storeStartElement(false, true, false);
            String tmp = this.reader.getAttributeValue(null, "translate");
            if (tmp != null) {
                this.tu.setIsTranslatable(tmp.equals("yes"));
            }
            if ((tmp = this.reader.getAttributeValue(null, "id")) == null) {
                throw new OkapiIllegalFilterOperationException("Missing attribute 'id'.");
            }
            this.tu.setId(tmp);
            tmp = this.reader.getAttributeValue(null, "resname");
            if (tmp != null) {
                this.tu.setName(tmp);
            } else if (this.params.getFallbackToID()) {
                this.tu.setName(this.tu.getId());
            }
            tmp = this.reader.getAttributeValue(null, "phase-name");
            if (tmp != null && (phaseAnn = this.startSubDoc.getAnnotation(XLIFFPhaseAnnotation.class)) != null && phaseAnn.get(tmp) != null) {
                XLIFFPhaseAnnotation tuPhaseAnn = new XLIFFPhaseAnnotation();
                tuPhaseAnn.add(phaseAnn.get(tmp));
                this.tu.setAnnotation(tuPhaseAnn);
            }
            if ((tmp = this.reader.getAttributeValue(null, PROP_EXTRADATA)) != null) {
                this.tu.setProperty(new Property(PROP_EXTRADATA, tmp, true));
            }
            this.approved = -1;
            tmp = this.reader.getAttributeValue(null, "approved");
            if (tmp != null) {
                this.approved = 0;
                if (tmp.equals("yes")) {
                    this.approved = 1;
                }
            }
            this.itsFilterHandler.readTextUnitITSAttributes(this.tu);
            this.tu.setType(this.reader.getAttributeValue(null, "restype"));
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if ("source".equals(name)) {
                            if (this.inAltTrans) {
                                if (!this.params.getEditAltTrans()) {
                                    this.storeStartElement(false, false, false);
                                }
                            } else {
                                this.storeStartElement(false, false, false);
                            }
                            this.processSource(false);
                            if (this.inAltTrans) {
                                if (this.params.getEditAltTrans()) break;
                                this.storeEndElement();
                                break;
                            }
                            this.storeEndElement();
                            break;
                        }
                        if ("target".equals(name)) {
                            this.addSegSourceIfNeeded();
                            if (this.inAltTrans) {
                                if (!this.params.getEditAltTrans()) {
                                    this.storeStartElement(this.params.getOverrideTargetLanguage(), false, false);
                                }
                            } else {
                                this.storeStartElement(this.params.getOverrideTargetLanguage(), false, true);
                            }
                            this.processTarget();
                            if (this.inAltTrans) {
                                if (this.params.getEditAltTrans()) break;
                                this.storeEndElement();
                                break;
                            }
                            this.storeEndElement();
                            break;
                        }
                        if ("seg-source".equals(name)) {
                            this.skel.add("[@#$SEGSRC$#@]");
                            this.skel.attachParent(this.tu);
                            this.storeStartElement(false, false, false);
                            this.processSource(true);
                            this.storeEndElement();
                            this.skel.flushPart();
                            this.segSourceDone = true;
                            if (!this.tu.getSource().hasBeenSegmented()) break;
                            this.tu.setProperty(new Property(PROP_WASSEGMENTED, "true", true));
                            break;
                        }
                        if ("note".equals(name)) {
                            this.addTargetIfNeeded();
                            this.storeStartElement(false, false, false);
                            this.processNote();
                            this.storeEndElement();
                            break;
                        }
                        if ("alt-trans".equals(name)) {
                            this.addTargetIfNeeded();
                            if (!this.params.getEditAltTrans()) {
                                this.storeStartElement(false, false, false);
                            }
                            this.processStartAltTrans();
                            break;
                        }
                        this.addTargetIfNeeded();
                        this.storeStartElement(false, false, false);
                        break;
                    }
                    case 2: {
                        String name = this.reader.getLocalName();
                        if ("trans-unit".equals(name)) {
                            this.addTargetIfNeeded();
                            this.storeEndElement();
                            if (this.altTrans != null) {
                                this.altTrans.sort();
                            }
                            if (this.params.getIgnoreInputSegmentation()) {
                                this.tu.removeAllSegmentations();
                            }
                            this.tu.setSkeleton(this.skel);
                            this.tu.setMimeType("application/x-xliff+xml");
                            this.queue.add(new Event(EventType.TEXT_UNIT, this.tu));
                            return true;
                        }
                        if ("alt-trans".equals(name)) {
                            this.inAltTrans = false;
                            if (this.params.getEditAltTrans()) break;
                            this.storeEndElement();
                            break;
                        }
                        this.storeEndElement();
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        if (!this.targetDone) {
                            tmp = this.reader.getText();
                            for (int i = 0; i < tmp.length(); ++i) {
                                if (Character.isWhitespace(tmp.charAt(i))) continue;
                                this.addTargetIfNeeded();
                                break;
                            }
                        }
                        this.skel.append(Util.escapeToXML(this.reader.getText().replace("\n", this.lineBreak), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 5: {
                        this.skel.append("<!--" + this.reader.getText().replace("\n", this.lineBreak) + "-->");
                        break;
                    }
                    case 3: {
                        this.skel.append("<?" + this.reader.getPITarget() + " " + this.reader.getPIData() + "?>");
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return false;
    }

    private void processSource(boolean isSegSource) throws IOException {
        if (this.sourceDone) {
            String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            LocaleId lang = tmp == null ? this.srcLang : LocaleId.fromString(tmp);
            boolean tmpStore = true;
            if (this.inAltTrans && this.params.getEditAltTrans()) {
                tmpStore = false;
            }
            TextContainer tc = this.processContent(isSegSource ? "seg-source" : "source", tmpStore);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            if (this.inAltTrans) {
                if (this.processAltTrans) {
                    if (isSegSource) {
                        this.logger.warn("Segmented content in <alt-trans> is not supported (entry id='{}').", (Object)this.tu.getId());
                    } else {
                        AltTranslation alt = this.altTrans.add(lang, null, null, tc.getFirstContent(), null, this.altTransMatchType, 0, this.altTransOrigin);
                        alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                        alt.setEngine(this.altTransEngine);
                        XLIFFToolAnnotation toolAnn = this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class);
                        if (toolAnn != null) {
                            alt.setTool(toolAnn.get(this.altTrans.getCurrentToolId()));
                        }
                        if (this.altTransQuality > 0) {
                            alt.setCombinedScore(this.altTransQuality);
                        }
                    }
                }
            } else {
                TextContainer cont = tc.clone();
                cont.getSegments().joinAll();
                if (!this.params.isAlwaysUseSegSource() && cont.compareTo(this.tu.getSource(), true) != 0) {
                    this.logger.warn("The <seg-source> content for the entry id='{}' is different from its <source>. The un-segmented content of <source> will be used.", (Object)this.tu.getId());
                } else {
                    GenericAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(GenericAnnotations.class));
                    ITSLQIAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(ITSLQIAnnotations.class));
                    ITSProvenanceAnnotations.addAnnotations(tc, this.tu.getSource().getAnnotation(ITSProvenanceAnnotations.class));
                    tc.setProperty(this.tu.getSource().getProperty("locQualityIssuesRef"));
                    tc.setProperty(this.tu.getSource().getProperty("provenanceRecordsRef"));
                    tc.setHasBeenSegmentedFlag(true);
                    this.tu.setSource(tc);
                    this.itsLQISource.setParent(tc);
                    this.itsProvSource.setParent(tc);
                }
            }
        } else {
            String tmp = this.reader.getAttributeValue(null, "coord");
            if (tmp != null) {
                this.tu.setSourceProperty(new Property("coordinates", tmp, true));
            }
            GenericAnnotations anns = this.itsFilterHandler.readTextContainerITSAttributes();
            ITSLQIAnnotations lqiAnn = this.itsFilterHandler.readITSLQI();
            ITSProvenanceAnnotations provAnn = this.itsFilterHandler.readITSProvenance();
            String itsLQIRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            String itsProvRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            this.skel.addContentPlaceholder(this.tu);
            TextContainer tc = this.processContent(isSegSource ? "seg-source" : "source", false);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            this.tu.setPreserveWhitespaces(this.preserveSpaces.peek());
            tc.setProperty(new Property("locQualityIssuesRef", lqiAnn != null && itsLQIRef != null ? " its:locQualityIssuesRef=\"" + itsLQIRef + "\"" : ""));
            tc.setProperty(new Property("provenanceRecordsRef", provAnn != null && itsProvRef != null ? " its:provenanceRecordsRef=\"" + itsProvRef + "\"" : ""));
            GenericAnnotations.addAnnotations(tc, anns);
            ITSLQIAnnotations.addAnnotations(tc, lqiAnn);
            ITSProvenanceAnnotations.addAnnotations(tc, provAnn);
            this.itsLQISource.setParent(tc);
            this.itsProvSource.setParent(tc);
            this.tu.setSource(tc);
            this.sourceDone = true;
        }
    }

    private void processTarget() throws IOException {
        if (this.targetDone) {
            String tmp = this.reader.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
            LocaleId lang = tmp == null ? this.trgLang : LocaleId.fromString(tmp);
            boolean tmpStore = true;
            if (this.inAltTrans && this.params.getEditAltTrans()) {
                tmpStore = false;
            }
            TextContainer tc = this.processContent("target", tmpStore);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            if (this.inAltTrans && this.processAltTrans) {
                AltTranslation alt = this.altTrans.getLast();
                if (alt != null && alt.getTargetLocale() != null) {
                    alt = null;
                }
                if (alt == null) {
                    alt = this.altTrans.add(this.srcLang, null, null, null, null, this.altTransMatchType, 0, this.altTransOrigin);
                    alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                    alt.setEngine(this.altTransEngine);
                    XLIFFToolAnnotation toolAnn = this.startSubDoc.getAnnotation(XLIFFToolAnnotation.class);
                    if (toolAnn != null) {
                        alt.setTool(toolAnn.get(this.altTrans.getCurrentToolId()));
                    }
                    if (this.altTransQuality > 0) {
                        alt.setCombinedScore(this.altTransQuality);
                    }
                }
                if (tc.contentIsOneSegment()) {
                    alt.setTarget(lang, tc.getFirstContent());
                } else {
                    alt.setTarget(lang, tc.getUnSegmentedContentCopy());
                }
                alt.getEntry().setPreserveWhitespaces(this.preserveSpaces.peek());
                alt.setFromOriginal(true);
            }
        } else {
            String stateValue = this.reader.getAttributeValue(null, "state");
            String stateQualifier = this.reader.getAttributeValue(null, "state-qualifier");
            String coordValue = this.reader.getAttributeValue(null, "coord");
            GenericAnnotations anns = this.itsFilterHandler.readTextContainerITSAttributes();
            ITSLQIAnnotations lqiAnn = this.itsFilterHandler.readITSLQI();
            ITSProvenanceAnnotations provAnn = this.itsFilterHandler.readITSProvenance();
            String itsLQIRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "locQualityIssuesRef");
            String itsProvRef = this.reader.getAttributeValue("http://www.w3.org/2005/11/its", "provenanceRecordsRef");
            this.skel.addContentPlaceholder(this.tu, this.trgLang);
            TextContainer tc = this.processContent("target", false);
            if (!this.preserveSpaces.peek().booleanValue()) {
                tc.unwrap(true, false);
            }
            this.tu.setPreserveWhitespaces(this.preserveSpaces.peek());
            tc.setProperty(new Property("mtConfidence", ""));
            tc.setProperty(new Property("locQualityIssuesRef", lqiAnn != null && itsLQIRef != null ? " its:locQualityIssuesRef=\"" + itsLQIRef + "\"" : ""));
            tc.setProperty(new Property("provenanceRecordsRef", provAnn != null && itsProvRef != null ? " its:provenanceRecordsRef=\"" + itsProvRef + "\"" : ""));
            GenericAnnotations.addAnnotations(tc, anns);
            ITSLQIAnnotations.addAnnotations(tc, lqiAnn);
            ITSProvenanceAnnotations.addAnnotations(tc, provAnn);
            this.itsMtConfTarget.setParent(tc);
            this.itsLQITarget.setParent(tc);
            this.itsProvTarget.setParent(tc);
            this.tu.setTarget(this.trgLang, tc);
            if (stateValue != null) {
                this.tu.setTargetProperty(this.trgLang, new Property("state", stateValue, true));
            }
            if (stateQualifier != null) {
                this.tu.setTargetProperty(this.trgLang, new Property("state-qualifier", stateQualifier, false));
            }
            if (coordValue != null) {
                this.tu.setTargetProperty(this.trgLang, new Property("coordinates", coordValue, true));
            }
            if (this.approved > -1) {
                this.tu.setTargetProperty(this.trgLang, new Property("approved", this.approved == 1 ? "yes" : "no", false));
            }
            this.targetDone = true;
        }
    }

    private void processStartAltTrans() {
        this.inAltTrans = true;
        this.processAltTrans = true;
        String tmp = this.reader.getAttributeValue(null, "alttranstype");
        if (tmp != null && !tmp.equals(ALTTRANSTYPE_PROPOSAL)) {
            this.processAltTrans = false;
            return;
        }
        String mid = this.reader.getAttributeValue(null, "mid");
        this.altTransQuality = -1;
        tmp = this.reader.getAttributeValue(null, "match-quality");
        if (!Util.isEmpty(tmp) && Character.isDigit(tmp.charAt(0))) {
            if (tmp.endsWith("%")) {
                tmp = tmp.substring(0, tmp.length() - 1);
            }
            try {
                this.altTransQuality = Integer.valueOf(tmp);
                if (this.altTransQuality < 1) {
                    this.altTransQuality = -1;
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        this.altTransMatchType = MatchType.UKNOWN;
        tmp = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "matchType");
        if (!Util.isEmpty(tmp)) {
            this.altTransMatchType = MatchType.valueOf(tmp);
        }
        if (this.altTransMatchType.equals((Object)MatchType.UKNOWN)) {
            if (this.altTransQuality > 99) {
                this.altTransMatchType = MatchType.EXACT;
            } else if (this.altTransQuality > 0) {
                this.altTransMatchType = MatchType.FUZZY;
            }
        }
        this.altTransOrigin = "SourceDoc";
        tmp = this.reader.getAttributeValue(null, "origin");
        if (!Util.isEmpty(tmp)) {
            this.altTransOrigin = tmp;
        }
        this.altTransEngine = this.reader.getAttributeValue("okapi-framework:xliff-extensions", "engine");
        TextContainer tc = this.tu.getTarget(this.trgLang);
        if (tc == null) {
            tc = this.tu.createTarget(this.trgLang, false, 4);
        }
        if (mid == null) {
            this.altTrans = tc.getAnnotation(AltTranslationsAnnotation.class);
            if (this.altTrans == null) {
                this.altTrans = new AltTranslationsAnnotation();
                tc.setAnnotation(this.altTrans);
            }
            this.altTrans.setCurrentToolId(this.reader.getAttributeValue(null, "tool-id"));
        } else {
            Segment seg = tc.getSegments().get(mid);
            if (seg == null) {
                this.logger.warn("An <alt-trans> element for an unknown segment '{}' was detected. It will be ignored.", (Object)mid);
                this.processAltTrans = false;
                return;
            }
            this.altTrans = seg.getAnnotation(AltTranslationsAnnotation.class);
            if (this.altTrans == null) {
                this.altTrans = new AltTranslationsAnnotation();
                seg.setAnnotation(this.altTrans);
            }
            this.altTrans.setCurrentToolId(this.reader.getAttributeValue(null, "tool-id"));
        }
    }

    private void addSegSourceIfNeeded() {
        if (!this.segSourceDone) {
            this.skel.add("[@#$SEGSRC$#@]");
            this.skel.attachParent(this.tu);
            this.skel.flushPart();
            this.segSourceDone = true;
        }
    }

    private void addAltTransMarker() {
        if (this.altTransDone) {
            return;
        }
        this.skel.add("[@#$ALTTRANS$#@]");
        this.skel.attachParent(this.tu);
        this.skel.flushPart();
        this.altTransDone = true;
    }

    private void addTargetIfNeeded() {
        if (!this.sourceDone) {
            throw new OkapiIllegalFilterOperationException("Element <source> missing or not placed properly.");
        }
        if (this.targetDone) {
            this.addAltTransMarker();
            return;
        }
        this.addSegSourceIfNeeded();
        if (this.srcLang.equals(this.trgLang)) {
            return;
        }
        this.skel.append("<target xml:lang=\"");
        this.skel.append(this.trgLang.toString());
        this.skel.append("\">");
        this.skel.addContentPlaceholder(this.tu, this.trgLang);
        this.skel.append("</target>");
        this.skel.append(this.lineBreak);
        this.targetDone = true;
        this.addAltTransMarker();
    }

    private TextContainer processContent(String tagName, boolean store) throws IOException {
        try {
            boolean changeFirstPart = false;
            TextContainer content = new TextContainer();
            ISegments segments = content.getSegments();
            int id = 0;
            this.autoMid = -1;
            Stack<Integer> idStack = new Stack<Integer>();
            ArrayList<Integer> annIds = new ArrayList<Integer>();
            idStack.push(id);
            Segment segment = null;
            int segIdStack = -1;
            TextFragment current = new TextFragment();
            current.invalidate();
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        current.append(this.reader.getText());
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        break;
                    }
                    case 2: {
                        String name = this.reader.getLocalName();
                        if (name.equals(tagName)) {
                            if (!current.isEmpty()) {
                                content.append(current, !content.hasBeenSegmented(), !this.params.getBalanceCodes());
                            }
                            return content;
                        }
                        if (name.equals("mrk") && (Integer)idStack.peek() == segIdStack) {
                            current = new TextFragment();
                            current.invalidate();
                            idStack.pop();
                            segIdStack = -1;
                            String oriId = segment.getId();
                            segments.append(segment, !content.hasBeenSegmented());
                            if (changeFirstPart && content.count() == 2) {
                                changeFirstPart = false;
                                content.changePart(0);
                                segment.forceId(oriId);
                            }
                            if (store) {
                                this.storeEndElement();
                                break;
                            }
                            this.annotatorsRef.pop();
                            break;
                        }
                        if (!name.equals("g") && !name.equals("mrk")) break;
                        if (store) {
                            this.storeEndElement();
                        } else {
                            this.annotatorsRef.pop();
                        }
                        Code code = current.append(TextFragment.TagType.CLOSING, name, "");
                        id = (Integer)idStack.pop();
                        code.setId(id);
                        String tmp = this.reader.getPrefix();
                        if (tmp != null && tmp.length() > 0) {
                            code.setOuterData("</" + tmp + ":" + name + ">");
                        } else {
                            code.setOuterData("</" + name + ">");
                        }
                        if (!name.equals("mrk")) break;
                        int n = -1;
                        n = annIds.indexOf(id);
                        if (n == -1) break;
                        annIds.remove(n);
                        Code oc = current.getCode(current.getIndex(id));
                        GenericAnnotations.addAnnotations(code, oc.getGenericAnnotations());
                        code.setType("_annotation_");
                        break;
                    }
                    case 1: {
                        Code code;
                        if (store) {
                            this.storeStartElement(false, false, false);
                        } else {
                            this.annotatorsRef.readAndPush();
                        }
                        String name = this.reader.getLocalName();
                        if (name.equals("mrk")) {
                            String type = this.reader.getAttributeValue(null, "mtype");
                            if (type != null && type.equals("seg")) {
                                if (!current.isEmpty()) {
                                    content.append(current, !content.hasBeenSegmented());
                                    changeFirstPart = !content.hasBeenSegmented();
                                }
                                idStack.push(++id);
                                segIdStack = id;
                                segment = new Segment();
                                segment.id = this.reader.getAttributeValue(null, "mid");
                                current = segment.text;
                                current.invalidate();
                                GenericAnnotations anns = this.itsFilterHandler.readInlineCodeITSAttributes();
                                segment.setAnnotation(anns);
                                break;
                            }
                            if (type != null && type.equals("protected")) {
                                int mid = this.retrieveId(id, this.reader.getAttributeValue(null, "mid"), false, true);
                                code = this.appendCode(TextFragment.TagType.PLACEHOLDER, mid, name, name, store, current);
                                code.setDeleteable(false);
                                break;
                            }
                        }
                        if (name.equals("g")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            idStack.push(id);
                            code = current.append(TextFragment.TagType.OPENING, name, "", id);
                            code.setOuterData(this.buildStartCode());
                            break;
                        }
                        if (name.equals("mrk")) {
                            int mid = this.retrieveId(id, this.reader.getAttributeValue(null, "mid"), false, true);
                            idStack.push(mid);
                            code = current.append(TextFragment.TagType.OPENING, name, "", mid);
                            GenericAnnotations anns = this.itsFilterHandler.readInlineCodeITSAttributes();
                            if (anns != null) {
                                annIds.add(mid);
                                GenericAnnotations.addAnnotations(code, anns);
                                code.setType("_annotation_");
                            }
                            code.setOuterData(this.buildStartCode());
                            break;
                        }
                        if (name.equals("x")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.PLACEHOLDER, id, name, name, store, current);
                            break;
                        }
                        if (name.equals("bx")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.OPENING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("ex")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), true, false);
                            this.appendCode(TextFragment.TagType.CLOSING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("bpt")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.OPENING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("ept")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), true, false);
                            this.appendCode(TextFragment.TagType.CLOSING, id, name, "Xpt", store, current);
                            break;
                        }
                        if (name.equals("ph")) {
                            id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                            this.appendCode(TextFragment.TagType.PLACEHOLDER, id, name, name, store, current);
                            break;
                        }
                        if (!name.equals("it")) break;
                        id = this.retrieveId(id, this.reader.getAttributeValue(null, "id"), false, false);
                        String tmp = this.reader.getAttributeValue(null, "pos");
                        TextFragment.TagType tt = TextFragment.TagType.PLACEHOLDER;
                        if (tmp == null) {
                            this.logger.error("Missing pos attribute for <it> element.");
                        } else if (tmp.equals("close")) {
                            tt = TextFragment.TagType.CLOSING;
                        } else if (tmp.equals("open")) {
                            tt = TextFragment.TagType.OPENING;
                        } else {
                            this.logger.error("Invalid value '{}' for pos attribute.", (Object)tmp);
                        }
                        this.appendCode(tt, id, name, name, store, current);
                    }
                }
            }
            return content;
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private String buildStartCode() {
        int i;
        String prefix = this.reader.getPrefix();
        StringBuilder tmpg = new StringBuilder();
        boolean isMrk = false;
        if (prefix != null && prefix.length() > 0) {
            tmpg.append("<" + prefix + ":" + this.reader.getLocalName());
        } else {
            tmpg.append("<" + this.reader.getLocalName());
            isMrk = "mrk".equals(this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            tmpg.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                tmpg.append(":" + prefix);
            }
            tmpg.append("=\"");
            tmpg.append(this.reader.getNamespaceURI(i));
            tmpg.append("\"");
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            String attName = this.reader.getAttributeLocalName(i);
            if (isMrk && ("comment".equals(attName) || "http://www.w3.org/ns/its-xliff/".equals(this.reader.getAttributeNamespace(i)) || "http://www.w3.org/2005/11/its".equals(this.reader.getAttributeNamespace(i)) || "http://www.w3.org/XML/1998/namespace".equals(this.reader.getAttributeNamespace(i)) && ("lang".equals(attName) || "preserve".equals(attName)))) continue;
            tmpg.append(" ");
            if (prefix != null && prefix.length() != 0) {
                tmpg.append(prefix + ":");
            }
            tmpg.append(attName);
            tmpg.append("=\"");
            tmpg.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
            tmpg.append("\"");
        }
        tmpg.append(">");
        return tmpg.toString();
    }

    private int retrieveId(int currentIdValue, String id, boolean useMinusOneasDefault, boolean useAutoMid) {
        if (id == null || id.length() == 0) {
            if (useAutoMid) {
                return --this.autoMid;
            }
            return useMinusOneasDefault ? -1 : ++currentIdValue;
        }
        try {
            return Integer.valueOf(id);
        }
        catch (NumberFormatException e) {
            return id.hashCode();
        }
    }

    private Code appendCode(TextFragment.TagType tagType, int id, String tagName, String type, boolean store, TextFragment content) {
        try {
            String prefix;
            int endStack = 1;
            StringBuilder innerCode = new StringBuilder();
            StringBuilder outerCode = null;
            outerCode = new StringBuilder();
            outerCode.append("<" + tagName);
            int count = this.reader.getAttributeCount();
            for (int i = 0; i < count; ++i) {
                if (!this.reader.isAttributeSpecified(i)) continue;
                prefix = this.reader.getAttributePrefix(i);
                outerCode.append(" ");
                if (prefix != null && prefix.length() != 0) {
                    outerCode.append(prefix + ":");
                }
                outerCode.append(this.reader.getAttributeLocalName(i));
                outerCode.append("=\"");
                outerCode.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
                outerCode.append("\"");
            }
            outerCode.append(">");
            boolean inSub = false;
            boolean hasSub = false;
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 1: {
                        if (inSub) {
                            throw new OkapiException("Unexpected state in processing sub.");
                        }
                        if (store) {
                            this.storeStartElement(false, false, false);
                        } else {
                            this.annotatorsRef.readAndPush();
                        }
                        if (!inSub && this.reader.getLocalName().equals("sub")) {
                            inSub = true;
                        } else if (tagName.equals(this.reader.getLocalName())) {
                            ++endStack;
                        }
                        String tmpg = this.buildStartCode();
                        if (!inSub) {
                            innerCode.append(tmpg.toString());
                        }
                        outerCode.append(tmpg.toString());
                        if (!inSub) break;
                        Code code = content.append(tagType, type, innerCode.toString(), id);
                        code.setOuterData(outerCode.toString());
                        List<Object> chunks = this.processSub();
                        for (Object obj : chunks) {
                            if (obj instanceof String) {
                                content.append((String)obj);
                                continue;
                            }
                            if (!(obj instanceof Code)) continue;
                            content.append((Code)obj);
                        }
                        innerCode.setLength(0);
                        outerCode.setLength(0);
                        outerCode.append("</sub>");
                        inSub = false;
                        hasSub = true;
                        break;
                    }
                    case 2: {
                        Code code;
                        if (inSub) {
                            throw new OkapiException("Unexpected state in processing sub.");
                        }
                        if (store) {
                            this.storeEndElement();
                        } else {
                            this.annotatorsRef.pop();
                        }
                        if (tagName.equals(this.reader.getLocalName()) && --endStack == 0) {
                            code = content.append(tagType, type, innerCode.toString(), hasSub ? (this.extraId = this.extraId - 1) : id);
                            if (!hasSub && innerCode.length() == 0) {
                                outerCode.insert(outerCode.length() - 1, '/');
                            } else {
                                outerCode.append("</" + tagName + ">");
                            }
                            code.setOuterData(outerCode.toString());
                            return code;
                        }
                        prefix = this.reader.getPrefix();
                        if (prefix == null || prefix.length() == 0) {
                            innerCode.append("</" + this.reader.getLocalName() + ">");
                            outerCode.append("</" + this.reader.getLocalName() + ">");
                            break;
                        }
                        innerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        outerCode.append("</" + prefix + ":" + this.reader.getLocalName() + ">");
                        break;
                    }
                    case 4: 
                    case 6: 
                    case 12: {
                        innerCode.append(this.reader.getText());
                        outerCode.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        if (!store) break;
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
        return null;
    }

    private List<Object> processSub() throws XMLStreamException {
        ArrayList<Object> chunks = new ArrayList<Object>();
        boolean inText = true;
        StringBuilder buf = new StringBuilder();
        StringBuilder bufOuter = new StringBuilder();
        while (this.reader.hasNext()) {
            int eventType = this.reader.next();
            switch (eventType) {
                case 1: {
                    if (inText) {
                        chunks.add(buf.toString());
                        buf.setLength(0);
                        inText = false;
                        bufOuter.append(this.buildStartTag());
                        break;
                    }
                    Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x-ph", buf.toString());
                    code.setId(--this.extraId);
                    code.setOuterData(bufOuter.toString());
                    chunks.add(code);
                    buf.setLength(0);
                    bufOuter.setLength(0);
                    code = new Code(TextFragment.TagType.PLACEHOLDER, "x-ph", null);
                    code.setId(--this.extraId);
                    code.setOuterData(this.buildStartTag());
                    chunks.addAll(this.processSub());
                    buf.setLength(0);
                    bufOuter.setLength(0);
                    bufOuter.append("</sub>");
                    break;
                }
                case 2: {
                    if (inText) {
                        chunks.add(buf.toString());
                        buf.setLength(0);
                        return chunks;
                    }
                    bufOuter.append("</" + this.reader.getLocalName() + ">");
                    Code code = new Code(TextFragment.TagType.PLACEHOLDER, "x-ph", buf.toString());
                    code.setId(--this.extraId);
                    code.setOuterData(bufOuter.toString());
                    chunks.add(code);
                    inText = true;
                    buf.setLength(0);
                    bufOuter.setLength(0);
                    break;
                }
                case 4: 
                case 6: 
                case 12: {
                    if (inText) {
                        buf.append(this.reader.getText());
                        break;
                    }
                    String data = this.reader.getText();
                    buf.append(data);
                    bufOuter.append(Util.escapeToXML(data, 0, this.params.getEscapeGT(), null));
                }
            }
        }
        return null;
    }

    private String buildStartTag() {
        int i;
        StringBuilder tmp = new StringBuilder("<");
        String prefix = this.reader.getPrefix();
        if (prefix == null || prefix.length() == 0) {
            tmp.append(this.reader.getLocalName());
        } else {
            tmp.append(prefix + ":" + this.reader.getLocalName());
        }
        int count = this.reader.getNamespaceCount();
        for (i = 0; i < count; ++i) {
            prefix = this.reader.getNamespacePrefix(i);
            tmp.append(" xmlns");
            if (!Util.isEmpty(prefix)) {
                tmp.append(":" + prefix);
            }
            tmp.append("=\"");
            tmp.append(this.reader.getNamespaceURI(i));
            tmp.append("\"");
        }
        count = this.reader.getAttributeCount();
        for (i = 0; i < count; ++i) {
            if (!this.reader.isAttributeSpecified(i)) continue;
            prefix = this.reader.getAttributePrefix(i);
            tmp.append(" ");
            if (prefix != null && prefix.length() != 0) {
                tmp.append(prefix + ":");
            }
            tmp.append(this.reader.getAttributeLocalName(i));
            tmp.append("=\"");
            tmp.append(Util.escapeToXML(this.reader.getAttributeValue(i), 3, this.params.getEscapeGT(), null));
            tmp.append("\"");
        }
        tmp.append(">");
        return tmp.toString();
    }

    private void processNote() {
        try {
            String dest = this.reader.getAttributeValue(null, "annotates");
            if (dest == null) {
                dest = "";
            }
            Property prop = null;
            StringBuilder tmp = new StringBuilder();
            prop = dest.equals("source") ? this.tu.getSourceProperty("note") : (dest.equals("target") ? this.tu.getTargetProperty(this.trgLang, "note") : this.tu.getProperty("note"));
            if (prop == null) {
                prop = new Property("note", "", true);
            } else {
                tmp.append(prop.getValue());
                tmp.append("\n---\n");
            }
            while (this.reader.hasNext()) {
                int eventType = this.reader.next();
                switch (eventType) {
                    case 4: 
                    case 6: 
                    case 12: {
                        this.skel.append(Util.escapeToXML(this.reader.getText(), 0, this.params.getEscapeGT(), null));
                        tmp.append(this.reader.getText());
                        break;
                    }
                    case 2: {
                        String name = this.reader.getLocalName();
                        if (!name.equals("note")) break;
                        prop.setValue(tmp.toString());
                        if (dest.equals("source")) {
                            this.tu.setSourceProperty(prop);
                        } else if (dest.equals("target")) {
                            this.tu.setTargetProperty(this.trgLang, prop);
                        } else {
                            this.tu.setProperty(prop);
                        }
                        return;
                    }
                }
            }
        }
        catch (XMLStreamException e) {
            throw new OkapiIOException(e);
        }
    }

    private boolean processStartGroup() throws IOException {
        String mergeTrans = this.reader.getAttributeValue(null, "merge-trans");
        if (mergeTrans != null && mergeTrans.equals("yes")) {
            this.storeStartElement(false, false, false);
            this.parentIds.push(null);
            return false;
        }
        String grpId = this.reader.getAttributeValue(null, "id");
        if (grpId == null || this.groupUsedIds.contains(grpId)) {
            grpId = this.groupId.createIdNotInList(this.groupUsedIds);
        } else {
            this.groupId.setLastId(grpId);
        }
        this.groupUsedIds.add(grpId);
        StartGroup group = new StartGroup(this.parentIds.peek().toString(), grpId);
        group.setSkeleton(this.skel);
        this.parentIds.push(this.groupId.getLastId());
        this.queue.add(new Event(EventType.START_GROUP, group));
        String tmp = this.reader.getAttributeValue(null, "resname");
        if (tmp != null) {
            group.setName(tmp);
        } else if (this.params.getFallbackToID()) {
            group.setName(this.reader.getAttributeValue(null, "id"));
        }
        group.setType(this.reader.getAttributeValue(null, "restype"));
        this.storeStartElementGroup(group);
        ITSProvenanceAnnotations prov = this.itsFilterHandler.readITSProvenance();
        ITSProvenanceAnnotations.addAnnotations(group, prov);
        return true;
    }

    private boolean processEndGroup() {
        String id = this.parentIds.pop();
        if (id == null) {
            return false;
        }
        Ending ending = new Ending(id);
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, ending));
        return true;
    }

    private boolean processStartBinUnit() {
        this.storeStartElement(false, false, false);
        String tmp = this.reader.getAttributeValue(null, "id");
        if (tmp == null) {
            throw new OkapiIllegalFilterOperationException("Missing attribute 'id'.");
        }
        StartGroup group = new StartGroup(this.parentIds.peek().toString(), this.groupId.createId());
        group.setSkeleton(this.skel);
        this.parentIds.push(this.groupId.getLastId());
        this.queue.add(new Event(EventType.START_GROUP, group));
        tmp = this.reader.getAttributeValue(null, "resname");
        if (tmp != null) {
            group.setName(tmp);
        } else if (this.params.getFallbackToID()) {
            group.setName(this.reader.getAttributeValue(null, "id"));
        }
        group.setType(this.reader.getAttributeValue(null, "restype"));
        return true;
    }

    private boolean processEndBinUnit() {
        String id = this.parentIds.pop();
        Ending ending = new Ending(id);
        ending.setSkeleton(this.skel);
        this.queue.add(new Event(EventType.END_GROUP, ending));
        return true;
    }

    public ITSAnnotatorsRefContext getAnnotatorsRefContext() {
        return this.annotatorsRef;
    }
}

