/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.concurrent;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.pipeline.ICallableStep;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.common.pipeline.IWorkQueueStep;
import net.sf.okapi.common.resource.MultiEvent;
import net.sf.okapi.lib.concurrent.CallableStep;
import net.sf.okapi.lib.concurrent.SortableEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitWorkQueueStep
implements IWorkQueueStep<SortableEvent> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CompletionService<SortableEvent> completionService;
    private ThreadPoolExecutor executor;
    private LinkedList<ICallableStep<SortableEvent>> steps = new LinkedList();
    private int workQueueCount;
    private IPipelineStep step;
    private List<SortableEvent> cachedEvents = new LinkedList<SortableEvent>();
    private int textUnitCount;

    public TextUnitWorkQueueStep() {
    }

    public TextUnitWorkQueueStep(IPipelineStep step, int workQueueCount) throws InstantiationException, IllegalAccessException {
        this();
        this.workQueueCount = workQueueCount;
        this.step = step;
        this.init();
    }

    @Override
    public void setMainStep(IPipelineStep step) {
        this.step = step;
    }

    @Override
    public void setWorkQueueCount(int workQueueCount) {
        this.workQueueCount = workQueueCount;
    }

    @Override
    public void init() throws InstantiationException, IllegalAccessException {
        this.executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(this.workQueueCount);
        this.completionService = new ExecutorCompletionService<SortableEvent>(this.executor);
        for (int i = 0; i < this.workQueueCount; ++i) {
            CallableStep cs = new CallableStep((IPipelineStep)this.step.getClass().newInstance());
            cs.setLastOutputStep(this.step.isLastOutputStep());
            cs.setParameters(this.step.getParameters());
            this.steps.add(cs);
        }
    }

    @Override
    public IPipelineStep getMainStep() {
        return this.step;
    }

    @Override
    public LinkedList<ICallableStep<SortableEvent>> getCallableSteps() {
        return this.steps;
    }

    @Override
    public int getWorkQueueCount() {
        return this.workQueueCount;
    }

    @Override
    public IParameters getParameters() {
        return this.step.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.step.setParameters(params);
        for (ICallableStep iCallableStep : this.steps) {
            iCallableStep.setParameters(params);
        }
    }

    @Override
    public String getName() {
        return String.format("%s (Threaded Work Queue)", this.step.getName());
    }

    @Override
    public String getDescription() {
        return String.format("%s (Threaded Work Queue)", this.step.getDescription());
    }

    @Override
    public String getHelpLocation() {
        return this.step.getHelpLocation();
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case TEXT_UNIT: {
                ++this.textUnitCount;
            }
            case DOCUMENT_PART: {
                this.cachedEvents.add(new SortableEvent(event, this.cachedEvents.size()));
                if (this.textUnitCount >= this.workQueueCount) {
                    return this.processCachedTextUnits();
                }
                return Event.NOOP_EVENT;
            }
            case START_BATCH: 
            case START_BATCH_ITEM: 
            case START_DOCUMENT: 
            case START_GROUP: 
            case START_SUBDOCUMENT: 
            case START_SUBFILTER: {
                assert (this.cachedEvents.size() <= 0);
                for (ICallableStep iCallableStep : this.steps) {
                    iCallableStep.processNow(event);
                }
                return this.step.handleEvent(event);
            }
        }
        if (this.cachedEvents.size() > 0) {
            Event me = this.processCachedTextUnits();
            me.getMultiEvent().addEvent(this.step.handleEvent(event));
            for (ICallableStep iCallableStep : this.steps) {
                iCallableStep.processNow(event);
            }
            return me;
        }
        for (ICallableStep iCallableStep : this.steps) {
            iCallableStep.processNow(event);
        }
        return this.step.handleEvent(event);
    }

    protected Event processCachedTextUnits() {
        List<Event> sortedEvents = null;
        try {
            sortedEvents = this.startConcurrentProcesing();
        }
        catch (InterruptedException e) {
            this.destroy();
            throw new OkapiException("Concurrent step was interrupted", e);
        }
        catch (ExecutionException e) {
            this.destroy();
            throw new OkapiException("Concurrent step threw an exception", e);
        }
        this.cachedEvents.clear();
        this.textUnitCount = 0;
        return new Event(EventType.MULTI_EVENT, new MultiEvent(sortedEvents));
    }

    protected List<Event> startConcurrentProcesing() throws InterruptedException, ExecutionException {
        int i = 0;
        for (SortableEvent event : this.cachedEvents) {
            if (!event.isTextUnit()) continue;
            ICallableStep<SortableEvent> cs = this.steps.get(i++);
            cs.handleEvent(event);
            this.completionService.submit(cs);
        }
        for (i = 0; i < this.textUnitCount; ++i) {
            Future<SortableEvent> r = this.completionService.take();
            this.cachedEvents.remove(r.get());
            this.cachedEvents.add(r.get());
        }
        Collections.sort(this.cachedEvents, Collections.reverseOrder());
        LinkedList<Event> sortedEvents = new LinkedList<Event>();
        for (SortableEvent event : this.cachedEvents) {
            sortedEvents.add(new Event(event.getEventType(), event.getResource()));
        }
        return sortedEvents;
    }

    @Override
    public boolean isDone() {
        return this.step.isDone();
    }

    @Override
    public void destroy() {
        this.step.destroy();
        for (ICallableStep iCallableStep : this.steps) {
            iCallableStep.destroy();
        }
        this.executor.shutdownNow();
        if (!this.executor.isShutdown()) {
            this.logger.error("WorkQueue Pipeline did not shutdown. Main thread still running.");
        }
    }

    @Override
    public void cancel() {
        this.step.cancel();
        for (ICallableStep iCallableStep : this.steps) {
            iCallableStep.cancel();
        }
    }

    @Override
    public boolean isLastOutputStep() {
        return this.step.isLastOutputStep();
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.step.setLastOutputStep(isLastStep);
        for (ICallableStep iCallableStep : this.steps) {
            iCallableStep.setLastOutputStep(isLastStep);
        }
    }
}

