/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.tkit.merge;

import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.exceptions.OkapiMergeException;
import net.sf.okapi.common.resource.CodeAnomalies;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragmentUtil;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.lib.tkit.merge.ITextUnitMerger;
import net.sf.okapi.lib.tkit.merge.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUnitMerger
implements ITextUnitMerger {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private LocaleId trgLoc;
    private Parameters params;
    private List<Range> srcRanges;
    private List<Range> trgRanges;

    @Override
    public ITextUnit mergeTargets(ITextUnit tuFromSkel, ITextUnit tuFromTrans) {
        if (!tuFromSkel.getId().equals(tuFromTrans.getId())) {
            String s = String.format("Text Unit id mismatch: Original id=\"%s\" target id=\"%s\".", tuFromSkel.getId(), tuFromTrans.getId());
            this.LOGGER.error(s);
            throw new OkapiMergeException(s);
        }
        TextContainer fromTranCont = tuFromTrans.hasTarget(this.trgLoc) ? tuFromTrans.getTarget(this.trgLoc).clone() : tuFromTrans.getSource().clone();
        if (fromTranCont == null) {
            if (tuFromSkel.getSource().hasText()) {
                this.LOGGER.error("No translation found for TU id='{}'. Using source instead.", (Object)tuFromTrans.getId());
            }
            return tuFromSkel;
        }
        boolean isTransApproved = false;
        Property traProp = fromTranCont.getProperty("approved");
        if (traProp != null) {
            isTransApproved = traProp.getValue().equals("yes");
        }
        if (this.params != null && this.params.isApprovedOnly() && !isTransApproved) {
            this.LOGGER.warn("Item id='{}': Target is not approved; using source instead.", (Object)tuFromSkel.getId());
            return tuFromSkel;
        }
        TextContainer fromSkelCont = tuFromSkel.getSource();
        TextContainer clonedFromSkel = tuFromSkel.hasTarget(this.trgLoc) ? tuFromSkel.getTarget(this.trgLoc).clone() : null;
        boolean mergeAsSegments = false;
        if (tuFromSkel.getMimeType() != null && (tuFromSkel.getMimeType().equals("application/x-ttx+xml") || tuFromSkel.getMimeType().equals("application/x-xliff+xml"))) {
            mergeAsSegments = true;
        }
        this.srcRanges = null;
        this.trgRanges = null;
        if (!fromSkelCont.contentIsOneSegment()) {
            this.srcRanges = fromSkelCont.getSegments().getRanges();
            fromSkelCont.joinAll();
        }
        if (!fromTranCont.contentIsOneSegment()) {
            this.trgRanges = fromTranCont.getSegments().getRanges();
            fromTranCont.joinAll();
        }
        fromTranCont.getFirstContent().alignCodeIds(fromSkelCont.getFirstContent());
        TextUnitUtil.copySrcCodeDataToMatchingTrgCodes(fromSkelCont.getFirstContent(), fromTranCont.getFirstContent(), true, false, null, tuFromSkel);
        CodeAnomalies codeAnomalies = TextFragmentUtil.catalogCodeAnomalies(fromSkelCont.getFirstContent(), fromTranCont.getFirstContent());
        if (codeAnomalies != null) {
            StringBuilder e = new StringBuilder();
            if (codeAnomalies.hasAddedCodes()) {
                e.append(String.format("\nAdded Codes in target='%s'", codeAnomalies.addedCodesAsString()));
            }
            if (codeAnomalies.hasMissingCodes()) {
                e.append(String.format("\nMissing Codes in target='%s'", codeAnomalies.missingCodesAsString()));
            }
            if (e.length() >= 0) {
                e.append("\n");
                e.append(fromSkelCont.getFirstContent());
                e.append("\n");
                e.append(fromTranCont.getFirstContent());
                this.LOGGER.error(e.toString());
                if (this.params.isThrowExceptions()) {
                    throw new OkapiMergeException(e.toString());
                }
            }
        }
        if (mergeAsSegments) {
            if (this.srcRanges != null) {
                fromSkelCont.getSegments().create(this.srcRanges, true);
            }
            if (this.trgRanges != null) {
                fromTranCont.getSegments().create(this.trgRanges, true);
            }
        }
        if (fromSkelCont.getSegments().count() < fromTranCont.getSegments().count()) {
            this.LOGGER.error("Item id='{}': There is at least one extra segment in the translation file.", (Object)tuFromTrans.getId());
        }
        if (!tuFromSkel.hasTarget(this.trgLoc)) {
            tuFromSkel.createTarget(this.trgLoc, false, 7);
        }
        tuFromSkel.setTarget(this.trgLoc, fromTranCont);
        if (clonedFromSkel == null) {
            return tuFromSkel;
        }
        if (mergeAsSegments) {
            for (Segment seg : clonedFromSkel.getSegments()) {
                Segment tseg = fromTranCont.getSegments().get(seg.id);
                if (tseg == null || seg.getAnnotations() == null) continue;
                for (IAnnotation ann : seg.getAnnotations()) {
                    tseg.setAnnotation(ann);
                }
            }
        }
        for (IAnnotation ann : clonedFromSkel.getAnnotations()) {
            fromTranCont.setAnnotation(ann);
        }
        for (String propName : clonedFromSkel.getPropertyNames()) {
            fromTranCont.setProperty(clonedFromSkel.getProperty(propName));
        }
        return tuFromSkel;
    }

    @Override
    public void setTargetLocale(LocaleId trgLoc) {
        this.trgLoc = trgLoc;
    }

    public LocaleId getTargetLocale() {
        return this.trgLoc;
    }

    @Override
    public Parameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(Parameters params) {
        this.params = params;
    }
}

