/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.FileUtil;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.AltTranslation;
import net.sf.okapi.common.annotation.AltTranslationsAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.query.MatchType;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.xliff2.core.CMarker;
import net.sf.okapi.lib.xliff2.core.Fragment;
import net.sf.okapi.lib.xliff2.core.Note;
import net.sf.okapi.lib.xliff2.core.Part;
import net.sf.okapi.lib.xliff2.core.StartFileData;
import net.sf.okapi.lib.xliff2.core.StartXliffData;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.core.Unit;
import net.sf.okapi.lib.xliff2.its.Domain;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.matches.Match;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriter;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.XLIFF2Options;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XLIFF2PackageWriter
extends BasePackageWriter {
    public static final String POBJECTS_DIR = "pobjects";
    private static final String TU_PREFIX = "$tu$";
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private XLIFFWriter writer;
    private LinkedHashMap<String, String> referents;
    private XLIFF2Options options;
    private String rawDocPath;
    private LocaleId trgLoc;

    public XLIFF2PackageWriter() {
        super("xliff2");
    }

    @Override
    protected void processStartBatch() {
        this.options = new XLIFF2Options();
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            this.options.fromString(this.params.getWriterOptions());
        }
        if (this.options.getCreateTipPackage()) {
            this.manifest.setGenerateTIPManifest(true);
            this.manifest.setSubDirectories("pobjects/input", "pobjects/bilingual", "pobjects/bilingual", "pobjects/output", "pobjects/tm", "pobjects/skeleton", false);
        } else {
            this.manifest.setSubDirectories("original", "work", "work", "done", null, "skeleton", false);
        }
        this.setTMXInfo(this.options.getCreateTipPackage(), null, false, false, false);
        super.processStartBatch();
    }

    public boolean getCreeatTipPackage() {
        return this.options.getCreateTipPackage();
    }

    @Override
    protected void processEndBatch() {
        super.processEndBatch();
        if (this.options.getCreateTipPackage()) {
            ArrayList<String> tms = new ArrayList<String>();
            if (this.tmxWriterApproved != null && this.tmxWriterApproved.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathApproved, true));
            }
            if (this.tmxWriterAlternates != null && this.tmxWriterAlternates.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathAlternates, true));
            }
            if (this.tmxWriterLeverage != null && this.tmxWriterLeverage.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathLeverage, true));
            }
            if (this.tmxWriterUnApproved != null && this.tmxWriterUnApproved.getItemCount() > 0) {
                tms.add(Util.getFilename(this.tmxPathUnApproved, true));
            }
            this.manifest.saveTIPManifest(this.manifest.getTempPackageRoot(), tms);
            String dir = this.manifest.getTempPackageRoot() + POBJECTS_DIR;
            FileUtil.zipDirectory(dir, ".zip");
            Util.deleteDirectory(dir, false);
        }
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        this.referents = new LinkedHashMap();
        MergingInfo item = this.manifest.getItem(this.docId);
        this.rawDocPath = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        this.writer.setWithOriginalData(this.options.getwithOriginalData());
        this.writer.setUseIndentation(true);
        this.trgLoc = this.manifest.getTargetLocale();
        Util.createDirectories(this.rawDocPath);
        this.writer.create(new File(this.rawDocPath), this.manifest.getSourceLocale().toBCP47(), this.trgLoc.toBCP47());
        StartXliffData sxd = new StartXliffData(null);
        ITSWriter.addDeclaration(sxd);
        this.writer.writeStartDocument(sxd, null);
        StartFileData sfd = new StartFileData(null);
        sfd.setOriginal(event.getStartDocument().getName());
        this.writer.setStartFileData(sfd);
    }

    @Override
    protected Event processEndDocument(Event event) {
        this.writer.writeEndDocument();
        this.writer.close();
        this.writer = null;
        this.referents.clear();
        this.referents = null;
        if (this.params.getSendOutput()) {
            return super.creatRawDocumentEventSet(this.rawDocPath, "UTF-8", this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        }
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
        StartFileData sfd = new StartFileData(null);
        sfd.setOriginal(event.getStartSubDocument().getName());
        this.writer.setStartFileData(sfd);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.writeEndFile();
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.writeStartGroup(null);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.writeEndGroup();
    }

    @Override
    protected void processTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (tu.isReferent()) {
            this.storeReferent(tu);
        }
        Unit unit = this.toXLIFF2Unit(tu);
        this.writer.writeUnit(unit);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    protected void processDocumentPart(Event event) {
        DocumentPart dp = event.getDocumentPart();
        if (dp.isReferent()) {
            this.storeReferent(dp);
        }
    }

    private void storeReferent(IResource res) {
        ISkeleton skel = res.getSkeleton();
        if (skel == null) {
            return;
        }
        if (res instanceof ITextUnit) {
            this.referents.put(res.getId(), TU_PREFIX + skel.toString());
        } else {
            this.referents.put(res.getId(), skel.toString());
        }
    }

    private String getReferences(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder tmp = new StringBuilder();
        StringBuilder data = new StringBuilder(text);
        Object[] res = null;
        do {
            if ((res = TextFragment.getRefMarker(data)) == null) continue;
            String refId = (String)res[0];
            if (!refId.equals("$self$")) {
                String skel = this.referents.get(refId);
                if (skel != null) {
                    if (!skel.startsWith(TU_PREFIX)) {
                        String refs = this.getReferences(skel);
                        if (refs != null) {
                            tmp.append(refs + " ");
                        }
                    } else {
                        tmp.append(refId + " ");
                    }
                } else {
                    tmp.append(refId + " ");
                }
            }
            data.delete((Integer)res[1], (Integer)res[2]);
        } while (res != null);
        return tmp.toString().trim();
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    private Unit toXLIFF2Unit(ITextUnit tu) {
        Note note;
        GenericAnnotation ga;
        Unit unit = new Unit(tu.getId());
        TextContainer srcTc = tu.getSource();
        TextContainer trgTc = null;
        if (tu.hasTarget(this.manifest.getTargetLocale()) && (trgTc = tu.getTarget(this.manifest.getTargetLocale())).getSegments().count() != srcTc.getSegments().count()) {
            this.LOGGER.warn("Text unit id='{}' has different number of segments in source and target.\nThis entry will be output un-segmented.", (Object)tu.getId());
            srcTc = tu.getSource().clone();
            srcTc.joinAll();
            trgTc = tu.getTarget(this.manifest.getTargetLocale()).clone();
            trgTc.joinAll();
        }
        if (!Util.isEmpty(tu.getType())) {
            unit.setType("okp:" + tu.getType().replace(':', '-'));
        }
        if (!Util.isEmpty(tu.getName())) {
            unit.setName(tu.getName());
        }
        unit.setTranslate(tu.isTranslatable());
        boolean noteDone = false;
        GenericAnnotations anns = tu.getAnnotation(GenericAnnotations.class);
        if (anns != null && (ga = anns.getFirstAnnotation("its-ln")) != null) {
            Note note2 = new Note(ga.getString("lnValue"), Note.AppliesTo.UNDEFINED);
            if (!"alert".equals(ga.getString("lnType"))) {
                note2.setPriority(2);
            }
            unit.addNote(note2);
            noteDone = true;
        }
        if (!noteDone && tu.hasProperty("note")) {
            note = new Note(tu.getProperty("note").getValue(), Note.AppliesTo.UNDEFINED);
            note.setPriority(2);
            unit.addNote(note);
        }
        if (tu.hasProperty("transNote")) {
            note = new Note("From Translator: " + tu.getProperty("transNote").getValue(), Note.AppliesTo.UNDEFINED);
            note.setPriority(2);
            unit.addNote(note);
        }
        if (tu.hasSourceProperty("note")) {
            note = new Note(tu.getSourceProperty("note").getValue(), Note.AppliesTo.SOURCE);
            note.setPriority(2);
            unit.addNote(note);
        }
        if (tu.hasTargetProperty(this.manifest.getTargetLocale(), "note")) {
            note = new Note(tu.getTargetProperty(this.manifest.getTargetLocale(), "note").getValue(), Note.AppliesTo.TARGET);
            note.setPriority(2);
            unit.addNote(note);
        }
        if (anns != null) {
            ga = anns.getFirstAnnotation("its-domain");
            if (ga != null) {
                unit.getITSItems().add(new Domain(ga.getString("domainValue")));
            }
            if ((ga = anns.getFirstAnnotation("its-allowedchars")) != null) {
                unit.getExtAttributes().setAttribute("http://www.w3.org/2005/11/its", "allowedCharacters", ga.getString("allowedcharsValue"));
            }
        }
        unit.setTranslate(tu.isTranslatable());
        ISegments trgSegs = null;
        if (trgTc != null) {
            trgSegs = trgTc.getSegments();
        }
        int srcSegIndex = -1;
        for (int i = 0; i < srcTc.count(); ++i) {
            TextPart part = srcTc.get(i);
            if (part.isSegment()) {
                AltTranslationsAnnotation ann;
                Segment srcSeg = (Segment)part;
                ++srcSegIndex;
                net.sf.okapi.lib.xliff2.core.Segment xSeg = unit.appendNewSegment();
                xSeg.setSource(this.toXLIFF2Fragment(srcSeg.text, unit.getStore(), false));
                xSeg.setPreserveWS(tu.preserveWhitespaces());
                if (trgSegs == null) continue;
                Segment trgSeg = trgSegs.get(xSeg.getId());
                if (trgSeg != null) {
                    xSeg.setTarget(this.toXLIFF2Fragment(trgSeg.text, unit.getStore(), true));
                    int trgSegIndex = trgSegs.getIndex(xSeg.getId());
                    if (srcSegIndex != trgSegIndex) {
                        int trgPartIndex = trgSegs.getPartIndex(trgSegIndex);
                        xSeg.setTargetOrder(trgPartIndex + 1);
                    }
                }
                if ((ann = trgSeg.getAnnotation(AltTranslationsAnnotation.class)) == null) continue;
                for (AltTranslation alt : ann) {
                    this.setMatch(alt, xSeg);
                }
                continue;
            }
            Part xPart = unit.appendNewIgnorable();
            xPart.setPreserveWS(tu.preserveWhitespaces());
            xPart.setSource(this.toXLIFF2Fragment(part.text, unit.getStore(), false));
            if (trgTc == null) continue;
        }
        return unit;
    }

    private void setMatch(AltTranslation alt, net.sf.okapi.lib.xliff2.core.Segment xSeg) {
        Match match = Match.annotate(xSeg.getSource(), 0, -1, new Match());
        match.setTarget(this.toXLIFF2Fragment(alt.getEntry().getTarget(this.trgLoc).getFirstContent(), match.getStore(), true));
        match.setSimilarity(1.0 * (double)alt.getFuzzyScore());
        match.setMatchSuitability(1.0 * (double)alt.getCombinedScore());
        match.setMatchQuality(1.0 * (double)alt.getQualityScore());
        match.setOrigin(alt.getOrigin());
        alt.getTool();
        switch (alt.getType()) {
            case CONCORDANCE: {
                break;
            }
            case EXACT: {
                break;
            }
            case EXACT_DOCUMENT_CONTEXT: {
                break;
            }
            case EXACT_LOCAL_CONTEXT: {
                match.setType("icm");
                break;
            }
            case EXACT_PREVIOUS_VERSION: {
                break;
            }
            case EXACT_STRUCTURAL: {
                break;
            }
            case EXACT_TEXT_ONLY: {
                break;
            }
            case EXACT_TEXT_ONLY_PREVIOUS_VERSION: {
                break;
            }
            case EXACT_TEXT_ONLY_UNIQUE_ID: 
            case EXACT_UNIQUE_ID: 
            case FUZZY_UNIQUE_ID: {
                match.setType("idm");
                break;
            }
            case FUZZY: {
                break;
            }
            case FUZZY_PREVIOUS_VERSION: {
                break;
            }
            case HUMAN_RECOMMENDED: {
                match.setType("other");
                break;
            }
            case MT: {
                match.setType("mt");
                break;
            }
            case PHRASE_ASSEMBLED: 
            case FUZZY_REPAIRED: 
            case EXACT_REPAIRED: {
                match.setType("am");
                break;
            }
            case UKNOWN: {
                match.setType("other");
            }
        }
        if (alt.getType() != MatchType.UKNOWN) {
            match.setSubType("okp:" + (Object)((Object)alt.getType()));
        }
    }

    private Fragment toXLIFF2Fragment(TextFragment tf, Store store, boolean isTarget) {
        if (!tf.hasCode()) {
            return new Fragment(store, isTarget, tf.getCodedText());
        }
        Fragment xFrag = new Fragment(store, isTarget);
        String ctext = tf.getCodedText();
        List<Code> codes = tf.getCodes();
        boolean mayOverlapDefault = false;
        for (int i = 0; i < ctext.length(); ++i) {
            if (TextFragment.isMarker(ctext.charAt(i))) {
                String data;
                CMarker xCode;
                int index;
                Code code;
                GenericAnnotations anns;
                if ((anns = (code = codes.get(index = TextFragment.toIndex(ctext.charAt(++i)))).getGenericAnnotations()) != null) {
                    // empty if block
                }
                switch (code.getTagType()) {
                    case OPENING: {
                        xCode = xFrag.append(TagType.OPENING, String.valueOf(code.getId()), code.getData(), mayOverlapDefault);
                        break;
                    }
                    case CLOSING: {
                        xCode = xFrag.append(TagType.CLOSING, String.valueOf(code.getId()), code.getData(), mayOverlapDefault);
                        break;
                    }
                    default: {
                        xCode = xFrag.appendPlaceholder(String.valueOf(code.getId()), code.getData());
                    }
                }
                if (code.hasReference() && (data = this.getReferences(code.getData())) != null) {
                    xCode.setSubFlows(data);
                }
                xCode.setDisp(code.getDisplayText());
                xCode.setCanCopy(code.isCloneable());
                xCode.setCanDelete(code.isDeleteable());
                continue;
            }
            xFrag.append(ctext.charAt(i));
        }
        return xFrag;
    }
}

