/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.wordcount.common;

import net.sf.okapi.common.IResource;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.wordcount.common.Metrics;
import net.sf.okapi.steps.wordcount.common.MetricsAnnotation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseCounter {
    private static BaseCounter counter = null;

    protected abstract long doCount(String var1, LocaleId var2);

    protected static long count(Class<? extends BaseCounter> classRef, Object text, LocaleId language) {
        if (text == null) {
            return 0L;
        }
        if (Util.isNullOrEmpty(language)) {
            return 0L;
        }
        if (text instanceof ITextUnit) {
            ITextUnit tu = (ITextUnit)text;
            return BaseCounter.count(classRef, tu.getSource(), language);
        }
        if (text instanceof Segment) {
            Segment seg = (Segment)text;
            return BaseCounter.count(classRef, seg.getContent(), language);
        }
        if (text instanceof TextContainer) {
            TextContainer tc = (TextContainer)text;
            long res = 0L;
            for (Segment seg : tc.getSegments()) {
                res += BaseCounter.count(classRef, seg, language);
            }
            return res;
        }
        if (text instanceof TextFragment) {
            TextFragment tf = (TextFragment)text;
            return BaseCounter.count(classRef, TextUnitUtil.getText(tf), language);
        }
        if (text instanceof String) {
            BaseCounter.instantiateCounter(classRef);
            if (counter == null) {
                return 0L;
            }
            return counter.doCount((String)text, language);
        }
        return 0L;
    }

    protected static void instantiateCounter(Class<? extends BaseCounter> classRef) {
        if (counter != null) {
            return;
        }
        Logger localLogger = LoggerFactory.getLogger(BaseCounter.class);
        try {
            counter = classRef.newInstance();
        }
        catch (InstantiationException e) {
            localLogger.debug("Counter instantiation failed: {}", (Object)e.getMessage());
        }
        catch (IllegalAccessException e) {
            localLogger.debug("Counter instantiation failed: {}", (Object)e.getMessage());
        }
    }

    private static long getValue(MetricsAnnotation ma, String metricName) {
        if (ma == null) {
            return 0L;
        }
        Metrics m = ma.getMetrics();
        if (m == null) {
            return 0L;
        }
        return m.getMetric(metricName);
    }

    public static long getCount(Segment segment, String metricName) {
        return BaseCounter.getValue(segment.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public static long getCount(TextContainer tc, String metricName) {
        return BaseCounter.getValue(tc.getAnnotation(MetricsAnnotation.class), metricName);
    }

    public static long getCount(IResource res, String metricName) {
        return BaseCounter.getValue(res.getAnnotation(MetricsAnnotation.class), metricName);
    }
}

