/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.BaseMarker;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.TagType;

public class CMarker
extends BaseMarker {
    private static final int CANCOPY = 1;
    private static final int CANDELETE = 2;
    public static final int CANREORDER_YES = 0;
    public static final int CANREORDER_FIRSTNO = 1;
    public static final int CANREORDER_NO = 2;
    private String originalData;
    private boolean initialWithOriginalData = true;
    private int hints = 3;
    private boolean canOverlap;
    private int canReorder = 0;
    private String copyOf;
    private String disp;
    private String equiv = "";
    private String subType;
    private String subFlows;
    private String dataRef;
    private Directionality dataDir = Directionality.AUTO;
    private Directionality dir = Directionality.INHERITED;

    public CMarker(CMarker original) {
        super(original);
        this.originalData = original.originalData;
        this.initialWithOriginalData = original.initialWithOriginalData;
        this.hints = original.hints;
        this.canOverlap = original.canOverlap;
        this.canReorder = original.canReorder;
        this.copyOf = original.copyOf;
        this.disp = original.disp;
        this.equiv = original.equiv;
        this.subType = original.subType;
        this.subFlows = original.subFlows;
        this.dataRef = original.dataRef;
        this.dataDir = original.dataDir;
        this.dir = original.dir;
    }

    public CMarker(TagType markerType, String id, String originalData) {
        if (markerType == null) {
            throw new InvalidParameterException("Marker type cannot be null.");
        }
        if (id == null) {
            throw new InvalidParameterException("Id cannot be null.");
        }
        this.tagType = markerType;
        this.id = id;
        this.internalId = CMarker.makeInternalId(this.id, this.tagType);
        this.originalData = originalData;
    }

    public String getOriginalData() {
        return this.originalData;
    }

    public void setOriginalData(String originalData) {
        this.originalData = originalData;
    }

    public boolean hasOriginalData() {
        return !Util.isNullOrEmpty(this.originalData);
    }

    public String getDataRef() {
        return this.dataRef;
    }

    public void setDataRef(String dataRef) {
        this.dataRef = dataRef;
    }

    public String getDisp() {
        return this.disp;
    }

    public void setDisp(String disp) {
        this.disp = disp;
    }

    public String getEquiv() {
        return this.equiv;
    }

    public void setEquiv(String equiv) {
        this.equiv = equiv;
    }

    public String getSubFlows() {
        return this.subFlows;
    }

    public void setSubFlows(String subFlows) {
        if (subFlows == null) {
            this.subFlows = null;
            return;
        }
        String[] ids = subFlows.split("[\\t\\n ]+", -1);
        String value = "";
        for (String id : ids) {
            if (id.isEmpty()) continue;
            if (!value.isEmpty()) {
                value = value + " ";
            }
            value = value + id;
        }
        this.subFlows = value;
    }

    public String[] getSubFlowsIds() {
        if (this.subFlows == null) {
            return new String[0];
        }
        return this.subFlows.split(" ", -1);
    }

    public boolean getCanCopy() {
        return (this.hints & 1) == 1;
    }

    public void setCanCopy(boolean canCopy) {
        this.hints = canCopy ? (this.hints |= 1) : (this.hints &= 0xFFFFFFFE);
    }

    public boolean getCanDelete() {
        return (this.hints & 2) == 2;
    }

    public void setCanDelete(boolean canDelete) {
        this.hints = canDelete ? (this.hints |= 2) : (this.hints &= 0xFFFFFFFD);
    }

    public boolean getCanOverlap() {
        return this.canOverlap;
    }

    public void setCanOverlap(boolean canOverlap) {
        this.canOverlap = canOverlap;
    }

    public int getCanReorder() {
        return this.canReorder;
    }

    public void setCanReorder(int canReorder) {
        if (canReorder < 0 && canReorder > 2) {
            throw new InvalidParameterException("Invalid canReorder value.");
        }
        this.canReorder = canReorder;
        if (canReorder != 0) {
            this.setCanDelete(false);
            this.setCanCopy(false);
        }
    }

    @Override
    public boolean equals(BaseMarker marker) {
        if (marker == null) {
            throw new NullPointerException("The parameter 'marker' must not be null.");
        }
        if (this == marker) {
            return true;
        }
        if (!(marker instanceof CMarker)) {
            return false;
        }
        CMarker code = (CMarker)marker;
        if (this.tagType.compareTo(code.getTagType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.id, code.getId()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.type, code.getType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.subType, code.getSubType()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.subFlows, code.getSubFlows()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.originalData, code.getOriginalData()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.disp, code.getDisp()) != 0) {
            return false;
        }
        if (Util.compareAllowingNull(this.equiv, code.getEquiv()) != 0) {
            return false;
        }
        if (code.getCanCopy() != this.getCanCopy()) {
            return false;
        }
        if (code.getCanDelete() != this.getCanDelete()) {
            return false;
        }
        if (code.getCanReorder() != this.getCanReorder()) {
            return false;
        }
        if (Util.compareAllowingNull(this.internalId, code.getInternalId()) != 0) {
            return false;
        }
        return this.tagType == TagType.STANDALONE || this.canOverlap == code.getCanOverlap();
    }

    @Override
    public boolean isAnnotation() {
        return false;
    }

    @Override
    public boolean isCode() {
        return true;
    }

    public boolean getInitialWithOriginalData() {
        return this.initialWithOriginalData;
    }

    public void setInitialWithOriginalData(boolean initialWithOriginalData) {
        this.initialWithOriginalData = initialWithOriginalData;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        if (subType != null) {
            int n = subType.indexOf(58);
            if (n == -1 || n == 0 || n == subType.length() - 1) {
                throw new InvalidParameterException(String.format("Invalid value '%s' for subType.", subType));
            }
            if (subType.startsWith("xlf:")) {
                Util.checkValueList("xlf:lb;xlf:pb;xlf:b;xlf:i;xlf:u;xlf:var", subType, "subType");
            }
        }
        this.subType = subType;
    }

    public void verifyTypeSubTypeValues() {
        if (this.subType == null) {
            return;
        }
        switch (this.subType) {
            case "xlf:lb": 
            case "xlf:pb": 
            case "xlf:b": 
            case "xlf:i": 
            case "xlf:u": {
                if (this.type != null && this.type.equals("fmt")) break;
                throw new InvalidParameterException(String.format("When subType is '%s', type must be 'fmt'.", this.subType));
            }
            case "xlf:var": {
                if (this.type != null && this.type.equals("ui")) break;
                throw new InvalidParameterException(String.format("When subType is '%s', type must be 'fmt'.", this.subType));
            }
        }
    }

    public String getCopyOf() {
        return this.copyOf;
    }

    public void setCopyOf(String copyOf) {
        this.copyOf = copyOf;
    }

    public Directionality getDataDir() {
        return this.dataDir;
    }

    public void setDataDir(Directionality dataDir) {
        this.dataDir = dataDir;
    }

    public Directionality getDir() {
        return this.dir;
    }

    public void setDir(Directionality dir) {
        this.dir = dir;
    }

    @Override
    public void setType(String type) {
        Util.checkValueList("fmt;ui;quote;link;image;other", type, "type");
        this.type = type;
    }
}

