/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.lib.xliff2.NSContext;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.AMarker;
import net.sf.okapi.lib.xliff2.core.BaseMarker;
import net.sf.okapi.lib.xliff2.core.CMarker;
import net.sf.okapi.lib.xliff2.core.CloneFactory;
import net.sf.okapi.lib.xliff2.core.Directionality;
import net.sf.okapi.lib.xliff2.core.ExtAttribute;
import net.sf.okapi.lib.xliff2.core.ExtAttributes;
import net.sf.okapi.lib.xliff2.core.InheritedData;
import net.sf.okapi.lib.xliff2.core.InvalidPositionException;
import net.sf.okapi.lib.xliff2.core.Markers;
import net.sf.okapi.lib.xliff2.core.PMarker;
import net.sf.okapi.lib.xliff2.core.Store;
import net.sf.okapi.lib.xliff2.core.TagType;
import net.sf.okapi.lib.xliff2.its.AnnotatorsRef;
import net.sf.okapi.lib.xliff2.its.ITSWriter;
import net.sf.okapi.lib.xliff2.its.TermMarker;
import net.sf.okapi.lib.xliff2.writer.XLIFFWriterException;

public class Fragment
implements Iterable<Object> {
    public static final char OPENING_CODE = '\ue101';
    public static final char CLOSING_CODE = '\ue102';
    public static final char STANDALONE_CODE = '\ue103';
    public static final char OPENING_ANNOTATION = '\ue104';
    public static final char CLOSING_ANNOTATION = '\ue105';
    public static final char STANDALONE_PCONT = '\ue106';
    public static final int INDEX_BASE = 57616;
    public static final int INDEX_MAX = 6127;
    public static final Pattern MARKERS_REGEX = Pattern.compile("[\ue101\ue102\ue103\ue104\ue105\ue106].");
    private boolean isTarget;
    private StringBuilder ctext;
    private Markers markers;
    private Directionality dir = Directionality.INHERITED;
    private transient ITSWriter itsWriter;

    public static int toKey(int c1, int c2) {
        return c1 << 16 | c2;
    }

    public static char toChar1(int key) {
        return (char)(key >> 16);
    }

    public static char toChar2(int key) {
        return (char)key;
    }

    public static String toRef(int key) {
        return "" + (char)(key >> 16) + (char)key;
    }

    public static boolean isMarker(char value) {
        switch (value) {
            case '\ue101': 
            case '\ue102': 
            case '\ue103': 
            case '\ue104': 
            case '\ue105': 
            case '\ue106': {
                return true;
            }
        }
        return false;
    }

    public static boolean isCMarker(char value) {
        switch (value) {
            case '\ue101': 
            case '\ue102': 
            case '\ue103': {
                return true;
            }
        }
        return false;
    }

    public static boolean hasContentAfter(String codedText, int position) {
        for (int i = position; i < codedText.length(); ++i) {
            if (Fragment.isMarker(codedText.charAt(position))) {
                switch (codedText.charAt(position)) {
                    case '\ue104': 
                    case '\ue105': {
                        break;
                    }
                    default: {
                        return true;
                    }
                }
                ++i;
                continue;
            }
            return true;
        }
        return false;
    }

    public Fragment(Fragment original, Store store, boolean target) {
        this(store, target);
        this.dir = original.dir;
        Markers oriMarkers = original.getMarkers();
        StringBuilder tmp = new StringBuilder(original.getCodedText());
        for (int i = 0; i < tmp.length(); ++i) {
            int key;
            char ch = tmp.charAt(i);
            if (!Fragment.isMarker(ch)) continue;
            if (ch == '\ue106') {
                PMarker pm = oriMarkers.getPMarker(tmp, i);
                StringBuilder pmtmp = new StringBuilder(pm.getCodedText());
                for (int j = 0; j < pmtmp.length(); ++j) {
                    char pmch = pmtmp.charAt(j);
                    if (!Fragment.isMarker(pmch)) continue;
                    BaseMarker bm = oriMarkers.get(pmtmp, j);
                    key = this.markers.add(CloneFactory.create(bm));
                    pmtmp.replace(j, j + 2, Fragment.toRef(key));
                    ++j;
                }
                key = this.markers.add(new PMarker(pmtmp.toString()));
                tmp.replace(i, i + 2, Fragment.toRef(key));
                ++i;
                continue;
            }
            BaseMarker bm = oriMarkers.get(tmp, i);
            key = this.markers.add(CloneFactory.create(bm));
            tmp.replace(i, i + 2, Fragment.toRef(key));
            ++i;
        }
        this.setCodedText(tmp.toString());
    }

    public Fragment(Store store, boolean target) {
        if (store == null) {
            throw new InvalidParameterException("The store parameter cannot be null.");
        }
        this.isTarget = target;
        this.ctext = new StringBuilder();
        this.markers = this.isTarget ? store.getTargetMarkers() : store.getSourceMarkers();
    }

    public Fragment(Store store, boolean target, String plainText) {
        this(store, target);
        this.ctext = new StringBuilder(plainText);
    }

    public String toString() {
        return this.ctext.toString();
    }

    public String getPlainText() {
        if (!this.hasMarker()) {
            return this.ctext.toString();
        }
        Matcher m = MARKERS_REGEX.matcher(new String(this.ctext));
        return m.replaceAll("");
    }

    public String getCodedText() {
        return this.ctext.toString();
    }

    public void setCodedText(String codedText) {
        this.ctext = new StringBuilder(codedText);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    public Store getStore() {
        return this.markers.getStore();
    }

    public BaseMarker getMarker(int key) {
        return this.markers.get(key);
    }

    public String toXLIFF(Stack<NSContext> nsStack, Stack<InheritedData> context, boolean withOriginalData) {
        StringBuilder tmp = new StringBuilder();
        ArrayList<String> verified = new ArrayList<String>();
        List<AbstractMap.SimpleEntry<String, AnnotatorsRef>> annotRefs = null;
        block6: for (int i = 0; i < this.ctext.length(); ++i) {
            AMarker am;
            BaseMarker closing;
            CMarker cm;
            char ch = this.ctext.charAt(i);
            if (ch == '\ue101') {
                cm = (CMarker)this.markers.get(this.ctext, i);
                closing = null;
                if ((closing = (CMarker)this.getWellFormedClosing(cm, ++i)) != null) {
                    tmp.append("<pc id=\"" + cm.getId() + "\"");
                    verified.add(cm.getId());
                    if (cm.getCanOverlap()) {
                        tmp.append(" canOverlap=\"yes\"");
                    }
                } else {
                    tmp.append(String.format("<sc id=\"%s\"", cm.getId()));
                    if (!cm.getCanOverlap()) {
                        tmp.append(" canOverlap=\"no\"");
                    }
                    if (this.getClosingMarkerInUnit(cm) == null) {
                        tmp.append(" isolated=\"yes\"");
                    }
                }
                this.printCommonAttributes(cm, tmp, (CMarker)closing, withOriginalData);
                if (withOriginalData && cm.hasOriginalData()) {
                    String ending = closing == null ? "" : "Start";
                    tmp.append(String.format(" dataRef%s=\"%s\"", ending, this.markers.getStore().getIdForOriginalData(cm)));
                }
                this.printExtAttributes(cm, tmp, nsStack);
                tmp.append(closing == null ? "/>" : ">");
                continue;
            }
            if (ch == '\ue102') {
                cm = (CMarker)this.markers.get(this.ctext, i);
                ++i;
                if (verified.contains(cm.getId())) {
                    tmp.append("</pc>");
                    continue;
                }
                tmp.append("<ec");
                if (!this.unitHasOpening(cm)) {
                    tmp.append(String.format(" id=\"%s\"", cm.getId()));
                    tmp.append(" isolated=\"yes\"");
                } else {
                    tmp.append(" startRef=\"" + cm.getId() + "\"");
                }
                if (!cm.getCanOverlap()) {
                    tmp.append(" canOverlap=\"no\"");
                }
                this.printCommonAttributes(cm, tmp, null, false);
                if (withOriginalData && cm.hasOriginalData()) {
                    tmp.append(String.format(" dataRef=\"%s\"", this.markers.getStore().getIdForOriginalData(cm)));
                }
                this.printExtAttributes(cm, tmp, nsStack);
                tmp.append("/>");
                continue;
            }
            if (ch == '\ue103') {
                cm = (CMarker)this.markers.get(this.ctext, i);
                ++i;
                tmp.append(String.format("<ph id=\"%s\"", cm.getId()));
                this.printCommonAttributes(cm, tmp, null, false);
                if (withOriginalData && cm.hasOriginalData()) {
                    tmp.append(String.format(" dataRef=\"%s\"", this.markers.getStore().getIdForOriginalData(cm)));
                }
                this.printExtAttributes(cm, tmp, nsStack);
                tmp.append("/>");
                continue;
            }
            if (ch == '\ue104') {
                am = (AMarker)this.markers.get(this.ctext, i);
                closing = (AMarker)this.getWellFormedClosing(am, ++i);
                if (closing != null) {
                    tmp.append(String.format("<%s id=\"%s\"", "mrk", am.getId()));
                } else {
                    tmp.append(String.format("<%s id=\"%s\"", "sm", am.getId()));
                }
                if (!am.getType().equals("generic")) {
                    tmp.append(" type=\"" + am.getType() + "\"");
                }
                if (!Util.isNullOrEmpty(am.getTranslate())) {
                    tmp.append(" translate=\"" + am.getTranslate() + "\"");
                }
                if (!Util.isNullOrEmpty(am.getValue())) {
                    tmp.append(" value=\"" + Util.toXML(am.getValue(), true) + "\"");
                }
                if (!Util.isNullOrEmpty(am.getRef())) {
                    tmp.append(" ref=\"" + Util.toXML(am.getRef(), true) + "\"");
                }
                if (this.itsWriter == null) {
                    this.itsWriter = new ITSWriter();
                }
                if (annotRefs == null) {
                    annotRefs = this.itsWriter.createAnnotatorsRefList(context);
                }
                AnnotatorsRef amAR = this.itsWriter.createAnnotatorsRef(am);
                annotRefs.add(new AbstractMap.SimpleEntry<String, AnnotatorsRef>(am.getId(), amAR));
                tmp.append(this.itsWriter.outputAttributes(am, amAR, annotRefs.get(annotRefs.size() - 2).getValue()));
                this.printExtAttributes(am, tmp, nsStack);
                if (closing != null) {
                    verified.add(am.getId());
                    tmp.append(">");
                    continue;
                }
                tmp.append("/>");
                continue;
            }
            if (ch == '\ue105') {
                am = (AMarker)this.markers.get(this.ctext, i);
                ++i;
                if (verified.contains(am.getId())) {
                    tmp.append("</mrk>");
                } else {
                    tmp.append("<em startRef=\"" + am.getId() + "\"/>");
                }
                if (annotRefs == null) continue;
                String id = am.getId();
                for (AbstractMap.SimpleEntry simpleEntry : annotRefs) {
                    if (!id.equals(simpleEntry.getKey())) continue;
                    annotRefs.remove(simpleEntry);
                    continue block6;
                }
                continue;
            }
            if (ch == '\ue106') {
                tmp.append("<WARNING:HIDDEN-PROTECTED-CONTENT/>");
                ++i;
                continue;
            }
            switch (ch) {
                case '\r': {
                    tmp.append("&#13;");
                    continue block6;
                }
                case '<': {
                    tmp.append("&lt;");
                    continue block6;
                }
                case '&': {
                    tmp.append("&amp;");
                    continue block6;
                }
                case '\t': 
                case '\n': {
                    tmp.append(ch);
                    continue block6;
                }
                default: {
                    if (ch > '\u001f' && ch < '\ud800') {
                        tmp.append(ch);
                        continue block6;
                    }
                    if (Character.isHighSurrogate(ch)) {
                        tmp.append(Character.toChars(this.ctext.codePointAt(i)));
                        ++i;
                        continue block6;
                    }
                    if (ch >= ' ' && (ch <= '\ud7ff' || ch >= '\ue000') && ch != '\ufffe' && ch != '\uffff') continue block6;
                    tmp.append(String.format("<cp hex=\"%04X\"/>", ch));
                }
            }
        }
        return tmp.toString();
    }

    public BaseMarker getClosingMarkerInUnit(BaseMarker bm) {
        if (this.markers == null) {
            return null;
        }
        return this.markers.getClosingMarker(bm);
    }

    public BaseMarker getOpeningMarkerInUnit(BaseMarker bm) {
        if (this.markers == null) {
            return null;
        }
        return this.markers.getOpeningMarker(bm);
    }

    public int getClosingPosition(BaseMarker opening) {
        if (this.markers == null) {
            return -1;
        }
        BaseMarker closing = this.markers.getClosingMarker(opening);
        if (closing == null) {
            return -1;
        }
        return this.ctext.indexOf(Fragment.toRef(this.markers.getKey(closing)));
    }

    public boolean unitHasOpening(CMarker cm) {
        if (this.markers == null) {
            return false;
        }
        return this.markers.getOpeningMarker(cm) != null;
    }

    private void printCommonAttributes(CMarker cm, StringBuilder tmp, CMarker closing, boolean outputDataRefEnd) {
        String ending;
        if (cm.getType() != null) {
            tmp.append(" type=\"" + cm.getType() + "\"");
        }
        if (cm.getSubType() != null) {
            if (cm.getType() == null) {
                throw new XLIFFWriterException("You must specify a type if you specify a subType.");
            }
            tmp.append(" subType=\"" + cm.getSubType() + "\"");
        }
        if (!cm.getCanCopy()) {
            tmp.append(" canCopy=\"no\"");
        }
        if (!cm.getCanDelete()) {
            tmp.append(" canDelete=\"no\"");
        }
        if (cm.getCanReorder() != 0) {
            tmp.append(String.format(" %s=\"%s\"", "canReorder", cm.getCanReorder() == 1 ? "firstNo" : "no"));
        }
        String string = ending = closing == null ? "" : "Start";
        if (!cm.getEquiv().isEmpty()) {
            tmp.append(String.format(" equiv%s=\"%s\"", ending, Util.toXML(cm.getEquiv(), true)));
        }
        if (cm.getDisp() != null) {
            tmp.append(String.format(" disp%s=\"%s\"", ending, Util.toXML(cm.getDisp(), true)));
        }
        if (cm.getSubFlows() != null) {
            tmp.append(String.format(" subFlows%s=\"%s\"", ending, cm.getSubFlows()));
        }
        if (closing != null) {
            if (!closing.getEquiv().isEmpty()) {
                tmp.append(String.format(" equivEnd=\"%s\"", Util.toXML(closing.getEquiv(), true)));
            }
            if (closing.getDisp() != null) {
                tmp.append(String.format(" dispEnd=\"%s\"", Util.toXML(closing.getDisp(), true)));
            }
            if (closing.getSubFlows() != null) {
                tmp.append(String.format(" subFlowsEnd=\"%s\"", closing.getSubFlows()));
            }
            if (outputDataRefEnd && closing.hasOriginalData()) {
                tmp.append(String.format(" dataRefEnd=\"%s\"", this.markers.getStore().getIdForOriginalData(closing)));
            }
        }
    }

    private void printExtAttributes(BaseMarker marker, StringBuilder output, Stack<NSContext> nsStack) {
        String prefix;
        if (!marker.hasExtAttribute()) {
            return;
        }
        ExtAttributes attributes = marker.getExtAttributes();
        NSContext nsCtx = null;
        if (nsStack != null) {
            nsCtx = nsStack.push(nsStack.peek().clone());
            for (String namespaceURI : attributes.getNamespaces()) {
                if (namespaceURI.isEmpty() || nsStack.peek().getPrefix(namespaceURI) != null || (prefix = attributes.getNamespacePrefix(namespaceURI)) == null) continue;
                output.append(" xmlns" + (prefix.isEmpty() ? "" : ":" + prefix) + "=\"" + namespaceURI + "\"");
                nsCtx.put(prefix, namespaceURI);
            }
        } else {
            for (String namespaceURI : attributes.getNamespaces()) {
                if (namespaceURI.isEmpty() || (prefix = attributes.getNamespacePrefix(namespaceURI)) == null) continue;
                output.append(" xmlns:" + prefix + "=\"" + namespaceURI + "\"");
            }
        }
        for (ExtAttribute att : attributes) {
            if (nsCtx != null) {
                prefix = nsCtx.getPrefix(att.getNamespaceURI());
                output.append(" " + (prefix.isEmpty() ? "" : prefix + ":") + att.getLocalPart() + "=\"" + Util.toXML(att.getValue(), true) + "\"");
                continue;
            }
            output.append(" " + (att.getPrefix().isEmpty() ? "" : att.getPrefix() + ":") + att.getLocalPart() + "=\"" + Util.toXML(att.getValue(), true) + "\"");
        }
        if (nsStack != null) {
            nsStack.pop();
        }
    }

    public String toXLIFF(Stack<NSContext> nsStack, Stack<InheritedData> context) {
        return this.toXLIFF(nsStack, context, false);
    }

    public boolean isEmpty() {
        return this.ctext.length() == 0;
    }

    public boolean isTarget() {
        return this.isTarget;
    }

    public boolean hasMarker() {
        return this.markers.size() > 0;
    }

    public BaseMarker getWellFormedClosing(BaseMarker openingMarker, int from) {
        Stack<String> stack = new Stack<String>();
        for (int i = from; i < this.ctext.length(); ++i) {
            BaseMarker marker;
            char ch = this.ctext.charAt(i);
            if (ch == '\ue101' || ch == '\ue104') {
                marker = this.markers.get(this.ctext, i);
                ++i;
                stack.push(marker.getId());
                continue;
            }
            if (ch == '\ue102' || ch == '\ue105') {
                marker = this.markers.get(this.ctext, i);
                ++i;
                if (marker.getId().equals(openingMarker.getId())) {
                    if (stack.isEmpty()) {
                        return marker;
                    }
                    return null;
                }
                if (stack.isEmpty()) {
                    return null;
                }
                stack.remove(marker.getId());
                continue;
            }
            if (ch != '\ue103') continue;
            ++i;
        }
        return null;
    }

    public void append(String plainText) {
        this.ctext.append(plainText);
    }

    public void append(char ch) {
        this.ctext.append(ch);
    }

    public BaseMarker append(BaseMarker marker) {
        this.ctext.append(Fragment.toRef(this.markers.add(marker)));
        if (marker.isCode()) {
            this.guessClosingMarkerProperties((CMarker)marker);
        }
        return marker;
    }

    public CMarker append(CMarker cm) {
        this.ctext.append(Fragment.toRef(this.markers.add(cm)));
        this.guessClosingMarkerProperties(cm);
        return cm;
    }

    public AMarker append(AMarker am) {
        this.ctext.append(Fragment.toRef(this.markers.add(am)));
        return am;
    }

    public AMarker closeAnnotation(String id) {
        if (this.markers == null) {
            throw new RuntimeException("There are no opening markers in this unit.");
        }
        BaseMarker bm = this.markers.getOpeningMarker(id);
        if (bm == null) {
            throw new RuntimeException(String.format("Opening marker for id='%s' not found.", id));
        }
        if (!(bm instanceof AMarker)) {
            throw new RuntimeException(String.format("Opening marker for id='%s' is not for an annotation.", id));
        }
        AMarker opening = (AMarker)bm;
        AMarker am = new AMarker(id, false, opening.getType());
        am.setRef(opening.getRef());
        am.setValue(opening.getValue());
        am.setTranslate(opening.getTranslate());
        this.ctext.append(Fragment.toRef(this.markers.add(am)));
        return am;
    }

    public CMarker append(TagType type, String id, String originalData, boolean canOverlap) {
        if (this.markers == null) {
            throw new RuntimeException("Cannot add markers in this fragment because it has no associated store.");
        }
        CMarker cm = new CMarker(type, id, originalData);
        cm.setCanOverlap(canOverlap);
        this.guessClosingMarkerProperties(cm);
        return this.append(cm);
    }

    public boolean guessClosingMarkerProperties(CMarker cm) {
        if (cm.getTagType() != TagType.CLOSING) {
            return false;
        }
        CMarker om = (CMarker)this.getOpeningMarkerInUnit(cm);
        if (om == null) {
            return false;
        }
        switch (om.getCanReorder()) {
            case 1: 
            case 2: {
                cm.setCanReorder(2);
            }
        }
        cm.setCanOverlap(om.getCanOverlap());
        cm.setCanCopy(om.getCanCopy());
        cm.setCanDelete(om.getCanDelete());
        return true;
    }

    public CMarker appendPlaceholder(String id, String originalData) {
        return this.append(TagType.STANDALONE, id, originalData, false);
    }

    public void append(Fragment fragment) {
        if (this == fragment) {
            throw new RuntimeException("Recursive append() on a fragment.");
        }
        for (Object obj : fragment) {
            if (obj instanceof BaseMarker) {
                this.append(CloneFactory.create((BaseMarker)obj));
                continue;
            }
            this.append((String)obj);
        }
    }

    public int annotate(int start, int end, String type, String value, String ref) {
        AMarker marker = new AMarker(this.getStore().suggestId(false), true, type);
        if ("term".equals(type) || "its:term-no".equals(type)) {
            marker = new TermMarker(marker, type, null);
        }
        marker.setValue(value);
        marker.setRef(ref);
        return this.annotate(start, end, marker);
    }

    public int annotate(int start, int end, AMarker openingMarker) {
        int initial = this.ctext.length();
        if (end == -1) {
            end = this.ctext.length();
        }
        this.checkPositionForMarker(start);
        this.checkPositionForMarker(end);
        int key = this.markers.add(openingMarker);
        this.ctext.insert(start, Fragment.toRef(key));
        AMarker endMrk = new AMarker(openingMarker);
        endMrk.setTagType(TagType.CLOSING);
        key = this.markers.add(endMrk);
        this.ctext.insert(end + 2, Fragment.toRef(key));
        return this.ctext.length() - initial;
    }

    public AMarker getOrCreateAnnotation(int start, int end, String matchingType, String typeForNew) {
        int pos;
        if (end == -1) {
            end = this.ctext.length();
        }
        this.checkPositionForMarker(start);
        this.checkPositionForMarker(end);
        boolean found = false;
        AMarker opening = null;
        BaseMarker closing = null;
        if (start > 1 && this.ctext.charAt(start - 2) == '\ue104') {
            opening = (AMarker)this.markers.get(this.ctext, start - 2);
        } else if (this.ctext.charAt(start) == '\ue104') {
            opening = (AMarker)this.markers.get(this.ctext, start);
        }
        if (opening != null && (closing = this.markers.getClosingMarker(opening)) != null && (end == (pos = this.ctext.indexOf(Fragment.toRef(this.markers.getKey(closing)))) || end == pos + 2)) {
            found = matchingType != null ? matchingType.equals(opening.getType()) : true;
        }
        if (!found) {
            if (typeForNew == null) {
                throw new InvalidParameterException("You must define the typeForNew parameter.");
            }
            opening = new AMarker(this.getStore().suggestId(false), true, typeForNew);
            this.annotate(start, end, opening);
        }
        return opening;
    }

    public void remove(BaseMarker marker) {
        if (this.markers == null) {
            throw new RuntimeException("There is no marker in this fragment.");
        }
        int key = this.markers.getKey(marker);
        if (key == -1) {
            throw new RuntimeException(String.format("There is no marker for id='%s' and type='%s' in this fragment.", marker.getId(), marker.getType()));
        }
        for (int i = 0; i < this.ctext.length(); ++i) {
            int thisKey;
            char ch = this.ctext.charAt(i);
            if (!Fragment.isMarker(ch) || (thisKey = Fragment.toKey(ch, this.ctext.charAt(++i))) != key) continue;
            this.ctext.delete(i - 1, i + 1);
            i -= 2;
            this.markers.remove(key);
            break;
        }
    }

    @Override
    public Iterator<Object> iterator() {
        return new Iterator<Object>(){
            int pos = 0;

            @Override
            public void remove() {
                throw new UnsupportedOperationException("The method remove() not supported.");
            }

            @Override
            public Object next() {
                int start = this.pos;
                while (this.pos < Fragment.this.ctext.length()) {
                    if (Fragment.isMarker(Fragment.this.ctext.charAt(this.pos))) {
                        if (start < this.pos) {
                            return Fragment.this.ctext.substring(start, this.pos);
                        }
                        this.pos += 2;
                        return Fragment.this.markers.get(Fragment.this.ctext, this.pos - 2);
                    }
                    ++this.pos;
                }
                return Fragment.this.ctext.substring(start);
            }

            @Override
            public boolean hasNext() {
                return this.pos < Fragment.this.ctext.length();
            }
        };
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ctext == null ? 0 : this.ctext.toString().hashCode());
        result = 31 * result + (this.dir == null ? 0 : this.dir.hashCode());
        result = 31 * result + (this.isTarget ? 1231 : 1237);
        result = 31 * result + (this.markers == null ? 0 : this.markers.hashCode());
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Fragment fragment = (Fragment)object;
        Iterator<Object> thisIter = this.iterator();
        Iterator<Object> thatIter = fragment.iterator();
        while (thisIter.hasNext()) {
            if (!thatIter.hasNext()) {
                return false;
            }
            Object thisObj = thisIter.next();
            Object thatObj = thatIter.next();
            if (thisObj instanceof String) {
                if (!(thatObj instanceof String)) {
                    return false;
                }
                if (thisObj.equals(thatObj)) continue;
                return false;
            }
            if (thatObj instanceof String) {
                return false;
            }
            if (((BaseMarker)thisObj).equals((BaseMarker)thatObj)) continue;
            return false;
        }
        return !thatIter.hasNext();
    }

    public Directionality getDir(boolean resolved) {
        if (resolved && this.dir == Directionality.INHERITED) {
            if (this.isTarget) {
                return this.markers.getStore().getTargetDir();
            }
            return this.markers.getStore().getSourceDir();
        }
        return this.dir;
    }

    public void setDir(Directionality dir) {
        this.dir = dir;
    }

    public void showProtectedContent() {
        for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (ch == '\ue106') {
                int key = Fragment.toKey(ch, this.ctext.charAt(i + 1));
                PMarker pm = this.markers.getPMarker(key);
                this.ctext.replace(i, i + 2, pm.getCodedText());
                i += pm.getCodedText().length() - 1;
                this.markers.removePMarker(key);
                continue;
            }
            if (!Fragment.isMarker(ch)) continue;
            ++i;
        }
    }

    public void checkPositionForMarker(int position) {
        if (position > 0 && Fragment.isMarker(this.ctext.charAt(position - 1))) {
            throw new InvalidPositionException(String.format("Position %d is inside a marker reference.", position));
        }
    }

    public void clear() {
        for (int i = 0; i < this.ctext.length(); ++i) {
            char ch = this.ctext.charAt(i);
            if (!Fragment.isMarker(ch)) continue;
            if (ch == '\ue106') {
                int pmkey = Fragment.toKey(ch, this.ctext.charAt(++i));
                PMarker pm = this.markers.getPMarker(pmkey);
                String pmct = pm.getCodedText();
                for (int j = 0; j < pmct.length(); ++j) {
                    char pmch = pmct.charAt(j);
                    if (!Fragment.isMarker(pmch)) continue;
                    this.markers.remove(Fragment.toKey(pmch, pmct.charAt(++j)));
                }
                this.markers.removePMarker(pmkey);
                continue;
            }
            this.markers.remove(Fragment.toKey(ch, this.ctext.charAt(++i)));
        }
        this.ctext = new StringBuilder();
    }

    public int getCodedTextPosition(int plainTextPosition, boolean leftOfMarker) {
        int ct;
        int pt = 0;
        for (ct = 0; ct < this.ctext.length(); ++ct) {
            if (Fragment.isMarker(this.ctext.charAt(ct))) {
                if (pt == plainTextPosition && leftOfMarker) {
                    return ct;
                }
                ++ct;
                continue;
            }
            if (pt == plainTextPosition) {
                return ct;
            }
            ++pt;
        }
        return ct;
    }
}

