/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.xliff2.core;

import java.security.InvalidParameterException;
import net.sf.okapi.lib.xliff2.Util;
import net.sf.okapi.lib.xliff2.core.DataWithExtAttributes;

public class StartXliffData
extends DataWithExtAttributes {
    private String version;
    private String sourceLang;
    private String targetLang;

    public StartXliffData(String version) {
        if (version == null) {
            version = "2.0";
        }
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public String getSourceLanguage() {
        return this.sourceLang;
    }

    public void setSourceLanguage(String sourceLang) {
        String msg = Util.validateLang(sourceLang);
        if (msg != null) {
            throw new InvalidParameterException(String.format("The source language value '%s' is invalid.\n" + msg, sourceLang));
        }
        this.sourceLang = sourceLang;
    }

    public String getTargetLanguage() {
        return this.targetLang;
    }

    public void setTargetLanguage(String targetLang) {
        String msg;
        if (targetLang != null && (msg = Util.validateLang(targetLang)) != null) {
            throw new InvalidParameterException(String.format("The target language value '%s' is invalid.\n" + msg, targetLang));
        }
        this.targetLang = targetLang;
    }

    public void setNamespace(String prefix, String namespaceURI) {
        this.getExtAttributes().setNamespace(prefix, namespaceURI);
    }
}

