/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathFactory;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import org.w3c.dom.Node;

public final class Util {
    public static final String ROOT_DIRECTORY_VAR = "${rootDir}";
    public static final String INPUT_ROOT_DIRECTORY_VAR = "${inputRootDir}";
    public static final String LINEBREAK_DOS = "\r\n";
    public static final String LINEBREAK_UNIX = "\n";
    public static final String LINEBREAK_MAC = "\r";
    public static final String RTF_STARTCODE = "{\\cs5\\f1\\cf15\\lang1024 ";
    public static final String RTF_ENDCODE = "}";
    public static final String RTF_STARTINLINE = "{\\cs6\\f1\\cf6\\lang1024 ";
    public static final String RTF_ENDINLINE = "}";
    public static final String RTF_STARTMARKER = "{\\cs15\\v\\cf12\\sub\\f2 \\{0>}{\\v\\f1 ";
    public static final String RTF_MIDMARKER1 = "}{\\cs15\\v\\cf12\\sub\\f2 <\\}";
    public static final String RTF_MIDMARKER2 = "\\{>}";
    public static final String RTF_ENDMARKER = "{\\cs15\\v\\cf12\\sub\\f2 <0\\}}";
    private static final String NEWLINES_REGEX = "\r(\n)?";
    private static final Pattern NEWLINES_REGEX_PATTERN = Pattern.compile("\r(\n)?");
    private static final String VARIABLE_REGEX = "\\$\\{([^\\}]+)\\}";
    private static final Pattern VARIABLE_REGEX_PATTERN = Pattern.compile("\\$\\{([^\\}]+)\\}");
    public static final String MTFLAG = "MT!";
    private static final String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "seamonkey", "galeon", "kazehakase", "mozilla", "netscape"};

    public static String normalizeNewlines(String text) {
        return NEWLINES_REGEX_PATTERN.matcher(text).replaceAll(LINEBREAK_UNIX);
    }

    public static String trimStart(String text, String chars) {
        int n;
        if (text == null) {
            return text;
        }
        for (n = 0; n < text.length() && chars.indexOf(text.charAt(n)) != -1; ++n) {
        }
        if (n >= text.length()) {
            return "";
        }
        if (n > 0) {
            return text.substring(n);
        }
        return text;
    }

    public static String trimEnd(String text, String chars) {
        int n;
        if (text == null) {
            return text;
        }
        for (n = text.length() - 1; n >= 0 && chars.indexOf(text.charAt(n)) != -1; --n) {
        }
        if (n < 0) {
            return "";
        }
        if (n > 0) {
            return text.substring(0, n + 1);
        }
        return text;
    }

    public static String getDirectoryName(String path) {
        String tmp = path.replace('\\', '/');
        int n = tmp.lastIndexOf(47);
        if (n > 0) {
            return path.substring(0, n);
        }
        return "";
    }

    public static String ensureSeparator(String path, boolean forceForwardSlash) {
        if (Util.isEmpty(path)) {
            return path;
        }
        if (path.endsWith("/")) {
            return path;
        }
        if (path.endsWith(File.separator)) {
            if (forceForwardSlash) {
                path = path.substring(0, path.length() - 1);
            } else {
                return path;
            }
        }
        if (forceForwardSlash) {
            return path + "/";
        }
        return path + File.separator;
    }

    public static String ensureLeadingSeparator(String path, boolean forceForwardSlash) {
        if (Util.isEmpty(path)) {
            return path;
        }
        if (path.startsWith("/")) {
            return path;
        }
        if (path.startsWith(File.separator)) {
            if (forceForwardSlash) {
                path = path.substring(1, path.length());
            } else {
                return path;
            }
        }
        if (forceForwardSlash) {
            return "/" + path;
        }
        return File.separator + path;
    }

    public static String fixFilename(String fileName, String replacer) {
        if (Util.isEmpty(fileName)) {
            return "";
        }
        if (Util.isEmpty(replacer)) {
            return fileName;
        }
        String regex = "[*:<>?\\\\/|]";
        replacer = replacer.replaceAll(regex, "_");
        return fileName.replaceAll(regex, replacer);
    }

    public static String fixPath(String path) {
        return Util.fixPath(path, true);
    }

    public static String fixPath(String path, boolean forceOsSeparators) {
        String FP_PREFIX = "file://";
        String res = path;
        boolean hasFileProtocol = res.startsWith("file://");
        if (hasFileProtocol) {
            res = res.substring("file://".length());
        }
        res = res.replaceAll("[\\\\/]+", "/");
        if (!hasFileProtocol && forceOsSeparators) {
            res = res.replace("/", File.separator);
        }
        return hasFileProtocol ? "file://" + res : res;
    }

    public static String fixFilename(String fileName) {
        return Util.fixFilename(fileName, "_");
    }

    public static String buildPath(String ... parts) {
        String res = null;
        for (String part : parts) {
            String normalizedPart = part.replace("\\", "/");
            if (res == null) {
                res = normalizedPart;
                continue;
            }
            if (!res.endsWith("/")) {
                res = res + "/";
            }
            res = res + normalizedPart;
        }
        return Util.fixPath(res);
    }

    public static String[] getFilteredFiles(String directory, final String suffix) throws URISyntaxException {
        File dir = new File(directory);
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(suffix);
            }
        };
        return dir.list(filter);
    }

    public static boolean createDirectories(String path) {
        String tmp = path.replace('\\', '/');
        int n = tmp.lastIndexOf(47);
        if (n == -1) {
            return true;
        }
        String dirPath = path.substring(0, n);
        File dir = new File(dirPath);
        if (!dir.exists()) {
            return dir.mkdirs();
        }
        return true;
    }

    public static String escapeToXML(String text, int quoteMode, boolean escapeGT, CharsetEncoder encoder) {
        if (text == null) {
            return "";
        }
        StringBuffer sbTmp = new StringBuffer(text.length());
        block11: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '<': {
                    sbTmp.append("&lt;");
                    continue block11;
                }
                case '>': {
                    if (escapeGT) {
                        sbTmp.append("&gt;");
                        continue block11;
                    }
                    if (i > 0 && text.charAt(i - 1) == ']') {
                        sbTmp.append("&gt;");
                        continue block11;
                    }
                    sbTmp.append('>');
                    continue block11;
                }
                case '&': {
                    sbTmp.append("&amp;");
                    continue block11;
                }
                case '\"': {
                    if (quoteMode > 0) {
                        sbTmp.append("&quot;");
                        continue block11;
                    }
                    sbTmp.append('\"');
                    continue block11;
                }
                case '\'': {
                    switch (quoteMode) {
                        case 1: {
                            sbTmp.append("&apos;");
                            continue block11;
                        }
                        case 2: {
                            sbTmp.append("&#39;");
                            continue block11;
                        }
                    }
                    sbTmp.append(text.charAt(i));
                    continue block11;
                }
                default: {
                    if (text.charAt(i) > '\u007f') {
                        if (Character.isHighSurrogate(ch)) {
                            int cp = text.codePointAt(i++);
                            String tmp = new String(Character.toChars(cp));
                            if (encoder != null && !encoder.canEncode(tmp)) {
                                sbTmp.append(String.format("&#x%x;", cp));
                                continue block11;
                            }
                            sbTmp.append(tmp);
                            continue block11;
                        }
                        if (encoder != null && !encoder.canEncode(text.charAt(i))) {
                            sbTmp.append(String.format("&#x%04x;", text.codePointAt(i)));
                            continue block11;
                        }
                        sbTmp.append(text.charAt(i));
                        continue block11;
                    }
                    sbTmp.append(text.charAt(i));
                }
            }
        }
        return sbTmp.toString();
    }

    public static String escapeToRTF(String text, boolean convertLineBreaks, int lineBreakStyle, CharsetEncoder encoder) {
        try {
            if (text == null) {
                return "";
            }
            StringBuffer tmp = new StringBuffer(text.length());
            CharBuffer tmpBuf = CharBuffer.allocate(1);
            block24: for (int i = 0; i < text.length(); ++i) {
                switch (text.charAt(i)) {
                    case '\\': 
                    case '{': 
                    case '}': {
                        tmp.append("\\").append(text.charAt(i));
                        continue block24;
                    }
                    case '\r': {
                        continue block24;
                    }
                    case '\n': {
                        if (convertLineBreaks) {
                            switch (lineBreakStyle) {
                                case 1: {
                                    tmp.append("}");
                                    tmp.append("\r\n\\par ");
                                    tmp.append(RTF_STARTCODE);
                                    continue block24;
                                }
                                case 2: {
                                    tmp.append("}");
                                    tmp.append("\r\n\\par ");
                                    tmp.append(RTF_STARTINLINE);
                                    continue block24;
                                }
                            }
                            tmp.append("\r\n\\par ");
                            continue block24;
                        }
                        tmp.append(LINEBREAK_UNIX);
                        continue block24;
                    }
                    case '\u00a0': {
                        tmp.append("\\~");
                        continue block24;
                    }
                    case '\t': {
                        tmp.append("\\tab ");
                        continue block24;
                    }
                    case '\u2022': {
                        tmp.append("\\bullet ");
                        continue block24;
                    }
                    case '\u2018': {
                        tmp.append("\\lquote ");
                        continue block24;
                    }
                    case '\u2019': {
                        tmp.append("\\rquote ");
                        continue block24;
                    }
                    case '\u201c': {
                        tmp.append("\\ldblquote ");
                        continue block24;
                    }
                    case '\u201d': {
                        tmp.append("\\rdblquote ");
                        continue block24;
                    }
                    case '\u2013': {
                        tmp.append("\\endash ");
                        continue block24;
                    }
                    case '\u2014': {
                        tmp.append("\\emdash ");
                        continue block24;
                    }
                    case '\u200d': {
                        tmp.append("\\zwj ");
                        continue block24;
                    }
                    case '\u200c': {
                        tmp.append("\\zwnj ");
                        continue block24;
                    }
                    case '\u200e': {
                        tmp.append("\\ltrmark ");
                        continue block24;
                    }
                    case '\u200f': {
                        tmp.append("\\rtlmark ");
                        continue block24;
                    }
                    default: {
                        if (text.charAt(i) > '\u007f') {
                            if (encoder.canEncode(text.charAt(i))) {
                                tmpBuf.put(0, text.charAt(i));
                                tmpBuf.position(0);
                                ByteBuffer encBuf = encoder.encode(tmpBuf);
                                if (encBuf.limit() > 1) {
                                    tmp.append(String.format("{\\uc%d", encBuf.limit()));
                                    tmp.append(String.format("\\u%d", text.charAt(i)));
                                    for (int j = 0; j < encBuf.limit(); ++j) {
                                        tmp.append(String.format("\\'%x", encBuf.get(j) < 0 ? 0xFF ^ ~encBuf.get(j) : encBuf.get(j)));
                                    }
                                    tmp.append("}");
                                    continue block24;
                                }
                                tmp.append(String.format("\\u%d", text.charAt(i)));
                                tmp.append(String.format("\\'%x", encBuf.get(0) < 0 ? 0xFF ^ ~encBuf.get(0) : encBuf.get(0)));
                                continue block24;
                            }
                            tmp.append(String.format("\\u%d ?", text.charAt(i)));
                            continue block24;
                        }
                        tmp.append(text.charAt(i));
                    }
                }
            }
            return tmp.toString();
        }
        catch (CharacterCodingException e) {
            throw new OkapiException(e);
        }
    }

    public static boolean deleteDirectory(File directory) {
        boolean res = true;
        File[] list = directory.listFiles();
        if (list == null) {
            return true;
        }
        for (File f : list) {
            if (f.isDirectory()) {
                Util.deleteDirectory(f);
            }
            if (f.delete()) continue;
            res = false;
        }
        return res;
    }

    public static void deleteDirectory(String directory, boolean contentOnly) {
        File f = new File(directory);
        if (!f.isDirectory()) {
            return;
        }
        Util.deleteDirectory(f);
        if (!contentOnly) {
            f.delete();
        }
    }

    public static String getFilename(String path, boolean keepExtension) {
        int n = path.lastIndexOf(47);
        int n2 = path.lastIndexOf(92);
        if (n2 > n) {
            n = n2;
        }
        if (n == -1) {
            n = path.lastIndexOf(92);
        }
        if (n > -1) {
            path = path.substring(n + 1);
        }
        if (keepExtension) {
            return path;
        }
        n = path.lastIndexOf(46);
        if (n > -1) {
            return path.substring(0, n);
        }
        return path;
    }

    public static String getExtension(String path) {
        int n = path.lastIndexOf(46);
        if (n == -1) {
            return "";
        }
        return path.substring(n);
    }

    public static String makeURIFromPath(String pathOrUri) {
        if (Util.isEmpty(pathOrUri)) {
            throw new IllegalArgumentException();
        }
        if ((pathOrUri = pathOrUri.replace('\\', '/')).indexOf("://") != -1) {
            return pathOrUri;
        }
        if (pathOrUri.startsWith("file:/")) {
            pathOrUri = pathOrUri.substring(6);
        }
        if (pathOrUri.startsWith("/")) {
            pathOrUri = pathOrUri.substring(1);
        }
        String tmp = Util.URLEncodeUTF8(pathOrUri);
        return "file:///" + tmp.replace("+", "%20");
    }

    public static URI toURI(String pathOrUri) {
        try {
            if (pathOrUri == null || pathOrUri.equals("")) {
                return new URI("");
            }
            URI uri = new URI(pathOrUri);
            if (uri != null && uri.isAbsolute()) {
                return uri;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return new File(pathOrUri).toURI();
    }

    public static URI URLtoURI(URL url) {
        try {
            return url.toURI();
        }
        catch (URISyntaxException e) {
            throw new OkapiException(e);
        }
    }

    public static String longestCommonDir(String currentDir, String newDir, boolean ignoreCase) {
        if (currentDir == null) {
            return newDir;
        }
        if (currentDir.length() == 0) {
            return currentDir;
        }
        String currentLow = currentDir;
        String newLow = newDir;
        if (ignoreCase) {
            currentLow = currentDir.toLowerCase();
            newLow = newDir.toLowerCase();
        }
        if (newLow.indexOf(currentLow) == 0) {
            return currentDir;
        }
        String tmp = currentLow;
        int i = 0;
        while (newLow.indexOf(tmp) != 0) {
            tmp = Util.getDirectoryName(tmp);
            ++i;
            if (tmp.length() != 0) continue;
            return "";
        }
        tmp = currentDir;
        for (int j = 0; j < i; ++j) {
            tmp = Util.getDirectoryName(tmp);
        }
        return tmp;
    }

    public static String longestCommonDir(boolean ignoreCase, String ... directories) {
        if (directories == null) {
            return "";
        }
        if (directories.length == 1) {
            return directories[0];
        }
        String res = directories[0];
        for (int i = 1; i < directories.length; ++i) {
            res = Util.longestCommonDir(res, directories[i], ignoreCase);
        }
        return res;
    }

    public static boolean isOSCaseSensitive() {
        return !File.separator.equals("\\");
    }

    public static void writeBOMIfNeeded(Writer writer, boolean bomOnUTF8, String encoding) {
        try {
            String tmp = encoding.toLowerCase();
            if (bomOnUTF8 && tmp.equalsIgnoreCase("utf-8")) {
                writer.write("\ufeff");
                return;
            }
            if (tmp.equals("utf-16be") || tmp.equals("utf-16le")) {
                writer.write("\ufeff");
                return;
            }
        }
        catch (IOException e) {
            throw new OkapiIOException(e);
        }
    }

    public static String getTempDirectory() {
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.endsWith(File.separator)) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    public static String getTextContent(Node node) {
        Node tmp = node.getFirstChild();
        while (tmp != null) {
            if (tmp.getNodeType() == 3) {
                return tmp.getNodeValue();
            }
            tmp = tmp.getNextSibling();
        }
        return "";
    }

    public static int getPercentage(int part, int total) {
        return total == 0 ? 1 : Math.round((float)part / (float)total * 100.0f);
    }

    public static String makeId(String text) {
        int n = text.hashCode();
        return String.format("%s%X", Character.valueOf(n > 0 ? (char)'P' : 'N'), n);
    }

    public static boolean isSameLanguage(String lang1, String lang2, boolean ignoreRegion) {
        lang1 = lang1.replace('_', '-');
        lang2 = lang2.replace('_', '-');
        if (ignoreRegion) {
            int n = lang1.indexOf(45);
            if (n > -1) {
                lang1 = lang1.substring(0, n);
            }
            if ((n = lang2.indexOf(45)) > -1) {
                lang2 = lang2.substring(0, n);
            }
        }
        return lang1.equalsIgnoreCase(lang2);
    }

    public static boolean isEmpty(String string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNullOrEmpty(LocaleId locale) {
        return locale == null || locale.equals(LocaleId.EMPTY);
    }

    public static boolean isEmpty(String string, boolean ignoreWS) {
        if (ignoreWS && string != null) {
            string = string.trim();
        }
        return Util.isEmpty(string);
    }

    public static boolean isEmpty(StringBuilder sb) {
        return sb == null || sb.length() == 0;
    }

    public static <E> boolean isEmpty(List<E> e) {
        return e == null || e.isEmpty();
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isEmpty(Object[] e) {
        return e == null || e != null && e.length == 0;
    }

    public static int getLength(String string) {
        return Util.isEmpty(string) ? 0 : string.length();
    }

    public static char getCharAt(String string, int pos) {
        if (Util.isEmpty(string)) {
            return '\u0000';
        }
        return string.length() > pos ? string.charAt(pos) : (char)'\u0000';
    }

    public static char getLastChar(String string) {
        if (Util.isEmpty(string)) {
            return '\u0000';
        }
        return string.charAt(string.length() - 1);
    }

    public static String deleteLastChar(String string) {
        if (Util.isEmpty(string)) {
            return "";
        }
        return string.substring(0, string.length() - 1);
    }

    public static char getLastChar(StringBuilder sb) {
        if (Util.isEmpty(sb)) {
            return '\u0000';
        }
        return sb.charAt(sb.length() - 1);
    }

    public static void deleteLastChar(StringBuilder sb) {
        if (Util.isEmpty(sb)) {
            return;
        }
        sb.deleteCharAt(sb.length() - 1);
    }

    public static <E> boolean checkIndex(int index, List<E> list) {
        return list != null && index >= 0 && index < list.size();
    }

    public static String intToStr(int value) {
        return String.valueOf(value);
    }

    public static int strToInt(String value, int intDefault) {
        if (Util.isEmpty(value)) {
            return intDefault;
        }
        try {
            return Integer.valueOf(value);
        }
        catch (NumberFormatException e) {
            return intDefault;
        }
    }

    public static int fastParseInt(String s) {
        if (s == null) {
            throw new NumberFormatException("Null string");
        }
        int num = 0;
        int sign = -1;
        int len = s.length();
        char ch = s.charAt(0);
        if (ch == '-') {
            if (len == 1) {
                throw new NumberFormatException("Missing digits:  " + s);
            }
            sign = 1;
        } else {
            int d = ch - 48;
            if (d < 0 || d > 9) {
                throw new NumberFormatException("Malformed:  " + s);
            }
            num = -d;
        }
        int max = sign == -1 ? -2147483647 : Integer.MIN_VALUE;
        int multmax = max / 10;
        int i = 1;
        while (i < len) {
            int d;
            if ((d = s.charAt(i++) - 48) < 0 || d > 9) {
                throw new NumberFormatException("Malformed:  " + s);
            }
            if (num < multmax) {
                throw new NumberFormatException("Over/underflow:  " + s);
            }
            if ((num *= 10) < max + d) {
                throw new NumberFormatException("Over/underflow:  " + s);
            }
            num -= d;
        }
        return sign * num;
    }

    public static long strToLong(String value, long longDefault) {
        if (Util.isEmpty(value)) {
            return longDefault;
        }
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            return longDefault;
        }
    }

    public static double strToDouble(String value, double doubleDefault) {
        if (Util.isEmpty(value)) {
            return doubleDefault;
        }
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException e) {
            return doubleDefault;
        }
    }

    public static <T> T get(T[] array, int index) {
        if (index >= 0 && index < array.length) {
            return array[index];
        }
        return null;
    }

    public static <T> boolean checkIndex(int index, T[] array) {
        return array != null && index >= 0 && index < array.length;
    }

    public static boolean checkFlag(int value, int flag) {
        return (value & flag) == flag;
    }

    public static SUPPORTED_OS getOS() {
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            return SUPPORTED_OS.WINDOWS;
        }
        if (osName.contains("OS X")) {
            return SUPPORTED_OS.MAC;
        }
        return SUPPORTED_OS.LINUX;
    }

    public static void openURL(String url) {
        String osName = System.getProperty("os.name");
        try {
            if (osName.contains("OS X")) {
                Runtime.getRuntime().exec("open " + url);
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + url);
            } else {
                boolean found = false;
                for (String browser : browsers) {
                    if (found) continue;
                    boolean bl = found = Runtime.getRuntime().exec(new String[]{"which", browser}).waitFor() == 0;
                    if (!found) continue;
                    Runtime.getRuntime().exec(new String[]{browser, url});
                }
                if (!found) {
                    throw new Exception("No browser found.");
                }
            }
        }
        catch (Throwable e) {
            throw new OkapiException("Error attempting to launch web browser.", e);
        }
    }

    public static void openWikiTopic(String topic) {
        try {
            topic = topic.replace(' ', '_');
            Util.openURL(new URL(String.format("http://www.opentag.com/okapi/wiki/index.php?title=%s", topic)).toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }

    public static String getClassLocation(Class<?> theClass) {
        String res = null;
        File file = new File(theClass.getProtectionDomain().getCodeSource().getLocation().getFile());
        res = Util.URLDecodeUTF8(file.getAbsolutePath());
        if (res.endsWith(".jar")) {
            res = Util.getDirectoryName(res);
        }
        return res;
    }

    public static String fillRootDirectoryVariable(String original, String rootDir) {
        if (rootDir == null) {
            rootDir = System.getProperty("user.dir");
        }
        return original.replace(ROOT_DIRECTORY_VAR, rootDir);
    }

    public static String fillInputRootDirectoryVariable(String original, String inputRootDir) {
        if (inputRootDir == null) {
            inputRootDir = "";
        }
        return original.replace(INPUT_ROOT_DIRECTORY_VAR, inputRootDir);
    }

    public static String fillSystemEnvars(String original) {
        for (Map.Entry<String, String> e : System.getenv().entrySet()) {
            original = original.replace(String.format("${%s}", e.getKey()), e.getValue());
        }
        return original;
    }

    public static boolean validateVariables(String text, boolean allowEnvar, boolean allowRootDir, boolean allowInputRootDir) {
        Matcher m = VARIABLE_REGEX_PATTERN.matcher(text);
        while (m.find()) {
            String var = m.group();
            String varName = m.group(1);
            if (allowEnvar && System.getenv().containsKey(varName) || allowRootDir && var.equals(ROOT_DIRECTORY_VAR) || allowInputRootDir && var.equals(INPUT_ROOT_DIRECTORY_VAR)) continue;
            return false;
        }
        return true;
    }

    public static String expandPath(String path, String rootDir, String inputRootDir) throws IOException {
        if (!path.contains("${")) {
            return path;
        }
        path = Util.fillSystemEnvars(path);
        path = Util.fillRootDirectoryVariable(path, rootDir);
        path = Util.fillInputRootDirectoryVariable(path, inputRootDir);
        path = new File(path).getCanonicalPath();
        return path;
    }

    public static int min(int ... values) {
        int res = Integer.MAX_VALUE;
        for (int value : values) {
            res = Math.min(res, value);
        }
        return values.length > 0 ? res : 0;
    }

    public static <K, V> V getValue(Map<K, V> map, K key, V defaultValue) {
        if (map == null) {
            return defaultValue;
        }
        if (!map.containsKey(key)) {
            return defaultValue;
        }
        return map.get(key);
    }

    public static int normalizeRange(double low, double high, double value) {
        double m = 0.0;
        double n = 100.0;
        return (int)(m + (value - low) / (high - low) * (n - m));
    }

    public static String formatDouble(Double value) {
        if (value == null) {
            return "";
        }
        String tmp = String.format(Locale.ENGLISH, "%f", value);
        while (tmp.length() > 1 && tmp.charAt(tmp.length() - 1) == '0') {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        if (tmp.charAt(tmp.length() - 1) == '.') {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    public static boolean isValidInXML(int ch) {
        if (ch > 31 && ch < 55296) {
            return true;
        }
        if (ch > 55295) {
            if (ch < 57344) {
                return false;
            }
            return ch != 65534 && ch != 65535;
        }
        switch (ch) {
            case 9: 
            case 10: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    public static String URLDecodeUTF8(String s) {
        try {
            return URLDecoder.decode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String URLEncodeUTF8(String s) {
        try {
            return URLEncoder.encode(s, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static PrintWriter charsetPrintWriter(String filePath, Charset charset) throws FileNotFoundException {
        return new PrintWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(filePath)), charset));
    }

    public static Reader skipBOM(Reader r) throws IOException {
        PushbackReader pb = new PushbackReader(r, 1);
        char bom = (char)pb.read();
        if (bom != '\ufeff') {
            pb.unread(bom);
        }
        return pb;
    }

    public static <T extends Comparable<T>> Comparator<T> createComparatorHandlingNullKeys(Class<T> clazz) {
        return new Comparator<T>(){

            @Override
            public int compare(T s1, T s2) {
                if (s1 == null && s2 != null) {
                    return -1;
                }
                if (s1 == null && s2 == null) {
                    return 0;
                }
                if (s1 != null && s2 == null) {
                    return 1;
                }
                return s1.compareTo(s2);
            }
        };
    }

    public static XPathFactory createXPathFactory() {
        try {
            return XPathFactory.newInstance();
        }
        catch (Exception e) {
            try {
                return XPathFactory.newInstance("http://java.sun.com/jaxp/xpath/dom", "net.sf.saxon.xpath.XPathFactoryImpl", ClassLoader.getSystemClassLoader());
            }
            catch (Exception exception) {
                return null;
            }
        }
    }

    public static enum SUPPORTED_OS {
        WINDOWS,
        MAC,
        LINUX;

    }
}

