/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.its.html5;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.GenericAnnotation;
import net.sf.okapi.common.annotation.GenericAnnotations;
import net.sf.okapi.common.encoder.EncoderContext;
import net.sf.okapi.common.filterwriter.ITSContent;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.DocumentPart;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.common.skeleton.GenericSkeletonPart;
import net.sf.okapi.common.skeleton.GenericSkeletonWriter;

public class HTML5SkeletonWriter
extends GenericSkeletonWriter {
    private List<GenericAnnotations> standoff;
    private ITSContent itsCont;

    @Override
    public String getContent(TextFragment tf, LocaleId locToUse, EncoderContext context) {
        if (!tf.hasCode()) {
            if (this.encoderManager == null) {
                if (this.layer == null) {
                    return tf.toText();
                }
                return this.layer.encode(tf.toText(), context);
            }
            if (this.layer == null) {
                return this.encoderManager.encode(tf.toText(), context);
            }
            return this.layer.encode(this.encoderManager.encode(tf.toText(), context), context);
        }
        List<Code> codes = tf.getCodes();
        StringBuilder tmp = new StringBuilder();
        String text = tf.getCodedText();
        block5: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\ue101': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (code.hasOnlyAnnotation()) {
                        tmp.append("<span");
                        this.outputAnnotation(code, tmp);
                        tmp.append(">");
                        continue block5;
                    }
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                case '\ue102': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    if (code.hasOnlyAnnotation()) {
                        tmp.append("</span>");
                        continue block5;
                    }
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                case '\ue103': {
                    Code code = codes.get(TextFragment.toIndex(text.charAt(++i)));
                    tmp.append(this.expandCodeContent(code, locToUse, context));
                    continue block5;
                }
                default: {
                    if (Character.isHighSurrogate(ch)) {
                        int cp = text.codePointAt(i);
                        ++i;
                        if (this.encoderManager == null) {
                            if (this.layer == null) {
                                tmp.append(new String(Character.toChars(cp)));
                                continue block5;
                            }
                            tmp.append(this.layer.encode(cp, context));
                            continue block5;
                        }
                        if (this.layer == null) {
                            tmp.append(this.encoderManager.encode(cp, context));
                            continue block5;
                        }
                        tmp.append(this.layer.encode(this.encoderManager.encode(cp, context), context));
                        continue block5;
                    }
                    if (this.encoderManager == null) {
                        if (this.layer == null) {
                            tmp.append(ch);
                            continue block5;
                        }
                        tmp.append(this.layer.encode(ch, context));
                        continue block5;
                    }
                    if (this.layer == null) {
                        tmp.append(this.encoderManager.encode(ch, context));
                        continue block5;
                    }
                    tmp.append(this.layer.encode(this.encoderManager.encode(ch, context), context));
                }
            }
        }
        return tmp.toString();
    }

    @Override
    public String processDocumentPart(DocumentPart resource) {
        GenericSkeletonPart part;
        GenericSkeleton skel = (GenericSkeleton)resource.getSkeleton();
        if (skel != null && (part = skel.getFirstPart()).getData().toString().equals("$#@StandOff@#$")) {
            part.setData("");
            if (!Util.isEmpty(this.standoff)) {
                if (this.itsCont == null) {
                    this.itsCont = new ITSContent(this.encoderManager.getCharsetEncoder(), true, false);
                }
                part.append(this.itsCont.writeStandoffLQI(this.standoff));
                part.append(this.itsCont.writeStandoffProvenance(this.standoff));
            }
        }
        return super.processDocumentPart(resource);
    }

    private void outputAnnotation(Code code, StringBuilder output) {
        GenericAnnotations newSet;
        String refId;
        GenericAnnotations anns = code.getGenericAnnotations();
        if (anns == null) {
            return;
        }
        for (GenericAnnotation ann : anns) {
            if (ann.getType().equals("its-ta")) {
                this.printITSStringAttribute(ann.getString("taClass"), "ta-class", output);
                this.printITSDoubleAttribute(ann.getDouble("taConfidence"), "taConfidence", output);
                this.printITSStringAttribute(ann.getString("taIdent"), "ta-ident", output);
                this.printITSStringAttribute(ann.getString("taSource"), "ta-source", output);
                continue;
            }
            if (ann.getType().equals("its-term")) {
                this.printITSBooleanAttribute(true, "term", output);
                this.printITSDoubleAttribute(ann.getDouble("termConfidence"), "term-confidence", output);
                this.printITSStringAttribute(ann.getString("termInfo"), "term-info", output);
                continue;
            }
            if (ann.getType().equals("its-allowedchars")) {
                this.printITSStringAttribute(ann.getString("allowedcharsValue"), "allowed-characters", output);
                continue;
            }
            if (ann.getType().equals("its-storagesize")) {
                this.printITSIntegerAttribute(ann.getInteger("storagesizeSize"), "storage-size", output);
                String tmp = ann.getString("storagesizeEncoding");
                if (!tmp.equals("UTF-8")) {
                    this.printITSStringAttribute(tmp, "storage-encoding", output);
                }
                if ((tmp = ann.getString("storagesizeLinebreak")).equals("lf")) continue;
                this.printITSStringAttribute(tmp, "storage-linebreak", output);
                continue;
            }
            if (!ann.getType().equals("its-lqi") && !ann.getType().equals("its-prov")) continue;
        }
        List<GenericAnnotation> list = anns.getAnnotations("its-lqi");
        if (list.size() == 1) {
            GenericAnnotation ann;
            ann = list.get(0);
            this.printITSStringAttribute(ann.getString("lqiComment"), "loc-quality-issue-comment", output);
            Boolean booVal = ann.getBoolean("lqiEnabled");
            if (booVal != null && !booVal.booleanValue()) {
                this.printITSBooleanAttribute(booVal, "loc-quality-issue-enabled", output);
            }
            this.printITSStringAttribute(ann.getString("lqiProfileRef"), "loc-quality-issue-profile", output);
            this.printITSDoubleAttribute(ann.getDouble("lqiSeverity"), "loc-quality-issue-severity", output);
            this.printITSStringAttribute(ann.getString("lqiType"), "loc-quality-issue-type", output);
        } else if (list.size() > 1) {
            refId = anns.getData();
            output.append(" its-loc-quality-issues-ref=\"#" + refId + "\"");
            if (this.standoff == null) {
                this.standoff = new ArrayList<GenericAnnotations>();
            }
            newSet = new GenericAnnotations();
            this.standoff.add(newSet);
            newSet.setData(refId);
            newSet.addAll(list);
        }
        list = anns.getAnnotations("its-prov");
        if (list.size() != 1 && list.size() > 1) {
            refId = anns.getData();
            output.append(" its-provenance-records-ref=\"#" + refId + "\"");
            if (this.standoff == null) {
                this.standoff = new ArrayList<GenericAnnotations>();
            }
            newSet = new GenericAnnotations();
            this.standoff.add(newSet);
            newSet.setData(refId);
            newSet.addAll(list);
        }
    }

    private void printITSStringAttribute(String value, String attrName, StringBuilder output) {
        if (value != null) {
            String ref = "";
            if (value.startsWith("REF:")) {
                ref = "-ref";
                value = value.substring("REF:".length());
            }
            output.append(" its-" + attrName + ref + "=\"" + this.encoderManager.encode(value, EncoderContext.INLINE) + "\"");
        }
    }

    private void printITSDoubleAttribute(Double value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" its-" + attrName + "=\"" + Util.formatDouble(value) + "\"");
        }
    }

    private void printITSIntegerAttribute(Integer value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" its-" + attrName + "=\"" + value + "\"");
        }
    }

    private void printITSBooleanAttribute(Boolean value, String attrName, StringBuilder output) {
        if (value != null) {
            output.append(" its-" + attrName + "=\"" + (value != false ? "yes" : "no") + "\"");
        }
    }
}

