/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.filters.openxml.ConditionalParameters;
import net.sf.okapi.filters.openxml.DocumentType;
import net.sf.okapi.filters.openxml.ExcelStyles;
import net.sf.okapi.filters.openxml.ExcelWorkbook;
import net.sf.okapi.filters.openxml.ExcelWorksheetPartHandler;
import net.sf.okapi.filters.openxml.Namespaces;
import net.sf.okapi.filters.openxml.NonTranslatablePartHandler;
import net.sf.okapi.filters.openxml.OpenXMLContentFilter;
import net.sf.okapi.filters.openxml.OpenXMLPartHandler;
import net.sf.okapi.filters.openxml.OpenXMLZipFile;
import net.sf.okapi.filters.openxml.ParseType;
import net.sf.okapi.filters.openxml.Relationships;
import net.sf.okapi.filters.openxml.SharedStringMap;
import net.sf.okapi.filters.openxml.SharedStringPartHandler;
import net.sf.okapi.filters.openxml.StandardPartHandler;
import net.sf.okapi.filters.openxml.ZipEntryComparator;

public class ExcelDocument
extends DocumentType {
    private SharedStringMap sharedStringMap = new SharedStringMap();
    private List<String> worksheetEntryNames = null;
    private ExcelStyles styles;
    private Relationships workbookRels;
    private static final String SHARED_STRING_TABLE_REL = Namespaces.DocumentRels.getDerivedURI("/sharedStrings");
    private static final String STYLES_REL = Namespaces.DocumentRels.getDerivedURI("/styles");

    ExcelDocument(OpenXMLZipFile zipFile, ConditionalParameters params) {
        super(zipFile, params);
    }

    @Override
    public ParseType getDefaultParseType() {
        return ParseType.MSEXCEL;
    }

    @Override
    public void initialize() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentPart();
        this.workbookRels = this.getZipFile().getRelationshipsForPart(mainDocumentPart);
        this.worksheetEntryNames = this.findWorksheets();
        this.styles = this.parseStyles();
    }

    @Override
    public OpenXMLPartHandler getHandlerForFile(ZipEntry entry, String contentType, boolean squishable) {
        if (!this.isTranslatableType(entry.getName(), contentType)) {
            return new NonTranslatablePartHandler(this.getZipFile(), entry);
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
            return new ExcelWorksheetPartHandler(this.getZipFile(), entry, this.sharedStringMap, this.styles, this.findWorksheetNumber(entry.getName()), this.getParams());
        }
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml")) {
            return new SharedStringPartHandler(this.getZipFile(), entry, this.sharedStringMap, this.getParams());
        }
        OpenXMLContentFilter openXMLContentFilter = new OpenXMLContentFilter(this.getZipFile().getFactories(), this.getParams());
        ParseType parseType = ParseType.MSEXCEL;
        if (contentType.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml")) {
            parseType = ParseType.MSEXCELCOMMENT;
        } else if ("application/vnd.openxmlformats-package.core-properties+xml".equals(contentType)) {
            parseType = ParseType.MSWORDDOCPROPERTIES;
        }
        openXMLContentFilter.setUpConfig(parseType);
        openXMLContentFilter.setPartName(entry.getName());
        return new StandardPartHandler(openXMLContentFilter, this.getParams(), this.getZipFile(), entry, false);
    }

    private boolean isTranslatableType(String entryName, String type) {
        if (!entryName.endsWith(".xml")) {
            return false;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.sharedStrings+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.worksheet+xml")) {
            return true;
        }
        if (this.getParams().getTranslateComments() && type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.comments+xml")) {
            return true;
        }
        if (type.equals("application/vnd.openxmlformats-officedocument.spreadsheetml.table+xml")) {
            return true;
        }
        return this.getParams().getTranslateDocProperties() && type.equals("application/vnd.openxmlformats-package.core-properties+xml");
    }

    @Override
    public Enumeration<? extends ZipEntry> getZipFileEntries() throws IOException, XMLStreamException {
        Enumeration<? extends ZipEntry> entries = this.getZipFile().entries();
        ArrayList<? extends ZipEntry> entryList = Collections.list(entries);
        ArrayList<String> worksheetsAndSharedStrings = new ArrayList<String>();
        worksheetsAndSharedStrings.addAll(this.worksheetEntryNames);
        worksheetsAndSharedStrings.add(this.findSharedStrings());
        Collections.sort(entryList, new ZipEntryComparator(worksheetsAndSharedStrings));
        return Collections.enumeration(entryList);
    }

    public ExcelWorkbook parseWorkbook(String partName) throws IOException, XMLStreamException {
        XMLEventReader r = this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(partName));
        return ExcelWorkbook.parseFrom(r);
    }

    ExcelStyles parseStyles() throws IOException, XMLStreamException {
        Relationships.Rel stylesRel = this.workbookRels.getRelByType(STYLES_REL).get(0);
        ExcelStyles styles = new ExcelStyles();
        styles.parse(this.getZipFile().getInputFactory().createXMLEventReader(this.getZipFile().getPartReader(stylesRel.target)));
        return styles;
    }

    List<String> findWorksheets() throws IOException, XMLStreamException {
        ArrayList<String> worksheets = new ArrayList<String>();
        ExcelWorkbook workbook = this.parseWorkbook(this.getZipFile().getMainDocumentPart());
        List<ExcelWorkbook.Sheet> sheets = workbook.getSheets();
        for (ExcelWorkbook.Sheet sheet : sheets) {
            Relationships.Rel sheetRel = this.workbookRels.getRelById(sheet.relId);
            worksheets.add(sheetRel.target);
        }
        return worksheets;
    }

    String findSharedStrings() throws IOException, XMLStreamException {
        String mainDocumentPart = this.getZipFile().getMainDocumentPart();
        Relationships rels = this.getZipFile().getRelationshipsForPart(mainDocumentPart);
        List<Relationships.Rel> r = rels.getRelByType(SHARED_STRING_TABLE_REL);
        if (r == null || r.size() != 1) {
            throw new OkapiBadFilterInputException("Excel document has unexpected number of string tables");
        }
        return r.get((int)0).target;
    }

    int findWorksheetNumber(String worksheetEntryName) {
        for (int i = 0; i < this.worksheetEntryNames.size(); ++i) {
            if (!worksheetEntryName.equals(this.worksheetEntryNames.get(i))) continue;
            return i + 1;
        }
        throw new IllegalStateException("No worksheet entry with name " + worksheetEntryName + " in " + this.worksheetEntryNames);
    }
}

