/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.filters;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.lib.extra.filters.AbstractBaseFilter;
import net.sf.okapi.lib.extra.filters.CompoundFilterParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompoundFilter
extends AbstractBaseFilter {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private LinkedList<IFilter> subFilters = new LinkedList();
    private IFilter activeSubFilter = null;
    private RawDocument input;

    public IFilter getActiveSubFilter() {
        return this.activeSubFilter;
    }

    protected void setActiveSubFilter(IFilter activeSubFilter) {
        this.activeSubFilter = activeSubFilter;
        IParameters params = this.getParameters();
        if (params instanceof CompoundFilterParameters && activeSubFilter instanceof AbstractBaseFilter) {
            ((CompoundFilterParameters)params).setActiveParameters(((AbstractBaseFilter)activeSubFilter).getParametersClassName());
        }
    }

    protected <A extends AbstractBaseFilter> boolean addSubFilter(Class<A> subFilterClass) {
        if (this.subFilters == null) {
            return false;
        }
        boolean res = false;
        IFilter curSubFilter = null;
        try {
            Constructor<A> cc = subFilterClass.getConstructor(new Class[0]);
            if (cc == null) {
                return false;
            }
            curSubFilter = (IFilter)cc.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            this.logger.debug("Subfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        catch (IllegalAccessException e) {
            this.logger.debug("Subfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        catch (SecurityException e) {
            this.logger.debug("Subfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        catch (NoSuchMethodException e) {
            this.logger.debug("Subfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        catch (IllegalArgumentException e) {
            this.logger.debug("Subfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        catch (InvocationTargetException e) {
            this.logger.debug("Subfilter instantiation failed: {}", (Object)e.getMessage());
            return false;
        }
        res = this.subFilters.add(curSubFilter);
        if (!res) {
            return false;
        }
        curSubFilter = this.subFilters.getLast();
        if (curSubFilter == null) {
            return false;
        }
        this.addConfigurations(curSubFilter.getConfigurations());
        if (this.activeSubFilter == null) {
            this.activeSubFilter = curSubFilter;
        }
        return res;
    }

    @Override
    public void setParameters(IParameters params) {
        super.setParameters(params);
        if (params == null && this.activeSubFilter != null) {
            this.activeSubFilter.setParameters(null);
        }
    }

    public IParameters getActiveParameters() {
        return this.activeSubFilter != null ? this.activeSubFilter.getParameters() : null;
    }

    private String getDefaultConfigId() {
        if (Util.isEmpty(this.configList)) {
            return "";
        }
        FilterConfiguration config = (FilterConfiguration)this.configList.get(0);
        if (config == null) {
            return "";
        }
        return config.configId;
    }

    @Override
    public boolean setConfiguration(String configId) {
        IParameters params2;
        FilterConfiguration config;
        IFilter subFilter;
        boolean res = super.setConfiguration(configId);
        if (Util.isEmpty(configId)) {
            configId = this.getDefaultConfigId();
        }
        if ((res &= (subFilter = this.findConfigProvider(configId)) != null) && this.activeSubFilter != subFilter) {
            this.setActiveSubFilter(subFilter);
        }
        if ((config = this.findConfiguration(configId)) == null) {
            return res;
        }
        IParameters params = this.getParameters();
        if (config.parametersLocation != null && params instanceof CompoundFilterParameters) {
            URL url = this.getClass().getResource(config.parametersLocation);
            try {
                params.load(url.toURI(), false);
            }
            catch (URISyntaxException e) {
                throw new OkapiException(String.format("URI syntax error '%s'.", url.getPath()));
            }
        }
        if ((params2 = this.getActiveParameters()) != null) {
            params2.fromString(params.toString());
        }
        return res;
    }

    private IFilter findConfigProvider(String configId) {
        if (Util.isEmpty(this.configList)) {
            return null;
        }
        for (FilterConfiguration config : this.configList) {
            if (config == null || !config.configId.equalsIgnoreCase(configId)) continue;
            return this.findSubFilter(config.filterClass);
        }
        return null;
    }

    private IFilter findSubFilter(String filterClass) {
        if (Util.isEmpty(filterClass)) {
            return null;
        }
        if (this.subFilters == null) {
            return null;
        }
        for (IFilter subFilter : this.subFilters) {
            if (subFilter == null || subFilter.getClass() == null || !subFilter.getClass().getName().equalsIgnoreCase(filterClass)) continue;
            return subFilter;
        }
        return null;
    }

    private IFilter findSubFilterByParameters(String parametersClassName) {
        if (Util.isEmpty(parametersClassName)) {
            return null;
        }
        if (this.subFilters == null) {
            return null;
        }
        for (IFilter subFilter : this.subFilters) {
            if (!(subFilter instanceof AbstractBaseFilter) || !((AbstractBaseFilter)subFilter).getParametersClassName().equalsIgnoreCase(parametersClassName)) continue;
            return subFilter;
        }
        return null;
    }

    @Override
    public void cancel() {
        if (this.activeSubFilter != null) {
            this.activeSubFilter.cancel();
        }
    }

    @Override
    public void close() {
        if (this.input != null) {
            this.input.close();
        }
        if (this.activeSubFilter != null) {
            this.activeSubFilter.close();
        }
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return this.activeSubFilter != null ? this.activeSubFilter.createFilterWriter() : null;
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return this.activeSubFilter != null ? this.activeSubFilter.createSkeletonWriter() : null;
    }

    @Override
    public boolean hasNext() {
        return this.activeSubFilter != null ? this.activeSubFilter.hasNext() : false;
    }

    @Override
    public Event next() {
        Event event;
        Event event2 = event = this.activeSubFilter != null ? this.activeSubFilter.next() : null;
        if (event != null && event.getEventType() == EventType.START_DOCUMENT) {
            StartDocument startDoc = (StartDocument)event.getResource();
            startDoc.setFilterParameters(this.getParameters());
        }
        return event;
    }

    @Override
    public void open(RawDocument input) {
        this.input = input;
        if (this.activeSubFilter != null) {
            this.activeSubFilter.open(input);
        }
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        if (this.activeSubFilter != null) {
            this.activeSubFilter.open(input, generateSkeleton);
        }
    }

    private void updateSubfilter() {
        IParameters params = this.getParameters();
        String className = "";
        if (!(params instanceof CompoundFilterParameters)) {
            return;
        }
        className = ((CompoundFilterParameters)params).getParametersClassName();
        if (Util.isEmpty(className)) {
            return;
        }
        this.activeSubFilter = this.findSubFilterByParameters(className);
        IParameters params2 = this.getActiveParameters();
        if (params2 != null && params != null) {
            params2.fromString(params.toString());
        }
        if (this.activeSubFilter != null) {
            this.activeSubFilter.setParameters(params2);
        }
    }

    @Override
    public boolean exec(Object sender, String command, Object info) {
        if (super.exec(sender, command, info)) {
            return true;
        }
        if (command.equalsIgnoreCase("parameters_changed")) {
            this.updateSubfilter();
            return true;
        }
        return false;
    }

    @Override
    protected void component_done() {
    }

    @Override
    protected void component_init() {
    }
}

