/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.verification;

import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IssueType;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.query.IQuery;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.connectors.google.GoogleMTv2Connector;
import net.sf.okapi.connectors.google.GoogleMTv2Parameters;
import net.sf.okapi.lib.verification.Issue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LanguageToolConnector {
    private ArrayList<Issue> issues = new ArrayList();
    private String lang;
    private String motherTongue;
    private String serverUrl;
    private DocumentBuilder docBuilder;
    private IQuery mt;
    private boolean bilingualMode;

    public LanguageToolConnector() {
        DocumentBuilderFactory Fact = DocumentBuilderFactory.newInstance();
        Fact.setValidating(false);
        try {
            this.docBuilder = Fact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new OkapiException("Error creating document builder.", e);
        }
    }

    public void initialize(LocaleId locId, LocaleId motherLocId, String serverUrl, boolean translateLTMsg, boolean bilingualMode, String ltTranslationSource, String ltTranslationTarget, String ltTranslationServiceKey) {
        this.lang = locId.getLanguage();
        this.motherTongue = motherLocId.getLanguage();
        if (!serverUrl.endsWith("/")) {
            serverUrl = serverUrl + "/";
        }
        this.serverUrl = serverUrl;
        if (this.mt != null) {
            this.mt.close();
            this.mt = null;
        }
        this.bilingualMode = bilingualMode;
        if (translateLTMsg) {
            this.mt = new GoogleMTv2Connector();
            GoogleMTv2Parameters prm = (GoogleMTv2Parameters)this.mt.getParameters();
            prm.setApiKey(ltTranslationServiceKey);
            this.mt.setLanguages(LocaleId.fromBCP47(ltTranslationSource), LocaleId.fromBCP47(ltTranslationTarget));
            this.mt.open();
        }
    }

    public List<Issue> getIssues() {
        return this.issues;
    }

    public int checkSegment(URI docId, String subDocId, Segment srcSeg, Segment trgSeg, ITextUnit tu) {
        this.issues.clear();
        if (!trgSeg.text.hasText()) {
            return 0;
        }
        String ctext = trgSeg.text.getCodedText();
        try {
            URL url = this.bilingualMode ? new URL(this.serverUrl + String.format("?language=%s&text=%s&srctext=%s&motherTongue=%s", this.lang, URLEncoder.encode(ctext, "UTF-8"), URLEncoder.encode(srcSeg.text.getCodedText(), "UTF-8"), this.motherTongue)) : new URL(this.serverUrl + String.format("?language=%s&text=%s", this.lang, URLEncoder.encode(ctext, "UTF-8")));
            URLConnection conn = url.openConnection();
            Document doc = this.docBuilder.parse(conn.getInputStream(), "UTF-8");
            NodeList errors = doc.getDocumentElement().getElementsByTagName("error");
            for (int i = 0; i < errors.getLength(); ++i) {
                Element error = (Element)errors.item(i);
                String msg = error.getAttribute("msg");
                if (this.mt != null && this.mt.query(msg) > 0) {
                    msg = String.format("%s  (--> %s)", msg, this.mt.next().target.toText());
                }
                int start = Integer.valueOf(error.getAttribute("fromx"));
                int end = start + Integer.valueOf(error.getAttribute("errorlength"));
                Issue issue = new Issue(docId, subDocId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), msg, 0, 0, TextFragment.fromFragmentToString(trgSeg.text, start), TextFragment.fromFragmentToString(trgSeg.text, end), 1.0, tu.getName());
                this.issues.add(issue);
                String itsType = error.getAttribute("locqualityissuetype");
                if (itsType == null) continue;
                issue.setString("lqiType", itsType);
            }
        }
        catch (Throwable e) {
            this.issues.add(new Issue(docId, subDocId, IssueType.LANGUAGETOOL_ERROR, tu.getId(), trgSeg.getId(), "Error with LanguageTool server. All LT checks are skipped from this text unit on. " + e.getMessage(), 0, -99, 0, -1, 2.0, tu.getName()));
        }
        return this.issues.size();
    }

    private IssueType convertITSType(String ltType) {
        return IssueType.LANGUAGETOOL_ERROR;
    }
}

