/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.tokenization.locale;

import com.ibm.icu.util.ULocale;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Util;

public class LocaleUtil {
    public static String normalizeLanguageCode_Okapi(String languageCode) {
        if (Util.isEmpty(languageCode)) {
            return null;
        }
        String[] parts = LocaleId.splitLanguageCode(languageCode);
        StringBuilder res = new StringBuilder();
        res.append(parts[0].toLowerCase());
        if (!Util.isEmpty(parts[1])) {
            res.append("-");
            res.append(parts[1].toLowerCase());
        }
        return res.toString();
    }

    public static List<String> normalizeLanguageCodes_Okapi(List<String> languageCodes) {
        if (languageCodes == null) {
            return null;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String languageCode : languageCodes) {
            res.add(LocaleUtil.normalizeLanguageCode_Okapi(languageCode));
        }
        return res;
    }

    public static String normalizeLanguageCode_ICU(String languageCode) {
        if (Util.isEmpty(languageCode)) {
            return null;
        }
        return ULocale.canonicalize(languageCode);
    }
}

