/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.OS;

public abstract class Device
implements Drawable {
    protected int xDisplay;
    int shellHandle;
    public static boolean DEBUG;
    boolean debug = DEBUG;
    boolean tracking = DEBUG;
    Error[] errors;
    Object[] objects;
    Object trackingLock;
    GdkColor[] gdkColors;
    int[] colorRefCount;
    boolean disposed;
    int logProc;
    Callback logCallback;
    String[] log_domains = new String[]{"GLib-GObject", "GLib", "GObject", "Pango", "ATK", "GdkPixbuf", "Gdk", "Gtk", "GnomeVFS", "GIO"};
    int[] handler_ids = new int[this.log_domains.length];
    int warningLevel;
    static Callback XErrorCallback;
    static Callback XIOErrorCallback;
    static int XErrorProc;
    static int XIOErrorProc;
    static int XNullErrorProc;
    static int XNullIOErrorProc;
    static Device[] Devices;
    Color COLOR_BLACK;
    Color COLOR_DARK_RED;
    Color COLOR_DARK_GREEN;
    Color COLOR_DARK_YELLOW;
    Color COLOR_DARK_BLUE;
    Color COLOR_DARK_MAGENTA;
    Color COLOR_DARK_CYAN;
    Color COLOR_GRAY;
    Color COLOR_DARK_GRAY;
    Color COLOR_RED;
    Color COLOR_GREEN;
    Color COLOR_YELLOW;
    Color COLOR_BLUE;
    Color COLOR_MAGENTA;
    Color COLOR_CYAN;
    Color COLOR_WHITE;
    Font systemFont;
    Point dpi;
    int emptyTab;
    boolean useXRender;
    static boolean CAIRO_LOADED;
    protected static Device CurrentDevice;
    protected static Runnable DeviceFinder;
    static /* synthetic */ Class class$0;

    static {
        Devices = new Device[4];
        try {
            Class.forName("org.eclipse.swt.widgets.Display");
        }
        catch (ClassNotFoundException classNotFoundException) {}
    }

    static synchronized Device getDevice() {
        if (DeviceFinder != null) {
            DeviceFinder.run();
        }
        Device device = CurrentDevice;
        CurrentDevice = null;
        return device;
    }

    public Device() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device(DeviceData deviceData) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (deviceData != null) {
                this.debug = deviceData.debug;
                this.tracking = deviceData.tracking;
            }
            if (this.tracking) {
                this.errors = new Error[128];
                this.objects = new Object[128];
                this.trackingLock = new Object();
            }
            this.create(deviceData);
            this.init();
            Device.register(this);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    void checkCairo() {
        if (CAIRO_LOADED) {
            return;
        }
        try {
            byte[] byArray;
            int n = OS.RTLD_LAZY;
            if (OS.IsAIX) {
                byArray = Converter.wcsToMbcs(null, "libcairo.a(libcairo.so.2)", true);
                n |= 0x40000;
            } else {
                byArray = OS.IsHPUX ? Converter.wcsToMbcs(null, "libcairo.so", true) : Converter.wcsToMbcs(null, "libcairo.so.2", true);
            }
            int n2 = OS.dlopen(byArray, n);
            if (n2 != 0) {
                OS.dlclose(n2);
            } else {
                try {
                    System.loadLibrary("cairo-swt");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
            }
            Class.forName("org.eclipse.swt.internal.cairo.Cairo");
            CAIRO_LOADED = true;
        }
        catch (Throwable throwable) {
            SWT.error(16, throwable, " [Cairo is required]");
        }
    }

    protected void checkDevice() {
        if (this.disposed) {
            SWT.error(45);
        }
    }

    protected void create(DeviceData deviceData) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.checkDevice();
            this.release();
            this.destroy();
            Device.deregister(this);
            this.xDisplay = 0;
            this.disposed = true;
            if (this.tracking) {
                Object object = this.trackingLock;
                synchronized (object) {
                    this.objects = null;
                    this.errors = null;
                    this.trackingLock = null;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == object) {
                    this.objects[n] = null;
                    this.errors[n] = null;
                    return;
                }
                ++n;
            }
        }
    }

    static synchronized Device findDevice(int n) {
        int n2 = 0;
        while (n2 < Devices.length) {
            Device device = Devices[n2];
            if (device != null && device.xDisplay == n) {
                return device;
            }
            ++n2;
        }
        return null;
    }

    static synchronized void deregister(Device device) {
        int n = 0;
        while (n < Devices.length) {
            if (device == Devices[n]) {
                Device.Devices[n] = null;
            }
            ++n;
        }
    }

    protected void destroy() {
    }

    public Rectangle getBounds() {
        this.checkDevice();
        return new Rectangle(0, 0, 0, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeviceData getDeviceData() {
        this.checkDevice();
        DeviceData deviceData = new DeviceData();
        deviceData.debug = this.debug;
        deviceData.tracking = this.tracking;
        if (this.tracking) {
            Object object = this.trackingLock;
            synchronized (object) {
                int n = 0;
                int n2 = this.objects.length;
                int n3 = 0;
                while (n3 < n2) {
                    if (this.objects[n3] != null) {
                        ++n;
                    }
                    ++n3;
                }
                n3 = 0;
                deviceData.objects = new Object[n];
                deviceData.errors = new Error[n];
                int n4 = 0;
                while (n4 < n2) {
                    if (this.objects[n4] != null) {
                        deviceData.objects[n3] = this.objects[n4];
                        deviceData.errors[n3] = this.errors[n4];
                        ++n3;
                    }
                    ++n4;
                }
            }
        } else {
            deviceData.objects = new Object[0];
            deviceData.errors = new Error[0];
        }
        return deviceData;
    }

    public Rectangle getClientArea() {
        this.checkDevice();
        return this.getBounds();
    }

    public int getDepth() {
        this.checkDevice();
        return 0;
    }

    public Point getDPI() {
        this.checkDevice();
        return this.getScreenDPI();
    }

    public FontData[] getFontList(String string, boolean bl) {
        this.checkDevice();
        if (!bl) {
            return new FontData[0];
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        int[] nArray4 = new int[1];
        int[] nArray5 = new int[1];
        int[] nArray6 = new int[1];
        int n = OS.gdk_pango_context_get();
        OS.pango_context_list_families(n, nArray3, nArray4);
        int n2 = 0;
        FontData[] fontDataArray = new FontData[string != null ? 4 : nArray4[0]];
        int n3 = 0;
        while (n3 < nArray4[0]) {
            Object object;
            Object object2;
            int n4;
            int n5;
            OS.memmove(nArray, nArray3[0] + n3 * OS.PTR_SIZEOF, OS.PTR_SIZEOF);
            boolean bl2 = true;
            if (string != null) {
                n5 = OS.pango_font_family_get_name(nArray[0]);
                n4 = OS.strlen(n5);
                object2 = new byte[n4];
                OS.memmove((byte[])object2, n5, n4);
                object = new String(Converter.mbcsToWcs(null, (byte[])object2));
                bl2 = Compatibility.equalsIgnoreCase(string, (String)object);
            }
            if (bl2) {
                OS.pango_font_family_list_faces(nArray[0], nArray5, nArray6);
                n5 = 0;
                while (n5 < nArray6[0]) {
                    OS.memmove(nArray2, nArray5[0] + n5 * OS.PTR_SIZEOF, OS.PTR_SIZEOF);
                    n4 = OS.pango_font_face_describe(nArray2[0]);
                    object2 = Font.gtk_new(this, n4);
                    object = ((Font)object2).getFontData()[0];
                    if (n2 == fontDataArray.length) {
                        FontData[] fontDataArray2 = new FontData[fontDataArray.length + nArray4[0]];
                        System.arraycopy(fontDataArray, 0, fontDataArray2, 0, n2);
                        fontDataArray = fontDataArray2;
                    }
                    fontDataArray[n2++] = object;
                    OS.pango_font_description_free(n4);
                    ++n5;
                }
                OS.g_free(nArray5[0]);
                if (string != null) break;
            }
            ++n3;
        }
        OS.g_free(nArray3[0]);
        OS.g_object_unref(n);
        if (n2 == fontDataArray.length) {
            return fontDataArray;
        }
        FontData[] fontDataArray3 = new FontData[n2];
        System.arraycopy(fontDataArray, 0, fontDataArray3, 0, n2);
        return fontDataArray3;
    }

    Point getScreenDPI() {
        int n = OS.gdk_screen_width_mm();
        int n2 = OS.gdk_screen_width();
        int n3 = Compatibility.round(254 * n2, n * 10);
        return new Point(n3, n3);
    }

    public Color getSystemColor(int n) {
        this.checkDevice();
        switch (n) {
            case 2: {
                return this.COLOR_BLACK;
            }
            case 4: {
                return this.COLOR_DARK_RED;
            }
            case 6: {
                return this.COLOR_DARK_GREEN;
            }
            case 8: {
                return this.COLOR_DARK_YELLOW;
            }
            case 10: {
                return this.COLOR_DARK_BLUE;
            }
            case 12: {
                return this.COLOR_DARK_MAGENTA;
            }
            case 14: {
                return this.COLOR_DARK_CYAN;
            }
            case 15: {
                return this.COLOR_GRAY;
            }
            case 16: {
                return this.COLOR_DARK_GRAY;
            }
            case 3: {
                return this.COLOR_RED;
            }
            case 5: {
                return this.COLOR_GREEN;
            }
            case 7: {
                return this.COLOR_YELLOW;
            }
            case 9: {
                return this.COLOR_BLUE;
            }
            case 11: {
                return this.COLOR_MAGENTA;
            }
            case 13: {
                return this.COLOR_CYAN;
            }
            case 1: {
                return this.COLOR_WHITE;
            }
        }
        return this.COLOR_BLACK;
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.systemFont;
    }

    public boolean getWarnings() {
        this.checkDevice();
        return this.warningLevel == 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void init() {
        boolean bl;
        Object[] objectArray;
        Object object;
        Object object2;
        int[] nArray;
        this.dpi = this.getDPI();
        if (this.xDisplay != 0 && !OS.USE_CAIRO && OS.XRenderQueryExtension(this.xDisplay, nArray = new int[1], object2 = new int[1])) {
            object = new int[1];
            objectArray = new int[1];
            OS.XRenderQueryVersion(this.xDisplay, object, objectArray);
            this.useXRender = object[0] > 0 || object[0] == 0 && objectArray[0] >= 8;
        }
        boolean bl2 = bl = OS.IsAIX && OS.PTR_SIZEOF == 8;
        if ((this.debug || bl) && this.xDisplay != 0) {
            object = object2 = (Object)this.getClass();
            // MONITORENTER : object2
            int n = 0;
            while (n < Devices.length && Devices[n] == null) {
                ++n;
            }
            if (n == Devices.length) {
                XErrorCallback = new Callback(object2, "XErrorProc", 2);
                XNullErrorProc = XErrorCallback.getAddress();
                if (XNullErrorProc == 0) {
                    SWT.error(3);
                }
                if ((XNullIOErrorProc = (XIOErrorCallback = new Callback(object2, "XIOErrorProc", 1)).getAddress()) == 0) {
                    SWT.error(3);
                }
                XErrorProc = OS.XSetErrorHandler(XNullErrorProc);
                XIOErrorProc = OS.XSetIOErrorHandler(XNullIOErrorProc);
            }
            // MONITOREXIT : object
            if (this.debug) {
                OS.XSynchronize(this.xDisplay, true);
            }
        }
        if (this.xDisplay != 0) {
            this.logCallback = new Callback(this, "logProc", 4);
            this.logProc = this.logCallback.getAddress();
            if (this.logProc == 0) {
                SWT.error(3);
            }
            if (this.debug) {
                int n = -1;
                int n2 = 0;
                while (n2 < this.log_domains.length) {
                    objectArray = Converter.wcsToMbcs(null, this.log_domains[n2], true);
                    this.handler_ids[n2] = OS.g_log_set_handler((byte[])objectArray, n, this.logProc, 0);
                    ++n2;
                }
            }
        }
        this.COLOR_BLACK = new Color(this, 0, 0, 0);
        this.COLOR_DARK_RED = new Color(this, 128, 0, 0);
        this.COLOR_DARK_GREEN = new Color(this, 0, 128, 0);
        this.COLOR_DARK_YELLOW = new Color(this, 128, 128, 0);
        this.COLOR_DARK_BLUE = new Color(this, 0, 0, 128);
        this.COLOR_DARK_MAGENTA = new Color(this, 128, 0, 128);
        this.COLOR_DARK_CYAN = new Color(this, 0, 128, 128);
        this.COLOR_GRAY = new Color(this, 192, 192, 192);
        this.COLOR_DARK_GRAY = new Color(this, 128, 128, 128);
        this.COLOR_RED = new Color(this, 255, 0, 0);
        this.COLOR_GREEN = new Color(this, 0, 255, 0);
        this.COLOR_YELLOW = new Color(this, 255, 255, 0);
        this.COLOR_BLUE = new Color(this, 0, 0, 255);
        this.COLOR_MAGENTA = new Color(this, 255, 0, 255);
        this.COLOR_CYAN = new Color(this, 0, 255, 255);
        this.COLOR_WHITE = new Color(this, 255, 255, 255);
        this.emptyTab = OS.pango_tab_array_new(1, false);
        if (this.emptyTab == 0) {
            SWT.error(2);
        }
        OS.pango_tab_array_set_tab(this.emptyTab, 0, 0, 1);
        this.shellHandle = OS.gtk_window_new(0);
        if (this.shellHandle == 0) {
            SWT.error(2);
        }
        OS.gtk_widget_realize(this.shellHandle);
        this.systemFont = this.getSystemFont();
    }

    public abstract int internal_new_GC(GCData var1);

    public abstract void internal_dispose_GC(int var1, GCData var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDisposed() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.disposed;
        }
    }

    public boolean loadFont(String string) {
        this.checkDevice();
        if (string == null) {
            SWT.error(4);
        }
        byte[] byArray = Converter.wcsToMbcs(null, string, true);
        return OS.FcConfigAppFontAddFile(0, byArray);
    }

    int logProc(int n, int n2, int n3, int n4) {
        if (this.warningLevel == 0) {
            if (DEBUG || this.debug) {
                new Error().printStackTrace();
            }
            OS.g_log_default_handler(n, n2, n3, 0);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void new_Object(Object object) {
        Object object2 = this.trackingLock;
        synchronized (object2) {
            int n = 0;
            while (n < this.objects.length) {
                if (this.objects[n] == null) {
                    this.objects[n] = object;
                    this.errors[n] = new Error();
                    return;
                }
                ++n;
            }
            Object[] objectArray = new Object[this.objects.length + 128];
            System.arraycopy(this.objects, 0, objectArray, 0, this.objects.length);
            objectArray[this.objects.length] = object;
            this.objects = objectArray;
            Error[] errorArray = new Error[this.errors.length + 128];
            System.arraycopy(this.errors, 0, errorArray, 0, this.errors.length);
            errorArray[this.errors.length] = new Error();
            this.errors = errorArray;
        }
    }

    static synchronized void register(Device device) {
        int n = 0;
        while (n < Devices.length) {
            if (Devices[n] == null) {
                Device.Devices[n] = device;
                return;
            }
            ++n;
        }
        Device[] deviceArray = new Device[Devices.length + 4];
        System.arraycopy(Devices, 0, deviceArray, 0, Devices.length);
        deviceArray[Device.Devices.length] = device;
        Devices = deviceArray;
    }

    protected void release() {
        int n;
        if (this.shellHandle != 0) {
            OS.gtk_widget_destroy(this.shellHandle);
        }
        this.shellHandle = 0;
        if (this.gdkColors != null) {
            n = OS.gdk_colormap_get_system();
            int n2 = 0;
            while (n2 < this.gdkColors.length) {
                GdkColor gdkColor = this.gdkColors[n2];
                if (gdkColor != null) {
                    while (this.colorRefCount[n2] > 0) {
                        OS.gdk_colormap_free_colors(n, gdkColor, 1);
                        int n3 = n2;
                        this.colorRefCount[n3] = this.colorRefCount[n3] - 1;
                    }
                }
                ++n2;
            }
        }
        this.gdkColors = null;
        this.colorRefCount = null;
        if (this.COLOR_BLACK != null) {
            this.COLOR_BLACK.dispose();
        }
        if (this.COLOR_DARK_RED != null) {
            this.COLOR_DARK_RED.dispose();
        }
        if (this.COLOR_DARK_GREEN != null) {
            this.COLOR_DARK_GREEN.dispose();
        }
        if (this.COLOR_DARK_YELLOW != null) {
            this.COLOR_DARK_YELLOW.dispose();
        }
        if (this.COLOR_DARK_BLUE != null) {
            this.COLOR_DARK_BLUE.dispose();
        }
        if (this.COLOR_DARK_MAGENTA != null) {
            this.COLOR_DARK_MAGENTA.dispose();
        }
        if (this.COLOR_DARK_CYAN != null) {
            this.COLOR_DARK_CYAN.dispose();
        }
        if (this.COLOR_GRAY != null) {
            this.COLOR_GRAY.dispose();
        }
        if (this.COLOR_DARK_GRAY != null) {
            this.COLOR_DARK_GRAY.dispose();
        }
        if (this.COLOR_RED != null) {
            this.COLOR_RED.dispose();
        }
        if (this.COLOR_GREEN != null) {
            this.COLOR_GREEN.dispose();
        }
        if (this.COLOR_YELLOW != null) {
            this.COLOR_YELLOW.dispose();
        }
        if (this.COLOR_BLUE != null) {
            this.COLOR_BLUE.dispose();
        }
        if (this.COLOR_MAGENTA != null) {
            this.COLOR_MAGENTA.dispose();
        }
        if (this.COLOR_CYAN != null) {
            this.COLOR_CYAN.dispose();
        }
        if (this.COLOR_WHITE != null) {
            this.COLOR_WHITE.dispose();
        }
        this.COLOR_WHITE = null;
        this.COLOR_CYAN = null;
        this.COLOR_MAGENTA = null;
        this.COLOR_BLUE = null;
        this.COLOR_YELLOW = null;
        this.COLOR_GREEN = null;
        this.COLOR_RED = null;
        this.COLOR_DARK_GRAY = null;
        this.COLOR_GRAY = null;
        this.COLOR_DARK_CYAN = null;
        this.COLOR_DARK_MAGENTA = null;
        this.COLOR_DARK_BLUE = null;
        this.COLOR_DARK_YELLOW = null;
        this.COLOR_DARK_GREEN = null;
        this.COLOR_DARK_RED = null;
        this.COLOR_BLACK = null;
        if (this.emptyTab != 0) {
            OS.pango_tab_array_free(this.emptyTab);
        }
        this.emptyTab = 0;
        if (this.xDisplay != 0) {
            n = 0;
            while (n < this.handler_ids.length) {
                if (this.handler_ids[n] != 0) {
                    byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[n], true);
                    OS.g_log_remove_handler(byArray, this.handler_ids[n]);
                    this.handler_ids[n] = 0;
                }
                ++n;
            }
            this.logCallback.dispose();
            this.logCallback = null;
            this.handler_ids = null;
            this.log_domains = null;
            this.logProc = 0;
        }
    }

    public void setWarnings(boolean bl) {
        block9: {
            block8: {
                this.checkDevice();
                if (!bl) break block8;
                if (--this.warningLevel != 0) break block9;
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0) {
                    int n = 0;
                    while (n < this.handler_ids.length) {
                        if (this.handler_ids[n] != 0) {
                            byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[n], true);
                            OS.g_log_remove_handler(byArray, this.handler_ids[n]);
                            this.handler_ids[n] = 0;
                        }
                        ++n;
                    }
                }
                break block9;
            }
            if (this.warningLevel++ == 0) {
                if (this.debug) {
                    return;
                }
                if (this.logProc != 0) {
                    int n = -1;
                    int n2 = 0;
                    while (n2 < this.log_domains.length) {
                        byte[] byArray = Converter.wcsToMbcs(null, this.log_domains[n2], true);
                        this.handler_ids[n2] = OS.g_log_set_handler(byArray, n, this.logProc, 0);
                        ++n2;
                    }
                }
            }
        }
    }

    static int XErrorProc(int n, int n2) {
        Device device = Device.findDevice(n);
        if (device != null) {
            if (device.warningLevel == 0) {
                boolean bl;
                if (DEBUG || device.debug) {
                    new SWTError().printStackTrace();
                }
                boolean bl2 = bl = OS.IsAIX && OS.PTR_SIZEOF == 8;
                if (!bl) {
                    OS.Call(XErrorProc, n, n2);
                }
            }
        } else {
            if (DEBUG) {
                new SWTError().printStackTrace();
            }
            OS.Call(XErrorProc, n, n2);
        }
        return 0;
    }

    static int XIOErrorProc(int n) {
        Device device = Device.findDevice(n);
        if (device != null) {
            if (DEBUG || device.debug) {
                new SWTError().printStackTrace();
            }
        } else if (DEBUG) {
            new SWTError().printStackTrace();
        }
        OS.Call(XIOErrorProc, n, 0);
        return 0;
    }
}

