/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import java.util.Iterator;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.filters.Res;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class FilterConfigurationsTableModel {
    static final int ID_COLINDEX = 1;
    private Table table;
    private IFilterConfigurationMapper mapper;

    FilterConfigurationsTableModel() {
    }

    void linkTable(Table newTable) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.name"));
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.id"));
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.mimeType"));
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.custom"));
    }

    void setMapper(IFilterConfigurationMapper mapper) {
        this.mapper = mapper;
    }

    void updateTable(int selection, String selectedConfigId) {
        this.table.removeAll();
        if (this.mapper == null) {
            return;
        }
        Iterator iter = this.mapper.getAllConfigurations();
        int i = 0;
        while (iter.hasNext()) {
            FilterConfiguration config = (FilterConfiguration)iter.next();
            if (selectedConfigId != null && selectedConfigId.equals(config.configId)) {
                selection = i;
            }
            ++i;
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, config.name);
            item.setText(1, config.configId);
            item.setText(2, config.mimeType);
            item.setText(3, config.custom ? Res.getString("FilterConfigurationsTableModel.customFlag") : Res.getString("FilterConfigurationsTableModel.predefinedFlag"));
        }
        if (selection < 0 || selection > this.table.getItemCount() - 1) {
            selection = this.table.getItemCount() - 1;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selection);
        }
    }
}

