/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Set;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.INameable;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.TargetPropertiesAnnotation;

public class BaseNameable
implements INameable {
    protected String id;
    protected ISkeleton skeleton;
    protected String name;
    protected String type;
    protected String mimeType;
    protected boolean isTranslatable = true;
    protected boolean preserveWS = false;
    protected LinkedHashMap<String, Property> properties;
    protected Annotations annotations;
    protected LinkedHashMap<String, Property> sourceProperties;

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public ISkeleton getSkeleton() {
        return this.skeleton;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        this.skeleton = skeleton;
        if (skeleton != null) {
            skeleton.setParent(this);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        this.name = value;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String value) {
        this.type = value;
    }

    @Override
    public String getMimeType() {
        return this.mimeType;
    }

    @Override
    public void setMimeType(String value) {
        this.mimeType = value;
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public Property getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(name);
    }

    @Override
    public Property setProperty(Property property) {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        this.properties.put(property.getName(), property);
        return property;
    }

    @Override
    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    @Override
    public Set<String> getPropertyNames() {
        if (this.properties == null) {
            this.properties = new LinkedHashMap();
        }
        return this.properties.keySet();
    }

    @Override
    public boolean hasProperty(String name) {
        if (this.properties == null) {
            return false;
        }
        return this.properties.containsKey(name);
    }

    @Override
    public Property getSourceProperty(String name) {
        if (this.sourceProperties == null) {
            return null;
        }
        return this.sourceProperties.get(name);
    }

    @Override
    public Property setSourceProperty(Property property) {
        if (this.sourceProperties == null) {
            this.sourceProperties = new LinkedHashMap();
        }
        this.sourceProperties.put(property.getName(), property);
        return property;
    }

    @Override
    public void removeSourceProperty(String name) {
        if (this.sourceProperties != null) {
            this.sourceProperties.remove(name);
        }
    }

    @Override
    public Set<String> getSourcePropertyNames() {
        if (this.sourceProperties == null) {
            this.sourceProperties = new LinkedHashMap();
        }
        return this.sourceProperties.keySet();
    }

    @Override
    public boolean hasSourceProperty(String name) {
        if (this.sourceProperties == null) {
            return false;
        }
        return this.sourceProperties.containsKey(name);
    }

    @Override
    public Property getTargetProperty(LocaleId locId, String name) {
        if (this.annotations == null) {
            return null;
        }
        TargetPropertiesAnnotation tpa = this.annotations.get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            return null;
        }
        LinkedHashMap<String, Property> trgProps = tpa.get(locId);
        if (trgProps == null) {
            return null;
        }
        return (Property)trgProps.get(name);
    }

    @Override
    public Property setTargetProperty(LocaleId locId, Property property) {
        LinkedHashMap<String, Property> trgProps;
        TargetPropertiesAnnotation tpa;
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        if ((tpa = this.annotations.get(TargetPropertiesAnnotation.class)) == null) {
            tpa = new TargetPropertiesAnnotation();
            this.annotations.set(tpa);
        }
        if ((trgProps = tpa.get(locId)) == null) {
            tpa.set(locId, new LinkedHashMap<String, Property>());
            trgProps = tpa.get(locId);
        }
        trgProps.put(property.getName(), property);
        return property;
    }

    @Override
    public Set<String> getTargetPropertyNames(LocaleId locId) {
        LinkedHashMap<String, Property> trgProps;
        TargetPropertiesAnnotation tpa;
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        if ((tpa = this.annotations.get(TargetPropertiesAnnotation.class)) == null) {
            tpa = new TargetPropertiesAnnotation();
            this.annotations.set(tpa);
        }
        if ((trgProps = tpa.get(locId)) == null) {
            tpa.set(locId, new LinkedHashMap<String, Property>());
            trgProps = tpa.get(locId);
        }
        return trgProps.keySet();
    }

    @Override
    public void removeTargetProperty(LocaleId locId, String name) {
        TargetPropertiesAnnotation tpa;
        if (this.annotations != null && (tpa = this.annotations.get(TargetPropertiesAnnotation.class)) != null) {
            LinkedHashMap<String, Property> trgProps = tpa.get(locId);
            trgProps.remove(name);
        }
    }

    @Override
    public boolean hasTargetProperty(LocaleId locId, String name) {
        if (this.annotations == null) {
            return false;
        }
        TargetPropertiesAnnotation tpa = this.annotations.get(TargetPropertiesAnnotation.class);
        if (tpa == null) {
            return false;
        }
        LinkedHashMap<String, Property> trgProps = tpa.get(locId);
        if (trgProps == null) {
            return false;
        }
        return trgProps.get(name) != null;
    }

    @Override
    public Set<LocaleId> getTargetLocales() {
        TargetPropertiesAnnotation tpa;
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        if ((tpa = this.annotations.get(TargetPropertiesAnnotation.class)) == null) {
            tpa = new TargetPropertiesAnnotation();
            this.annotations.set(tpa);
        }
        return tpa.getLocales();
    }

    @Override
    public Property createTargetProperty(LocaleId locId, String name, boolean overwriteExisting, int creationOptions) {
        Property trgProp;
        LinkedHashMap<String, Property> trgProps;
        TargetPropertiesAnnotation tpa;
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        if ((tpa = this.annotations.get(TargetPropertiesAnnotation.class)) == null) {
            tpa = new TargetPropertiesAnnotation();
            this.annotations.set(tpa);
        }
        if ((trgProps = tpa.get(locId)) == null) {
            tpa.set(locId, new LinkedHashMap<String, Property>());
            trgProps = tpa.get(locId);
        }
        if ((trgProp = (Property)trgProps.get(name)) == null || overwriteExisting) {
            Property srcProp;
            trgProp = creationOptions > 0 ? new Property(name, "", false) : ((srcProp = this.getProperty(name)) == null ? new Property(name, "", false) : srcProp.clone());
            trgProps.put(name, trgProp);
        }
        return trgProp;
    }

    @Override
    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    @Override
    public void setIsTranslatable(boolean value) {
        this.isTranslatable = value;
    }

    @Override
    public boolean preserveWhitespaces() {
        return this.preserveWS;
    }

    @Override
    public void setPreserveWhitespaces(boolean value) {
        this.preserveWS = value;
    }

    @Override
    public Iterable<IAnnotation> getAnnotations() {
        if (this.annotations == null) {
            return Collections.emptyList();
        }
        return this.annotations;
    }
}

