/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.uidescription;

import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.okapi.common.ParameterDescriptor;
import net.sf.okapi.common.uidescription.AbstractPart;
import net.sf.okapi.common.uidescription.CheckListPart;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.CodeFinderPart;
import net.sf.okapi.common.uidescription.FolderInputPart;
import net.sf.okapi.common.uidescription.ListSelectionPart;
import net.sf.okapi.common.uidescription.PathInputPart;
import net.sf.okapi.common.uidescription.SeparatorPart;
import net.sf.okapi.common.uidescription.SpinInputPart;
import net.sf.okapi.common.uidescription.TextInputPart;
import net.sf.okapi.common.uidescription.TextLabelPart;

public class EditorDescription {
    private String caption;
    private LinkedHashMap<String, AbstractPart> descriptors = new LinkedHashMap();
    private boolean defaultLabelFlushed = false;
    private boolean defaultVertical = false;

    public EditorDescription() {
    }

    public EditorDescription(String caption) {
        this.setCaption(caption);
    }

    public EditorDescription(String caption, boolean defaultVertical, boolean defaultLabelFlushed) {
        this.setCaption(caption);
        this.defaultVertical = defaultVertical;
        this.defaultLabelFlushed = defaultLabelFlushed;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public Map<String, AbstractPart> getDescriptors() {
        return this.descriptors;
    }

    public AbstractPart getDescriptor(String name) {
        return this.descriptors.get(name);
    }

    public TextInputPart addTextInputPart(ParameterDescriptor paramDescriptor) {
        TextInputPart desc = new TextInputPart(paramDescriptor);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public CheckboxPart addCheckboxPart(ParameterDescriptor paramDescriptor) {
        CheckboxPart desc = new CheckboxPart(paramDescriptor);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public CheckListPart addCheckListPart(String label, int heightHint) {
        CheckListPart clp = new CheckListPart(label, heightHint);
        clp.setVertical(this.defaultVertical);
        clp.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(clp.getName(), clp);
        return clp;
    }

    public ListSelectionPart addListSelectionPart(ParameterDescriptor paramDescriptor, String[] choices) {
        ListSelectionPart desc = new ListSelectionPart(paramDescriptor, choices);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public PathInputPart addPathInputPart(ParameterDescriptor paramDescriptor, String browseTitle, boolean forSaveAs) {
        PathInputPart desc = new PathInputPart(paramDescriptor, browseTitle, forSaveAs);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public FolderInputPart addFolderInputPart(ParameterDescriptor paramDescriptor, String browseTitle) {
        FolderInputPart desc = new FolderInputPart(paramDescriptor, browseTitle);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public CodeFinderPart addCodeFinderPart(ParameterDescriptor paramDescriptor) {
        CodeFinderPart desc = new CodeFinderPart(paramDescriptor);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public SpinInputPart addSpinInputPart(ParameterDescriptor paramDescriptor) {
        SpinInputPart desc = new SpinInputPart(paramDescriptor);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public SeparatorPart addSeparatorPart() {
        SeparatorPart desc = new SeparatorPart();
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }

    public TextLabelPart addTextLabelPart(String text) {
        TextLabelPart desc = new TextLabelPart(text);
        desc.setVertical(this.defaultVertical);
        desc.setLabelFlushed(this.defaultLabelFlushed);
        this.descriptors.put(desc.getName(), desc);
        return desc;
    }
}

