/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.idml;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IdGenerator;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.exceptions.OkapiBadFilterInputException;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.CodeSimplifier;
import net.sf.okapi.common.resource.Ending;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.common.resource.StartGroup;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnit;
import net.sf.okapi.common.skeleton.ISkeletonWriter;
import net.sf.okapi.filters.idml.IDMLContext;
import net.sf.okapi.filters.idml.IDMLFilterWriter;
import net.sf.okapi.filters.idml.IDMLSkeleton;
import net.sf.okapi.filters.idml.NodeReference;
import net.sf.okapi.filters.idml.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.xml.sax.SAXException;

@UsingParameters(value=Parameters.class)
public class IDMLFilter
implements IFilter {
    private static final String MIMETYPE = "application/vnd.adobe.indesign-idml-package";
    private static final String DOCID = "sd";
    private static final String ENDID = "end";
    private static final String SPREADTYPE = "spread";
    private static final String STORYTYPE = "story";
    private static final String EMBEDDEDSTORIES = "embedded-stories";
    private static final CodeSimplifier SIMPLIFIER = new CodeSimplifier();
    private final DocumentBuilder docBuilder;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private URI docURI;
    private LinkedList<Event> queue;
    private LocaleId srcLoc;
    private Parameters params;
    private EncoderManager encoderManager;
    private HashMap<String, ZipEntry> stories;
    private LinkedHashMap<String, ArrayList<String>> spreads;
    private ArrayList<String> hiddenLayers;
    private ArrayList<String> storiesDone;
    private Iterator<String> storyIter;
    private Iterator<String> spreadIter;
    private ZipFile zipFile;
    private IdGenerator spreadIdGen;
    private IdGenerator storyIdGen;
    private int spreadStack;
    private String tuIdPrefix;
    private Stack<IDMLContext> ctx;
    private HashMap<String, Boolean> embeddedElements;
    private HashMap<String, Integer> embeddedElementsPos;
    private IdGenerator refGen;
    private IdGenerator tuIdGen;
    private int deconstructing;

    public IDMLFilter() {
        try {
            this.params = new Parameters();
            DocumentBuilderFactory docFact = DocumentBuilderFactory.newInstance();
            docFact.setValidating(false);
            this.docBuilder = docFact.newDocumentBuilder();
            this.embeddedElements = new HashMap();
            this.embeddedElements.put("Table", true);
            this.embeddedElements.put("Footnote", true);
            this.embeddedElements.put("Note", true);
            this.embeddedElementsPos = new HashMap();
            for (String name : this.embeddedElements.keySet()) {
                this.embeddedElementsPos.put(name, -1);
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error initializing.\n" + e.getMessage(), e);
        }
    }

    @Override
    public void cancel() {
    }

    @Override
    public void close() {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.zipFile = null;
        }
    }

    @Override
    public ISkeletonWriter createSkeletonWriter() {
        return null;
    }

    @Override
    public IFilterWriter createFilterWriter() {
        return new IDMLFilterWriter();
    }

    @Override
    public EncoderManager getEncoderManager() {
        if (this.encoderManager == null) {
            this.encoderManager = new EncoderManager();
            this.encoderManager.setMapping("text/xml", "net.sf.okapi.common.encoder.XMLEncoder");
        }
        return this.encoderManager;
    }

    @Override
    public String getName() {
        return "okf_idml";
    }

    @Override
    public String getDisplayName() {
        return "IDML Filter";
    }

    @Override
    public String getMimeType() {
        return MIMETYPE;
    }

    @Override
    public List<FilterConfiguration> getConfigurations() {
        ArrayList<FilterConfiguration> list = new ArrayList<FilterConfiguration>();
        list.add(new FilterConfiguration(this.getName(), MIMETYPE, this.getClass().getName(), "IDML", "Adobe InDesign IDML documents", null, ".idml;"));
        return list;
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public boolean hasNext() {
        return this.queue != null;
    }

    @Override
    public Event next() {
        if (this.queue == null) {
            return null;
        }
        if (this.queue.size() > 0) {
            return this.queue.poll();
        }
        this.read();
        if (this.queue.size() == 0) {
            this.queue = null;
            Ending ending = new Ending("ed");
            return new Event(EventType.END_DOCUMENT, ending);
        }
        return this.queue.poll();
    }

    @Override
    public void open(RawDocument input) {
        this.open(input, true);
    }

    @Override
    public void open(RawDocument input, boolean generateSkeleton) {
        this.queue = null;
        this.close();
        this.docURI = input.getInputURI();
        if (this.docURI == null) {
            throw new OkapiBadFilterInputException("This filter supports only URI input.");
        }
        this.srcLoc = input.getSourceLocale();
        this.spreadIdGen = new IdGenerator(null, "spr");
        this.storyIdGen = new IdGenerator(null, "sto");
        this.embeddedElements.put("Note", this.params.getExtractNotes());
        this.embeddedElementsPos.put("Note", -1);
        this.gatherStories();
        StartDocument sd = new StartDocument(DOCID);
        sd.setEncoding("UTF-8", false);
        sd.setName(this.docURI.getPath());
        sd.setLocale(this.srcLoc);
        sd.setMimeType(MIMETYPE);
        sd.setLineBreak("\n");
        sd.setFilterParameters(this.params);
        sd.setFilterWriter(this.createFilterWriter());
        sd.setSkeleton(new IDMLSkeleton(this.zipFile));
        this.queue = new LinkedList();
        this.queue.add(new Event(EventType.START_DOCUMENT, sd));
        if (this.spreads.size() > 0) {
            this.spreadIter = this.spreads.keySet().iterator();
            if (this.spreadIter.hasNext()) {
                String spreadName = this.spreadIter.next();
                this.storyIter = this.spreads.get(spreadName).iterator();
                StartGroup sg = new StartGroup(DOCID, this.spreadIdGen.createId());
                this.queue.add(new Event(EventType.START_GROUP, sg));
                sg.setName(spreadName);
                if (spreadName.equals(EMBEDDEDSTORIES)) {
                    sg.setId(EMBEDDEDSTORIES);
                } else {
                    sg.setType(SPREADTYPE);
                }
                ++this.spreadStack;
            }
        }
    }

    @Override
    public void setFilterConfigurationMapper(IFilterConfigurationMapper fcMapper) {
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    private void read() {
        if (this.spreadIter == null) {
            return;
        }
        while (true) {
            if (this.storyIter.hasNext()) {
                this.processStory(this.storyIter.next());
                return;
            }
            if (this.spreadStack > 0) {
                Ending ending = new Ending(this.spreadIdGen.getLastId() + ENDID);
                this.queue.add(new Event(EventType.END_GROUP, ending));
                --this.spreadStack;
            }
            if (!this.spreadIter.hasNext()) break;
            String spreadName = this.spreadIter.next();
            this.storyIter = this.spreads.get(spreadName).iterator();
            StartGroup sg = new StartGroup(DOCID, this.spreadIdGen.createId());
            sg.setName(spreadName);
            if (spreadName.equals(EMBEDDEDSTORIES)) {
                sg.setId(EMBEDDEDSTORIES);
            } else {
                sg.setType(SPREADTYPE);
            }
            this.queue.add(new Event(EventType.START_GROUP, sg));
            ++this.spreadStack;
        }
    }

    private void gatherStories() {
        this.spreadIter = null;
        this.storyIter = null;
        this.spreads = new LinkedHashMap();
        this.storiesDone = new ArrayList();
        this.stories = new HashMap();
        this.hiddenLayers = new ArrayList();
        try {
            ZipEntry designMapEntry;
            this.zipFile = new ZipFile(new File(this.docURI));
            if (!this.params.getExtractHiddenLayers() && (designMapEntry = this.zipFile.getEntry("designmap.xml")) != null) {
                this.gatherHiddenLayers(designMapEntry);
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!entry.getName().endsWith(".xml")) continue;
                if (entry.getName().startsWith("Spreads/") || entry.getName().startsWith("MasterSpreads/") && this.params.getExtractMasterSpreads()) {
                    this.gatherStoriesInSpread(entry);
                    continue;
                }
                if (!entry.getName().startsWith("Stories/")) continue;
                this.gatherStoriesInStory(entry);
                String storyId = Util.getFilename(entry.getName(), false);
                int p = storyId.indexOf(95);
                if (p > -1) {
                    storyId = storyId.substring(p + 1);
                }
                this.stories.put(storyId, entry);
            }
        }
        catch (Throwable e) {
            throw new OkapiIOException("Error while gathering stories.\n" + e.getMessage(), e);
        }
    }

    private void gatherHiddenLayers(ZipEntry entry) throws SAXException, IOException, ParserConfigurationException {
        Document doc = this.docBuilder.parse(this.zipFile.getInputStream(entry));
        NodeList list = doc.getElementsByTagName("Layer");
        for (int i = 0; i < list.getLength(); ++i) {
            Element elem = (Element)list.item(i);
            String tmp = elem.getAttribute("Visible");
            if (!tmp.equals("false")) continue;
            this.hiddenLayers.add(elem.getAttribute("Self"));
        }
    }

    private int gatherStoriesInSpread(ZipEntry entry) throws SAXException, IOException, ParserConfigurationException {
        Element tf;
        int i;
        if (entry.getSize() > (long)(this.params.getSkipThreshold() * 1024)) {
            if (this.params.getStopWhenOverThreshold()) {
                throw new RuntimeException(String.format("The spread '%s' is %d Kb large and it's larger than the current threshold (%d Kb).", entry.getName(), entry.getSize() / 1024L, this.params.getSkipThreshold()));
            }
            this.logger.warn("The spread '{}' is {} Kb large, larger than the current threshold ({} Kb). It will be skipped.", entry.getName(), entry.getSize() / 1024L, this.params.getSkipThreshold());
            return 0;
        }
        ArrayList<String> storyList = new ArrayList<String>();
        Document doc = this.docBuilder.parse(this.zipFile.getInputStream(entry));
        String name = entry.getName();
        NodeList list = doc.getElementsByTagName("TextFrame");
        for (i = 0; i < list.getLength(); ++i) {
            tf = (Element)list.item(i);
            String parentStory = tf.getAttribute("ParentStory");
            if (Util.isEmpty(parentStory)) {
                throw new IOException("Missing value for parentStory.");
            }
            String itemLayer = tf.getAttribute("ItemLayer");
            if (!Util.isEmpty(itemLayer) && this.hiddenLayers.contains(itemLayer) || this.storiesDone.contains(parentStory)) continue;
            storyList.add(parentStory);
            this.storiesDone.add(parentStory);
        }
        list = doc.getElementsByTagName("TextPath");
        for (i = 0; i < list.getLength(); ++i) {
            tf = (Element)list.item(i);
            String tmp = tf.getAttribute("ParentStory");
            if (Util.isEmpty(tmp)) {
                throw new IOException("Missing value for parentStory.");
            }
            if (this.storiesDone.contains(tmp)) continue;
            storyList.add(tmp);
            this.storiesDone.add(tmp);
        }
        this.spreads.put(name, storyList);
        return storyList.size();
    }

    private void gatherStoriesInStory(ZipEntry entry) throws SAXException, IOException, ParserConfigurationException {
        ArrayList<String> storyList = new ArrayList<String>();
        Document doc = this.docBuilder.parse(this.zipFile.getInputStream(entry));
        NodeList list = doc.getElementsByTagName("TextFrame");
        for (int i = 0; i < list.getLength(); ++i) {
            Element tf = (Element)list.item(i);
            String parentStory = tf.getAttribute("ParentStory");
            if (Util.isEmpty(parentStory)) {
                throw new IOException("Missing value for parentStory.");
            }
            String itemLayer = tf.getAttribute("ItemLayer");
            if (!Util.isEmpty(itemLayer) && this.hiddenLayers.contains(itemLayer) || this.storiesDone.contains(parentStory)) continue;
            storyList.add(parentStory);
            this.storiesDone.add(parentStory);
        }
        if (!storyList.isEmpty()) {
            ArrayList<String> existingList = this.spreads.get(EMBEDDEDSTORIES);
            if (existingList == null) {
                this.spreads.put(EMBEDDEDSTORIES, storyList);
            } else {
                existingList.addAll(storyList);
                this.spreads.put(EMBEDDEDSTORIES, existingList);
            }
        }
    }

    private void processStory(String storyId) {
        ZipEntry entry = this.stories.get(storyId);
        if (entry == null) {
            throw new OkapiIOException("No story entry found for " + storyId);
        }
        try {
            Document doc = this.docBuilder.parse(this.zipFile.getInputStream(entry));
            StartGroup sg = new StartGroup(this.spreadIdGen.getLastId(), this.storyIdGen.createId());
            sg.setName(storyId);
            sg.setType(STORYTYPE);
            sg.setSkeleton(new IDMLSkeleton(entry, doc));
            this.queue.add(new Event(EventType.START_GROUP, sg));
            this.tuIdPrefix = storyId + "-";
            this.ctx = new Stack();
            this.refGen = new IdGenerator(null);
            this.tuIdGen = new IdGenerator(null);
            Element topNode = doc.getDocumentElement();
            this.ctx.push(new IDMLContext(false, topNode));
            this.deconstructing = 0;
            for (String name : this.embeddedElementsPos.keySet()) {
                this.embeddedElementsPos.put(name, -1);
            }
            this.processNodes(topNode);
            Ending ending = new Ending(this.storyIdGen.getLastId() + ENDID);
            this.queue.add(new Event(EventType.END_GROUP, ending));
        }
        catch (Throwable e) {
            throw new OkapiIOException(String.format("Error processing story file '%s'.\n" + e.getMessage(), storyId), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processNodes(Node node) {
        while (true) {
            String name;
            Element elem;
            block28: {
                if (node == null) {
                    return;
                }
                if (node.getNodeType() != 1) {
                    if (this.ctx.peek().inScope()) {
                        switch (node.getNodeType()) {
                            case 3: 
                            case 4: {
                                this.ctx.peek().addCode(node);
                                break;
                            }
                            default: {
                                throw new OkapiIOException("Unexpected node type: " + node.getNodeType());
                            }
                        }
                    }
                    node = node.getNextSibling();
                    continue;
                }
                elem = (Element)node;
                name = elem.getNodeName();
                if (name.equals("Content")) {
                    this.ctx.peek().addContent(elem);
                    node = elem.getNextSibling();
                    continue;
                }
                if (name.equals("ParagraphStyleRange")) {
                    if (this.doStartPSR(elem)) {
                        node = elem.getNextSibling();
                        continue;
                    }
                } else {
                    if (this.embeddedElements.containsKey(name)) {
                        this.embeddedElementsPos.put(name, this.embeddedElementsPos.get(name) + 1);
                        if (this.ctx.peek().inScope()) {
                            String key;
                            if (this.embeddedElements.get(name).booleanValue()) {
                                key = this.refGen.createId();
                                this.ctx.peek().addCode(new Code(TextFragment.TagType.PLACEHOLDER, name, String.format("<%s id=\"%s\"/>", "SKLREF", key)));
                                this.ctx.peek().addReference(key, this.makeNodeReference(node));
                                this.ctx.push(new IDMLContext(true, node));
                                break block28;
                            } else {
                                key = this.refGen.createId();
                                this.ctx.peek().addCode(new Code(TextFragment.TagType.PLACEHOLDER, name, String.format("<%s id=\"%s\"/>", "SKLREF", key)));
                                this.ctx.peek().addReference(key, this.makeNodeReference(node));
                                node = elem.getNextSibling();
                                continue;
                            }
                        }
                        node = elem.getNextSibling();
                        continue;
                    }
                    if (name.equalsIgnoreCase("Br") && this.params.getNewTuOnBr()) {
                        if (this.ctx.peek().inScope()) {
                            if (this.deconstructing == 0) {
                                ++this.deconstructing;
                            }
                            this.ctx.peek().addStartTag(elem);
                            Node tmpNode = this.ctx.peek().getScopeNode();
                            this.triggerTextUnit();
                            this.ctx.peek().enterScope(tmpNode, this.makeTuId());
                            node = elem.getNextSibling();
                            continue;
                        }
                    } else if (this.ctx.peek().inScope()) {
                        this.ctx.peek().addStartTag(elem);
                    }
                }
            }
            if (elem.hasChildNodes()) {
                this.processNodes(elem.getFirstChild());
            }
            if (name.equals("ParagraphStyleRange")) {
                this.triggerTextUnit();
                if (this.deconstructing > 0) {
                    --this.deconstructing;
                }
            } else if (this.embeddedElements.containsKey(name)) {
                if (this.ctx.peek().inScope()) {
                    // empty if block
                }
                this.ctx.pop();
            } else if (this.ctx.peek().inScope()) {
                this.ctx.peek().addEndTag(elem);
            }
            node = elem.getNextSibling();
        }
    }

    private void triggerTextUnit() {
        if (this.ctx.peek().addToQueue(this.queue, this.deconstructing > 0) && this.params.getSimplifyCodes()) {
            ITextUnit tu = this.queue.getLast().getTextUnit();
            TextFragment tf = tu.getSource().getFirstContent();
            String[] res = SIMPLIFIER.simplifyAll(tf, true);
            IDMLSkeleton skel = (IDMLSkeleton)tu.getSkeleton();
            if (res != null) {
                if (tu.getSource().isEmpty() && this.deconstructing == 0) {
                    this.queue.removeLast();
                } else {
                    skel.addMovedParts(res);
                }
            }
            skel.setForced(this.deconstructing > 0);
        }
        this.ctx.peek().leaveScope();
    }

    private NodeReference makeNodeReference(Node targetNode) {
        String name = targetNode.getNodeName();
        return new NodeReference(name, this.embeddedElementsPos.get(name));
    }

    private String makeTuId() {
        return this.tuIdPrefix + this.tuIdGen.createId();
    }

    private boolean doStartPSR(Node node) {
        NodeList list = ((Element)node).getElementsByTagName("Content");
        if (list.getLength() > 1) {
            this.ctx.peek().enterScope(node, this.makeTuId());
            if (this.deconstructing > 0) {
                ++this.deconstructing;
            }
            return false;
        }
        if (list.getLength() == 1) {
            Element cnt = (Element)list.item(0);
            TextUnit tu = new TextUnit(this.makeTuId());
            tu.setSourceContent(IDMLFilter.processContent(cnt, null));
            if (this.deconstructing > 0) {
                ++this.deconstructing;
            }
            IDMLSkeleton skl = new IDMLSkeleton(this.ctx.peek().getTopNode(), cnt);
            skl.setForced(this.deconstructing > 0);
            tu.setSkeleton(skl);
            this.queue.add(new Event(EventType.TEXT_UNIT, tu));
        }
        return true;
    }

    static TextFragment processContent(Element content, TextFragment tf) {
        if (tf == null) {
            tf = new TextFragment();
        }
        block4: for (Node node = content.getFirstChild(); node != null; node = node.getNextSibling()) {
            switch (node.getNodeType()) {
                case 3: {
                    IDMLFilter.processText(tf, node.getNodeValue());
                    continue block4;
                }
                case 7: {
                    ProcessingInstruction pi = (ProcessingInstruction)node;
                    tf.append(TextFragment.TagType.PLACEHOLDER, "pi", String.format("<?%s %s?>", pi.getTarget(), pi.getTextContent()));
                    continue block4;
                }
                default: {
                    throw new OkapiIOException("Unexpected content in <Content>: " + node.getNodeType());
                }
            }
        }
        return tf;
    }

    static void processText(TextFragment dest, String text) {
        block15: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '\u2028': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "lb", String.valueOf(ch));
                    continue block15;
                }
                case '\u200b': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "lb-disc", String.valueOf(ch));
                    continue block15;
                }
                case '\u2011': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "nb-hyph", String.valueOf(ch));
                    continue block15;
                }
                case '\u202f': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "nbsp-fw", String.valueOf(ch));
                    continue block15;
                }
                case '\u200a': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-hair", String.valueOf(ch));
                    continue block15;
                }
                case '\u2006': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-6th", String.valueOf(ch));
                    continue block15;
                }
                case '\u2005': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-4th", String.valueOf(ch));
                    continue block15;
                }
                case '\u2004': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-3rd", String.valueOf(ch));
                    continue block15;
                }
                case '\u2008': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-punc", String.valueOf(ch));
                    continue block15;
                }
                case '\u2009': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-thin", String.valueOf(ch));
                    continue block15;
                }
                case '\u2007': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-fig", String.valueOf(ch));
                    continue block15;
                }
                case '\u2001': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "sp-flush", String.valueOf(ch));
                    continue block15;
                }
                case '\ufeff': {
                    dest.append(TextFragment.TagType.PLACEHOLDER, "tx-anch", String.valueOf(ch));
                    continue block15;
                }
                default: {
                    dest.append(ch);
                }
            }
        }
    }
}

