/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.extra.pipelinebuilder;

import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.MimeTypeMapper;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.pipelinedriver.DocumentData;
import net.sf.okapi.common.resource.RawDocument;

public class XDocument {
    private DocumentData documentData;
    private FilterConfigurationMapper fcMapper = new FilterConfigurationMapper();

    public XDocument(URI inputURI, String defaultEncoding, String filterConfigId, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this(new RawDocument(inputURI, defaultEncoding, sourceLocale, targetLocale), outputURI, outputEncoding);
        this.getRawDocument().setFilterConfigId(filterConfigId);
    }

    public XDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale, String filterConfigId) {
        this(new RawDocument(inputURI, defaultEncoding, sourceLocale, targetLocale));
        this.getRawDocument().setFilterConfigId(filterConfigId);
    }

    public XDocument(RawDocument rawDocument) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(rawDocument);
    }

    public XDocument(DocumentData documentData) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setDocumentData(documentData);
    }

    public XDocument(RawDocument rawDoc, URI outputURI, String outputEncoding) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(rawDoc);
        this.documentData.outputURI = outputURI;
        this.documentData.outputEncoding = outputEncoding;
    }

    public XDocument(CharSequence inputCharSequence, LocaleId sourceLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(inputCharSequence, sourceLocale));
    }

    public XDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(inputURI, defaultEncoding, sourceLocale));
    }

    public XDocument(URI inputURI, String defaultEncoding, URI outputURI, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this(inputURI, defaultEncoding, null, outputURI, outputEncoding, sourceLocale, targetLocale);
    }

    public XDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(inputURI, defaultEncoding, sourceLocale, targetLocale));
    }

    public XDocument(URL inputURL, String defaultEncoding, LocaleId sourceLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(Util.URLtoURI(inputURL), defaultEncoding, sourceLocale));
    }

    public XDocument(URL inputURL, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(Util.URLtoURI(inputURL), defaultEncoding, sourceLocale, targetLocale));
    }

    public XDocument(URL inputURL, String defaultEncoding, URL outputURL, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(Util.URLtoURI(inputURL), defaultEncoding, sourceLocale, targetLocale));
        this.documentData.outputURI = outputURL == null ? null : Util.URLtoURI(outputURL);
        this.documentData.outputEncoding = outputEncoding;
    }

    public XDocument(URL inputURL, String defaultEncoding, String outputPath, String outputEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(Util.URLtoURI(inputURL), defaultEncoding, sourceLocale, targetLocale));
        this.documentData.outputURI = new File(outputPath).toURI();
        this.documentData.outputEncoding = outputEncoding;
    }

    public XDocument(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(inputStream, defaultEncoding, sourceLocale));
    }

    public XDocument(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
        this.setRawDocument(new RawDocument(inputStream, defaultEncoding, sourceLocale, targetLocale));
    }

    protected XDocument() {
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xml.XMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.html.HtmlFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openoffice.OpenOfficeFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.openxml.OpenXMLContentFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.properties.PropertiesFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.plaintext.PlainTextFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.table.TableFilter");
        this.fcMapper.addConfigurations("net.sf.okapi.filters.xliff.XLIFFFilter");
    }

    public DocumentData getDocumentData() {
        return this.documentData;
    }

    public void setDocumentData(DocumentData documentData) {
        this.documentData = documentData;
        this.validateFilterConfigId();
    }

    public RawDocument getRawDocument() {
        return this.documentData != null ? this.documentData.rawDocument : null;
    }

    public void setRawDocument(RawDocument rawDocument) {
        if (this.documentData == null) {
            this.documentData = new DocumentData();
        }
        this.documentData.rawDocument = rawDocument;
        this.validateFilterConfigId();
    }

    private void validateFilterConfigId() {
        RawDocument rd = this.getRawDocument();
        if (rd == null) {
            return;
        }
        if (!Util.isEmpty(rd.getFilterConfigId())) {
            return;
        }
        if (rd.getInputURI() == null) {
            return;
        }
        String ext = Util.getExtension(rd.getInputURI().toString());
        if (Util.isEmpty(ext)) {
            return;
        }
        String mimeType = MimeTypeMapper.getMimeType(ext = ext.substring(1));
        FilterConfiguration cfg = this.fcMapper.getDefaultConfiguration(mimeType);
        if (cfg == null) {
            return;
        }
        rd.setFilterConfigId(cfg.configId);
    }
}

