/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.rtf;

import net.sf.okapi.common.Event;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.rtf.RTFLayerWriter;

public class RTFPackageWriter
extends BasePackageWriter {
    private RTFLayerWriter layerWriter;
    private String rawDocPath;
    private String encoding;

    public RTFPackageWriter() {
        super("rtf");
    }

    @Override
    protected void processStartBatch() {
        this.manifest.setSubDirectories("original", "work", "work", "done", null, true);
        this.setTMXInfo(true, null, false, false, false);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        MergingInfo item = this.manifest.getItem(this.docId);
        this.rawDocPath = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".rtf";
        this.encoding = item.getTargetEncoding();
        this.layerWriter = new RTFLayerWriter(this.skelWriter, this.rawDocPath, this.manifest.getTargetLocale(), this.encoding);
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected Event processEndDocument(Event event) {
        this.layerWriter.writeEvent(event);
        this.close();
        if (this.params.getSendOutput()) {
            return super.creatRawDocumentEventSet(this.rawDocPath, this.encoding, this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        }
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        this.layerWriter.writeEvent(event);
        this.writeTMXEntries(event.getTextUnit());
    }

    @Override
    protected void processStartGroup(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    protected void processDocumentPart(Event event) {
        this.layerWriter.writeEvent(event);
    }

    @Override
    public void close() {
        if (this.layerWriter != null) {
            this.layerWriter.close();
            this.layerWriter = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

