/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.textmodification;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.pipeline.annotations.StepParameterMapping;
import net.sf.okapi.common.pipeline.annotations.StepParameterType;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.textmodification.Parameters;

@UsingParameters(value=Parameters.class)
public class TextModificationStep
extends BasePipelineStep {
    private static final char STARTSEG = '[';
    private static final char ENDSEG = ']';
    private static final int SCRIPT_MAX = 3;
    private Parameters params;
    private LocaleId targetLocale;
    private String[] oldChars = new String[3];
    private String[] newChars = new String[3];

    public TextModificationStep() {
        this.params = new Parameters();
        this.oldChars = new String[4];
        this.newChars = new String[4];
        this.oldChars[0] = "AaEeIiOoUuYyCcDdNn";
        this.newChars[0] = "\u00c2\u00e5\u00c9\u00e8\u00cf\u00ec\u00d8\u00f5\u00db\u00fc\u00dd\u00ff\u00c7\u00e7\u00d0\u00f0\u00d1\u00f1";
        this.oldChars[1] = "AaEeIiOoUuYyBbVvPpKkSsNnDdFfGgHhJjLlMmQqRrTtWwZzCcXx";
        this.newChars[1] = "\u0410\u0430\u0415\u0435\u0418\u0438\u041e\u043e\u0423\u0443\u042e\u044e\u0411\u0431\u0412\u0432\u041f\u043f\u041a\u043a\u0421\u0441\u041d\u043d\u0414\u0434\u0424\u0444\u0413\u0433\u0425\u0445\u0419\u0439\u041b\u043b\u041c\u043c\u0428\u0448\u0420\u0440\u0422\u0442\u042f\u044f\u0417\u0437\u0426\u0446\u0429\u0449";
        this.oldChars[2] = "AaBbTtGgHhDdRrMmNnLlQqKkSsVvWwXxYyZzCcFfJjPpEeIiOoUu0123456789%?;,";
        this.newChars[2] = "\u0627\u0627\u0628\u0628\u062a\u062a\u062c\u062c\u062d\u062d\u062f\u062f\u0631\u0631\u0645\u0645\u0646\u0646\u0644\u0644\u0642\u0642\u0643\u0643\u0633\u0633\u062e\u062e\u0648\u0648\u0632\u0632\u064a\u064a\u0638\u0638\u0635\u0635\u0641\u0641\u063a\u063a\u0630\u0630\u0647\u0647\u0639\u0639\u0636\u0636\u0634\u0634\u0660\u0661\u0662\u0663\u0664\u0665\u0666\u0667\u0668\u0669\u066a\u061f\u061b\u060c";
        this.oldChars[3] = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";
        this.newChars[3] = "\u35f2\u35f2\u3737\u3737\u3dff\u3dff\u4039\u4039\u4150\u4150\u42d4\u42d4\u6e26\u6e26\u6e88\u6e88\u6eb3\u6eb3\u6f38\u6f38\u6f70\u6f70\u6fae\u6fae\u6ff0\u6ff0\u7121\u7121\u7189\u7189\u71d2\u71d2\u721b\u721b\u7258\u7258\u7372\u7372\u73fc\u73fc\u74da\u74da\u7587\u7587\u760d\u760d\u93c7\u93c7\u93f7\u93f7\u9f7e\u9f7e";
    }

    @StepParameterMapping(parameterType=StepParameterType.TARGET_LOCALE)
    public void setTargetLocale(LocaleId targetLocale) {
        this.targetLocale = targetLocale;
    }

    @Override
    public String getName() {
        return "Text Modification";
    }

    @Override
    public String getDescription() {
        return "Apply various modifications to the text units content of a document. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        if (!tu.isTranslatable()) {
            return event;
        }
        if (!this.params.getApplyToExistingTarget() && tu.hasTarget(this.targetLocale)) {
            return event;
        }
        if (!this.params.getApplyToBlankEntries()) {
            TextContainer tc = tu.getTarget(this.targetLocale);
            if (tc == null) {
                tc = tu.getSource();
            }
            if (!tc.hasText()) {
                return event;
            }
        }
        tu.createTarget(this.targetLocale, false, 7);
        if (tu.getTarget(this.targetLocale).isEmpty()) {
            tu.createTarget(this.targetLocale, true, 7);
        }
        switch (this.params.getType()) {
            case 1: {
                this.replaceWithXN(tu);
                break;
            }
            case 3: {
                this.replaceWithExtendedChars(tu);
                break;
            }
            case 2: {
                this.removeText(tu);
            }
        }
        if (this.params.getExpand()) {
            this.expand(tu);
        }
        if (this.params.getMarkSegments()) {
            this.addSegmentMarks(tu);
        }
        if (this.params.getAddPrefix() || this.params.getAddSuffix() || this.params.getAddName() || this.params.getAddID()) {
            this.addText(tu);
        }
        return event;
    }

    private void removeText(ITextUnit tu) {
        for (TextPart part : tu.getTarget(this.targetLocale)) {
            StringBuilder sb = new StringBuilder();
            String text = part.text.getCodedText();
            for (int i = 0; i < text.length(); ++i) {
                if (!TextFragment.isMarker(text.charAt(i))) continue;
                sb.append(text.charAt(i));
                sb.append(text.charAt(++i));
            }
            part.text.setCodedText(sb.toString());
        }
    }

    private void replaceWithXN(ITextUnit tu) {
        String tmp = null;
        for (TextPart part : tu.getTarget(this.targetLocale)) {
            tmp = part.text.getCodedText().replaceAll("\\p{Lu}|\\p{Lo}", "X");
            tmp = tmp.replaceAll("\\p{Ll}", "x");
            tmp = tmp.replaceAll("\\d", "N");
            part.text.setCodedText(tmp);
        }
    }

    private void replaceWithExtendedChars(ITextUnit tu) {
        int charDest = this.params.getScript();
        if (charDest > 3) {
            charDest = 0;
        }
        for (TextPart part : tu.getTarget(this.targetLocale)) {
            StringBuilder sb = new StringBuilder(part.text.getCodedText());
            for (int i = 0; i < sb.length(); ++i) {
                if (TextFragment.isMarker(sb.charAt(i))) {
                    ++i;
                    continue;
                }
                int n = this.oldChars[charDest].indexOf(sb.charAt(i));
                if (n <= -1) continue;
                sb.setCharAt(i, this.newChars[charDest].charAt(n));
            }
            part.text.setCodedText(sb.toString());
        }
    }

    private void addSegmentMarks(ITextUnit tu) {
        for (Segment seg : tu.getTarget(this.targetLocale).getSegments()) {
            seg.text.setCodedText('[' + seg.text.getCodedText() + ']');
        }
    }

    private void addText(ITextUnit tu) {
        if (this.params.getAddPrefix()) {
            TextFragment firstFrag = tu.getTarget(this.targetLocale).getFirstContent();
            firstFrag.setCodedText(this.params.getPrefix() + firstFrag.getCodedText());
        }
        TextFragment lastFrag = tu.getTarget(this.targetLocale).getLastContent();
        if (this.params.getAddName()) {
            String name = tu.getName();
            if (!Util.isEmpty(name)) {
                lastFrag.setCodedText(lastFrag.getCodedText() + "_" + name);
            } else {
                lastFrag.setCodedText(lastFrag.getCodedText() + "_" + tu.getId());
            }
        }
        if (this.params.getAddID()) {
            lastFrag.setCodedText(lastFrag.getCodedText() + "_" + tu.getId());
        }
        if (this.params.getAddSuffix()) {
            lastFrag.setCodedText(lastFrag.getCodedText() + this.params.getSuffix());
        }
    }

    private void expand(ITextUnit tu) {
        int length;
        int addition = length = this.getLength(tu.getSource());
        if (length <= 20) {
            addition = (addition + 1) / 2;
        }
        StringBuilder extra = new StringBuilder();
        for (int i = 0; i < addition; ++i) {
            if (i % 6 == 0 && i != addition - 1) {
                extra.append(' ');
                continue;
            }
            extra.append('z');
        }
        TextFragment frag = tu.getTarget(this.targetLocale).getLastContent();
        frag.append(extra);
    }

    private int getLength(TextContainer tc) {
        TextFragment tf = tc.contentIsOneSegment() ? tc.getFirstContent() : tc.getUnSegmentedContentCopy();
        return TextUnitUtil.getText(tf).length();
    }
}

