/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.annotation;

import java.util.Collection;
import java.util.HashMap;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.annotation.XLIFFPhase;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.StartSubDocument;

public class XLIFFPhaseAnnotation
implements IAnnotation {
    private HashMap<String, XLIFFPhase> phases = new HashMap();

    public void add(XLIFFPhase phase) {
        this.phases.put(phase.getPhaseName(), phase);
    }

    public void add(XLIFFPhase phase, StartSubDocument startSubDoc) {
        this.phases.put(phase.getPhaseName(), phase);
        this.updatePhaseAnnotation(startSubDoc);
    }

    public XLIFFPhase get(String phaseName) {
        return this.phases.get(phaseName);
    }

    public XLIFFPhase getReferencedPhase() {
        Collection<XLIFFPhase> refPhases = this.phases.values();
        if (refPhases.size() == 1) {
            return refPhases.iterator().next();
        }
        return null;
    }

    public void updatePhaseAnnotation(StartSubDocument startSubDoc) {
        Property phasePlaceholder = startSubDoc.getProperty("phase") == null ? new Property("phase", "") : startSubDoc.getProperty("phase");
        phasePlaceholder.setValue(this.toXML());
    }

    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<phase-group>");
        for (XLIFFPhase phase : this.phases.values()) {
            sb.append(phase.toXML());
        }
        sb.append("</phase-group>");
        return sb.toString();
    }
}

