/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.sf.okapi.common.ReversedIterator;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.exceptions.OkapiException;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextPart;
import net.sf.okapi.common.resource.TextUnitUtil;

public class CodeSimplifier {
    protected static final int MAX = 10;
    private LinkedList<CodeNode> codeNodesList;
    private String codedText;

    private void prepare(String pCodedText, List<Code> pCodes) {
        this.codeNodesList = new LinkedList();
        this.codedText = pCodedText;
        Stack<StartCodeNode> codeNodesStack = new Stack<StartCodeNode>();
        for (int i = 0; i < this.codedText.length(); ++i) {
            CodeNode cn;
            int c = this.codedText.codePointAt(i);
            if (c == 57601) {
                cn = new StartCodeNode(i, TextFragment.toIndex(this.codedText.charAt(i + 1)), this.codedText.charAt(i + 1), pCodes.get(TextFragment.toIndex(this.codedText.charAt(i + 1))));
                this.codeNodesList.add(cn);
                codeNodesStack.push((StartCodeNode)cn);
                continue;
            }
            if (c == 57602) {
                cn = new EndCodeNode(i, TextFragment.toIndex(this.codedText.charAt(i + 1)), this.codedText.charAt(i + 1), pCodes.get(TextFragment.toIndex(this.codedText.charAt(i + 1))));
                this.codeNodesList.add(cn);
                ((StartCodeNode)codeNodesStack.pop()).endNode = cn;
                continue;
            }
            if (c != 57603) continue;
            cn = new PhCodeNode(i, TextFragment.toIndex(this.codedText.charAt(i + 1)), this.codedText.charAt(i + 1), pCodes.get(TextFragment.toIndex(this.codedText.charAt(i + 1))));
            this.codeNodesList.add(cn);
        }
        this.updateAdjacentFlags();
    }

    private void updateAdjacentFlags() {
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode peekCn;
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size() || !this.adjacentMarkers(cn, peekCn = this.codeNodesList.get(i + 1))) continue;
            cn.adjacentNext = true;
            peekCn.adjacentPrev = true;
        }
    }

    public String[] simplifyAll(TextFragment tf, int maxIterations, boolean removeLeadingTrailingCodes) {
        int isolatedMerges = 0;
        int openCloseMerges = 0;
        int emptyOpenCloseMerges = 0;
        int iteration = 0;
        try {
            do {
                ++iteration;
                this.prepare(tf.getCodedText(), tf.getCodes());
                isolatedMerges = this.simplifyIsolated();
                tf.setCodedText(this.getCodedText(), this.getCodes());
                this.prepare(tf.getCodedText(), tf.getCodes());
                openCloseMerges = this.simplifyOpeningClosing();
                tf.setCodedText(this.getCodedText(), this.getCodes());
                this.prepare(tf.getCodedText(), tf.getCodes());
                emptyOpenCloseMerges = this.simplifyEmptyOpeningClosing();
                tf.setCodedText(this.getCodedText(), this.getCodes());
            } while (iteration < maxIterations && isolatedMerges + openCloseMerges + emptyOpenCloseMerges > 0);
            tf.renumberCodes();
            if (removeLeadingTrailingCodes) {
                return this.removeLeadingTrailingCodes(tf, maxIterations);
            }
            return null;
        }
        catch (Throwable e) {
            throw new OkapiException("Error simplifiying codes.\n" + e.getMessage(), e);
        }
    }

    public String[] simplifyAll(TextContainer tc, boolean removeLeadingTrailingCodes) {
        TextFragment tf = TextUnitUtil.storeSegmentation(tc);
        String[] res = this.simplifyAll(tf, removeLeadingTrailingCodes);
        if (removeLeadingTrailingCodes && res != null) {
            boolean hasTrailing;
            boolean hasLeading = !Util.isEmpty(res[0]);
            boolean bl = hasTrailing = !Util.isEmpty(res[1]);
            if (hasLeading) {
                TextFragment leadingMarkers = new TextFragment();
                res[0] = TextUnitUtil.extractSegMarkers(leadingMarkers, res[0], true);
                tf.insert(0, leadingMarkers, true);
            }
            if (hasTrailing) {
                TextFragment trailingMarkers = new TextFragment();
                res[1] = TextUnitUtil.extractSegMarkers(trailingMarkers, res[1], true);
                tf.insert(-1, trailingMarkers, true);
            }
            if (Util.isEmpty(res[0]) && Util.isEmpty(res[1])) {
                res = null;
            }
        }
        TextUnitUtil.restoreSegmentation(tc, tf);
        if (removeLeadingTrailingCodes) {
            int firstSegIndex = -1;
            int lastSegIndex = -1;
            int index = -1;
            for (TextPart part : tc) {
                ++index;
                if (!part.isSegment()) continue;
                if (firstSegIndex == -1) {
                    firstSegIndex = index;
                }
                lastSegIndex = index;
            }
            if (firstSegIndex > 0 || lastSegIndex < tc.count() - 1) {
                int i;
                LinkedList<Integer> removedIndexes = new LinkedList<Integer>();
                if (res == null) {
                    res = new String[2];
                }
                StringBuilder sb = new StringBuilder();
                for (i = 0; i < firstSegIndex; ++i) {
                    sb.append(tc.get(i).getContent().toText());
                    removedIndexes.add(i);
                }
                if (Util.isEmpty(res[0])) {
                    res[0] = sb.toString();
                }
                sb = new StringBuilder();
                for (i = lastSegIndex + 1; i < tc.count(); ++i) {
                    sb.append(tc.get(i).getContent().toText());
                    removedIndexes.add(i);
                }
                if (Util.isEmpty(res[1])) {
                    res[1] = sb.toString();
                }
                for (Integer removedIndex : new ReversedIterator(removedIndexes)) {
                    tc.remove(removedIndex);
                }
            }
        }
        TextUnitUtil.renumberCodes(tc);
        TextUnitUtil.convertTextParts_whitespaceCodesToText(tc);
        return res;
    }

    private String[] removeLeadingTrailingCodes(TextFragment tf, int maxIterations) {
        boolean removed;
        Code code = null;
        StringBuilder leadingSb = new StringBuilder();
        StringBuilder trailingSb = new StringBuilder();
        int iteration = 0;
        do {
            int codeIndex;
            int codeIndex2;
            int i;
            ++iteration;
            removed = false;
            String ctext = tf.getCodedText();
            List<Code> codes = tf.getCodes();
            int startPos = 0;
            int endPos = 0;
            StringBuilder sb = new StringBuilder();
            for (i = 0; i < ctext.length(); ++i) {
                if (TextFragment.isMarker(ctext.charAt(i))) {
                    codeIndex2 = TextFragment.toIndex(ctext.charAt(i + 1));
                    code = codes.get(codeIndex2);
                    if (ctext.codePointAt(i) != 57603) break;
                    sb.append(code.getOuterData());
                    endPos = i + 2;
                    ++i;
                    continue;
                }
                if (!Character.isWhitespace(ctext.charAt(i)) || endPos <= 0 && iteration <= 1) break;
                sb.append(ctext.charAt(i));
                endPos = i + 1;
            }
            if (startPos < endPos) {
                tf.remove(startPos, endPos);
                leadingSb.append((CharSequence)sb);
                removed = true;
            }
            ctext = tf.getCodedText();
            codes = tf.getCodes();
            endPos = startPos = ctext.length();
            sb = new StringBuilder();
            for (i = ctext.length() - 1; i > 0; --i) {
                if (TextFragment.isMarker(ctext.charAt(i - 1))) {
                    codeIndex2 = TextFragment.toIndex(ctext.charAt(i));
                    code = codes.get(codeIndex2);
                    if (ctext.codePointAt(i - 1) != 57603) break;
                    sb.insert(0, code.getOuterData());
                    startPos = --i;
                    continue;
                }
                if (!Character.isWhitespace(ctext.charAt(i)) || startPos >= ctext.length() - 1 && iteration <= 1) break;
                sb.insert(0, ctext.charAt(i));
                startPos = i;
            }
            if (startPos < endPos) {
                tf.remove(startPos, endPos);
                trailingSb.insert(0, sb);
                removed = true;
            }
            Code leadingCode = null;
            Code trailingCode = null;
            ctext = tf.getCodedText();
            codes = tf.getCodes();
            if (ctext.length() <= 1 || Util.isEmpty(codes)) continue;
            ctext = tf.getCodedText();
            codes = tf.getCodes();
            if (TextFragment.isMarker(ctext.charAt(0))) {
                codeIndex = TextFragment.toIndex(ctext.charAt(1));
                code = codes.get(codeIndex);
                if (ctext.codePointAt(0) == 57601) {
                    leadingCode = code;
                }
            }
            ctext = tf.getCodedText();
            codes = tf.getCodes();
            if (TextFragment.isMarker(ctext.charAt(ctext.length() - 2))) {
                codeIndex = TextFragment.toIndex(ctext.charAt(ctext.length() - 1));
                code = codes.get(codeIndex);
                if (ctext.codePointAt(ctext.length() - 2) == 57602) {
                    trailingCode = code;
                }
            }
            if (leadingCode == null || trailingCode == null || leadingCode.getId() != trailingCode.getId()) continue;
            tf.remove(0, 2);
            leadingSb.append(leadingCode.getOuterData());
            ctext = tf.getCodedText();
            codes = tf.getCodes();
            tf.remove(ctext.length() - 2, ctext.length());
            trailingSb.insert(0, trailingCode.getOuterData());
            removed = true;
        } while (removed && iteration < maxIterations);
        String res0 = leadingSb.toString();
        String res1 = trailingSb.toString();
        String[] res = new String[]{Util.isEmpty(res0) ? "" : res0, Util.isEmpty(res1) ? "" : res1};
        return Util.isEmpty(res0) && Util.isEmpty(res1) ? null : res;
    }

    public String[] simplifyAll(TextFragment tf, boolean removeLeadingTrailingCodes) {
        return this.simplifyAll(tf, 10, removeLeadingTrailingCodes);
    }

    public void simplifyIsolated(TextFragment tf) {
        this.prepare(tf.getCodedText(), tf.getCodes());
        this.simplifyIsolated();
        tf.setCodedText(this.getCodedText(), this.getCodes());
    }

    private int simplifyIsolated() {
        int merges = 0;
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size()) continue;
            CodeNode peekCn = this.codeNodesList.get(i + 1);
            if (!cn.adjacentNext || !peekCn.adjacentPrev || !(cn instanceof PhCodeNode) && !(peekCn instanceof PhCodeNode) || !this.canJoin(cn.code, peekCn.code)) continue;
            this.mergeNodes(cn, peekCn);
            ++merges;
            --i;
        }
        this.renumberMarkerIndexes();
        this.updateCodeIds();
        return merges;
    }

    private boolean canJoin(Code code1, Code code2) {
        boolean ss2 = TextUnitUtil.hasSegStartMarker(code2);
        boolean se1 = TextUnitUtil.hasSegEndMarker(code1);
        boolean dontJoin = se1 && ss2;
        return !dontJoin;
    }

    public void simplifyOpeningClosing(TextFragment tf) {
        this.prepare(tf.getCodedText(), tf.getCodes());
        this.simplifyOpeningClosing();
        tf.setCodedText(this.getCodedText(), this.getCodes());
    }

    private int simplifyOpeningClosing() {
        int merges = 0;
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size()) continue;
            CodeNode peekCn = this.codeNodesList.get(i + 1);
            if (!cn.adjacentNext || !peekCn.adjacentPrev || cn.code.getTagType() != TextFragment.TagType.OPENING || peekCn.code.getTagType() != TextFragment.TagType.OPENING || !(cn instanceof StartCodeNode) || !(peekCn instanceof StartCodeNode)) continue;
            StartCodeNode scn1 = (StartCodeNode)cn;
            StartCodeNode scn2 = (StartCodeNode)peekCn;
            EndCodeNode ecn2 = scn2.endNode;
            EndCodeNode ecn1 = scn1.endNode;
            if (!this.adjacentMarkers(ecn2, ecn1)) continue;
            this.mergeEndNodes(ecn2, ecn1);
            this.mergeNodes(scn1, scn2);
            ++merges;
            --i;
        }
        this.renumberMarkerIndexes();
        this.updateCodeIds();
        return merges;
    }

    public void simplifyEmptyOpeningClosing(TextFragment tf) {
        this.prepare(tf.getCodedText(), tf.getCodes());
        this.simplifyEmptyOpeningClosing();
        tf.setCodedText(this.getCodedText(), this.getCodes());
    }

    private int simplifyEmptyOpeningClosing() {
        int merges = 0;
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (i + 1 >= this.codeNodesList.size()) continue;
            CodeNode peekCn = this.codeNodesList.get(i + 1);
            if (!cn.adjacentNext || !peekCn.adjacentPrev || cn.code.getTagType() != TextFragment.TagType.OPENING || peekCn.code.getTagType() != TextFragment.TagType.CLOSING || cn.intIndex != peekCn.intIndex - 1 || !(cn instanceof StartCodeNode) || !(peekCn instanceof EndCodeNode)) continue;
            StartCodeNode scn = (StartCodeNode)cn;
            EndCodeNode ecn = (EndCodeNode)peekCn;
            this.mergeEmptyNodes(scn, ecn);
            ++merges;
            --i;
        }
        this.renumberMarkerIndexes();
        this.updateCodeIds();
        return merges;
    }

    private void renumberMarkerIndexes() {
        int i = 0;
        while (i < this.codeNodesList.size()) {
            CodeNode cn = this.codeNodesList.get(i);
            char newCharIndex = TextFragment.toChar(i);
            String newMarker = new String(cn.markerFlag + newCharIndex);
            this.codedTextReplace(cn.marker, newMarker);
            cn.intIndex = i++;
            cn.charIndex = newCharIndex;
            cn.marker = newMarker;
        }
    }

    private List<Code> getCodes() {
        ArrayList<Code> codes = new ArrayList<Code>();
        for (CodeNode cn : this.codeNodesList) {
            codes.add(cn.code);
        }
        return codes;
    }

    private String getCodedText() {
        return this.codedText;
    }

    private void updateCodeIds() {
        for (int i = 0; i < this.codeNodesList.size(); ++i) {
            CodeNode cn = this.codeNodesList.get(i);
            if (cn.code.getTagType() == TextFragment.TagType.OPENING) {
                if (cn instanceof StartCodeNode) {
                    StartCodeNode scn = (StartCodeNode)cn;
                    scn.code.setId(i + 1);
                    scn.endNode.code.setId(i + 1);
                    continue;
                }
                cn.code.setId(i + 1);
                continue;
            }
            if (cn.code.getTagType() != TextFragment.TagType.PLACEHOLDER) continue;
            cn.code.setId(i + 1);
        }
    }

    private boolean adjacentMarkers(CodeNode node1, CodeNode node2) {
        return node1.offset + 2 == node2.offset;
    }

    private void mergeNodes(CodeNode node1, CodeNode node2) {
        String cst = node1.marker + node2.marker;
        if (node1 instanceof PhCodeNode && (node2 instanceof StartCodeNode || node2 instanceof EndCodeNode)) {
            this.codedTextReplace(cst, node2.marker);
            node2.setMergedData(node1, node2);
            this.codeNodesList.remove(node1);
        } else if (node2 instanceof PhCodeNode && (node1 instanceof StartCodeNode || node1 instanceof EndCodeNode)) {
            this.codedTextReplace(cst, node1.marker);
            node1.setMergedData(node1, node2);
            this.codeNodesList.remove(node2);
        } else {
            this.codedTextReplace(cst, node1.marker);
            node1.setMergedData(node1, node2);
            this.codeNodesList.remove(node2);
        }
    }

    private void updateOffsets(int start, int delta) {
        for (CodeNode node : this.codeNodesList) {
            if (node.offset <= start) continue;
            node.offset += delta;
        }
    }

    private void mergeEndNodes(CodeNode node1, CodeNode node2) {
        String cst = node1.marker + node2.marker;
        this.codedTextReplace(cst, node2.marker);
        node2.setMergedData(node1, node2);
        node2.offset = node1.offset;
        this.codeNodesList.remove(node1);
    }

    private void mergeEmptyNodes(CodeNode node1, CodeNode node2) {
        String cst = node1.marker + node2.marker;
        this.codedTextReplace(cst, new String("\ue103" + node1.charIndex));
        node1.setMergedData(node1, node2);
        node1.code.setTagType(TextFragment.TagType.PLACEHOLDER);
        PhCodeNode pcn = new PhCodeNode(node1.offset, node1.intIndex, node1.charIndex, node1.code);
        int i = this.codeNodesList.indexOf(node2);
        this.codeNodesList.add(i, pcn);
        this.codeNodesList.remove(node1);
        this.codeNodesList.remove(node2);
    }

    private void codedTextReplace(String findWhat, String replaceWith) {
        int startLen = this.codedText.length();
        int startIndex = this.codedText.indexOf(findWhat);
        this.codedText = this.codedText.replace(findWhat, replaceWith);
        int endLen = this.codedText.length();
        int delta = endLen - startLen;
        if (delta != 0) {
            this.updateOffsets(startIndex, delta);
        }
    }

    class PhCodeNode
    extends CodeNode {
        PhCodeNode(int offset, int intIndex, char charIndex, Code code) {
            super(offset, intIndex, charIndex, code);
            this.marker = new String("\ue103" + charIndex);
            this.markerFlag = new String("\ue103");
        }
    }

    class EndCodeNode
    extends CodeNode {
        StartCodeNode beginNode;

        EndCodeNode(int offset, int intIndex, char charIndex, Code code) {
            super(offset, intIndex, charIndex, code);
            this.marker = new String("\ue102" + charIndex);
            this.markerFlag = new String("\ue102");
        }
    }

    class StartCodeNode
    extends CodeNode {
        EndCodeNode endNode;

        StartCodeNode(int offset, int intIndex, char charIndex, Code code) {
            super(offset, intIndex, charIndex, code);
            this.marker = new String("\ue101" + charIndex);
            this.markerFlag = new String("\ue101");
        }
    }

    class CodeNode {
        int offset;
        int intIndex;
        char charIndex;
        Code code;
        String marker;
        String markerFlag;
        boolean adjacentPrev = false;
        boolean adjacentNext = false;

        public CodeNode(int offset, int intIndex, char charIndex, Code code) {
            this.offset = offset;
            this.intIndex = intIndex;
            this.charIndex = charIndex;
            this.code = code;
        }

        public void setMergedData(CodeNode node1, CodeNode node2) {
            String data1 = node1.code.getData();
            String data2 = node2.code.getData();
            String odata1 = node1.code.getOuterData();
            String odata2 = node2.code.getOuterData();
            if (!Util.isEmpty(data1) && !Util.isEmpty(data2)) {
                this.code.setData(data1 + data2);
            } else {
                this.code.setOuterData(odata1 + odata2);
            }
        }
    }
}

