/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.IResource;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.annotation.Annotations;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.exceptions.OkapiIOException;
import net.sf.okapi.common.exceptions.OkapiNotImplementedException;
import net.sf.okapi.common.exceptions.OkapiUnsupportedEncodingException;
import net.sf.okapi.common.io.FileCachedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawDocument
implements Closeable,
IResource {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String UNKOWN_ENCODING = "null";
    private Annotations annotations;
    private String filterConfigId;
    private String id;
    private String encoding = "null";
    private LocaleId srcLoc;
    private List<LocaleId> trgLocs;
    private FileCachedInputStream createdStream;
    private URI inputURI;
    private CharSequence inputCharSequence;
    private Reader reader;
    private URI outputURI;
    private File workFile;

    public RawDocument(CharSequence inputCharSequence, LocaleId sourceLocale) {
        this.create(inputCharSequence, sourceLocale, null);
    }

    public RawDocument(CharSequence inputCharSequence, LocaleId sourceLocale, LocaleId targetLocale) {
        this.create(inputCharSequence, sourceLocale, targetLocale);
    }

    public RawDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale) {
        this.create(inputURI, defaultEncoding, sourceLocale, null);
    }

    public RawDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        this.create(inputURI, defaultEncoding, sourceLocale, targetLocale);
    }

    public RawDocument(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale) {
        try {
            this.create(inputStream, defaultEncoding, sourceLocale, null);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating or reseting Stream in RawDocument", e);
        }
    }

    public RawDocument(URI inputURI, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale, String filterConfigId) {
        this.create(inputURI, defaultEncoding, sourceLocale, targetLocale);
        this.setFilterConfigId(filterConfigId);
    }

    public RawDocument(InputStream inputStream, String defaultEncoding, LocaleId sourceLocale, LocaleId targetLocale) {
        try {
            this.create(inputStream, defaultEncoding, sourceLocale, targetLocale);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating or reseting Stream in RawDocument", e);
        }
    }

    private void create(CharSequence inputCharSequence, LocaleId srcLoc, LocaleId trgLoc) {
        if (inputCharSequence == null) {
            throw new IllegalArgumentException("inputCharSequence cannot be null");
        }
        this.inputCharSequence = inputCharSequence;
        this.encoding = "UTF-16";
        this.srcLoc = srcLoc;
        this.trgLocs = new ArrayList<LocaleId>(1);
        if (trgLoc != null) {
            this.trgLocs.add(trgLoc);
        }
    }

    private void create(URI inputURI, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc) {
        if (inputURI == null) {
            throw new IllegalArgumentException("inputURI cannot be null");
        }
        this.inputURI = inputURI;
        this.encoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLocs = new ArrayList<LocaleId>(1);
        if (trgLoc != null) {
            this.trgLocs.add(trgLoc);
        }
    }

    private void create(InputStream inputStream, String defaultEncoding, LocaleId srcLoc, LocaleId trgLoc) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("inputStream cannot be null");
        }
        this.createdStream = this.createResettableStream(inputStream);
        this.encoding = defaultEncoding;
        this.srcLoc = srcLoc;
        this.trgLocs = new ArrayList<LocaleId>(1);
        if (trgLoc != null) {
            this.trgLocs.add(trgLoc);
        }
    }

    public Reader getReader() {
        if (this.getEncoding() == UNKOWN_ENCODING) {
            throw new OkapiUnsupportedEncodingException("Encoding has not been set");
        }
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            this.reader = new InputStreamReader((InputStream)this.createStream(), this.getEncoding());
        }
        catch (UnsupportedEncodingException e) {
            throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.getEncoding()), e);
        }
        catch (IOException e) {
            throw new OkapiIOException("Error closing Reader in RawDocument", e);
        }
        return this.reader;
    }

    private FileCachedInputStream createStream() throws IOException {
        if (this.createdStream != null) {
            try {
                if (!this.createdStream.isOpen()) {
                    this.createdStream.reopen();
                }
                this.createdStream.reset();
                return this.createdStream;
            }
            catch (IOException e) {
                try {
                    this.createdStream.dispose();
                    this.createdStream = null;
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        }
        if (this.getInputCharSequence() != null) {
            try {
                byte[] bytes = this.inputCharSequence.toString().getBytes(this.getEncoding());
                this.createdStream = StreamUtil.createResettableStream(new ByteArrayInputStream(bytes), bytes.length + 1);
            }
            catch (UnsupportedEncodingException e) {
                throw new OkapiUnsupportedEncodingException(String.format("The encoding '%s' is not supported.", this.getEncoding()), e);
            }
        }
        if (this.getInputURI() != null) {
            URL url = null;
            try {
                url = this.getInputURI().toURL();
                this.createdStream = this.createResettableStream(url.openStream());
            }
            catch (IllegalArgumentException e) {
                throw new OkapiIOException("Could not open the URI. The URI must be absolute: " + (url == null ? "URL is null" : url.toString()), e);
            }
            catch (MalformedURLException e) {
                throw new OkapiIOException("Could not open the URI. The URI may be malformed: " + (url == null ? "URL is null" : url.toString()), e);
            }
            catch (IOException e) {
                throw new OkapiIOException("Could not open the URL. The URL is OK but the input stream could not be opened.\n" + e.getMessage(), e);
            }
        }
        return this.createdStream;
    }

    private FileCachedInputStream createResettableStream(InputStream is) throws IOException {
        return StreamUtil.createResettableStream(is, 0x100000);
    }

    public InputStream getStream() {
        try {
            this.createdStream = this.createStream();
        }
        catch (IOException e) {
            throw new OkapiIOException("Error creating or reseting Stream in RawDocument", e);
        }
        return this.createdStream;
    }

    @Override
    public <A extends IAnnotation> A getAnnotation(Class<A> annotationType) {
        if (this.annotations == null) {
            return null;
        }
        return (A)((IAnnotation)annotationType.cast(this.annotations.get(annotationType)));
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public ISkeleton getSkeleton() {
        throw new OkapiNotImplementedException("The RawDocument resource does not have skeketon");
    }

    @Override
    public void setAnnotation(IAnnotation annotation) {
        if (this.annotations == null) {
            this.annotations = new Annotations();
        }
        this.annotations.set(annotation);
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public void setSkeleton(ISkeleton skeleton) {
        throw new OkapiNotImplementedException("RawDcoument has no skeleton");
    }

    public URI getInputURI() {
        return this.inputURI;
    }

    public CharSequence getInputCharSequence() {
        return this.inputCharSequence;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public LocaleId getSourceLocale() {
        return this.srcLoc;
    }

    public void setSourceLocale(LocaleId locId) {
        this.srcLoc = locId;
    }

    public LocaleId getTargetLocale() {
        if (this.trgLocs.isEmpty()) {
            return null;
        }
        return this.trgLocs.get(0);
    }

    public void setTargetLocale(LocaleId locId) {
        this.trgLocs.clear();
        this.trgLocs.add(locId);
    }

    public List<LocaleId> getTargetLocales() {
        return this.trgLocs;
    }

    public void setTargetLocales(List<LocaleId> locIds) {
        this.trgLocs = locIds != null ? locIds : new ArrayList<LocaleId>(1);
    }

    public void setEncoding(String encoding) {
        if (this.inputCharSequence != null) {
            this.LOGGER.debug("Cannot reset an encoding on a CharSequence input in RawDocument");
            return;
        }
        if (this.reader != null) {
            this.LOGGER.warn("Encoding set with an already vreated Reader. Make sure to call getReader to create a new readerwith the new encoding.");
        }
        this.encoding = encoding;
    }

    public void setEncoding(Charset encoding) {
        this.setEncoding(encoding.name());
    }

    public void setFilterConfigId(String filterConfigId) {
        this.filterConfigId = filterConfigId;
    }

    public String getFilterConfigId() {
        return this.filterConfigId;
    }

    @Override
    public void close() {
        if (this.reader != null) {
            try {
                this.reader.close();
                this.reader = null;
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing the reader created by RawDocument.", e);
            }
        }
        if (this.createdStream != null) {
            try {
                this.createdStream.close();
                this.createdStream.dispose();
                this.createdStream = null;
            }
            catch (IOException e) {
                throw new OkapiIOException("Error closing the stream created by RawDocument.", e);
            }
        }
    }

    public Annotations getAnnotations() {
        return this.annotations == null ? new Annotations() : this.annotations;
    }

    public File createOutputFile(URI outputURI) {
        this.outputURI = outputURI;
        if (this.getInputURI() != null) {
            String dir = Util.getDirectoryName(outputURI.getPath());
            if (outputURI.getPath().equals(this.getInputURI().getPath())) {
                try {
                    this.workFile = File.createTempFile("~okapi-11_work_", null, new File(dir));
                }
                catch (IOException e) {
                    throw new OkapiIOException(String.format("Cannot create temporary file in '%s'.", dir));
                }
                return this.workFile;
            }
        }
        this.workFile = new File(outputURI);
        Util.createDirectories(this.workFile.getAbsolutePath());
        return this.workFile;
    }

    public void finalizeOutput() {
        if (this.workFile == null) {
            return;
        }
        if (this.workFile.toURI().equals(this.outputURI)) {
            return;
        }
        File outputFile = new File(this.outputURI);
        if (outputFile.exists() && !outputFile.delete()) {
            throw new OkapiIOException(String.format("Cannot delete original input file '%s'. The output is still in the temporary file '%s'.", outputFile.getAbsolutePath(), this.workFile.getAbsolutePath()));
        }
        if (!this.workFile.renameTo(outputFile)) {
            throw new OkapiIOException(String.format("Cannot rename the temporary output file to '%s'. The output is still under the temporary name '%s'.", outputFile.getAbsolutePath(), this.workFile.getAbsolutePath()));
        }
    }
}

