/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.resource;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.ISegments;
import net.sf.okapi.common.resource.IVariantSources;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.Segment;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.common.resource.TextFragment;

public class VariantSources
implements IVariantSources {
    private static final int SOURCES_INITCAP = 2;
    private ConcurrentHashMap<LocaleId, TextContainer> sources;
    TextContainer defaultSource;
    private int sourceCount;

    public VariantSources(TextContainer sourceContainer) {
        this.createVariantSources(sourceContainer, null);
    }

    public VariantSources(TextContainer sourceContainer, VariantSources original) {
        this.createVariantSources(sourceContainer, original);
    }

    public void setDefaultSource(TextContainer sourceContainer) {
        this.defaultSource = sourceContainer;
    }

    private void createVariantSources(TextContainer sourceContainer, VariantSources original) {
        this.defaultSource = sourceContainer;
        this.sourceCount = 0;
        this.sources = new ConcurrentHashMap();
        if (original != null) {
            this.sources.putAll(original.sources);
            this.sourceCount = original.sourceCount;
        }
    }

    public VariantSources clone() {
        VariantSources cs = new VariantSources(this.defaultSource);
        cs.sources = new ConcurrentHashMap();
        cs.sources.putAll(this.sources);
        return cs;
    }

    @Override
    public boolean isEmpty(LocaleId targetLocale) {
        return this.get(targetLocale).isEmpty();
    }

    @Override
    public TextContainer create(LocaleId targetLocale, boolean overwriteExisting, int creationOptions) {
        TextContainer newSource = this.defaultSource.clone((creationOptions & 2) == 2);
        if ((creationOptions & 4) != 4) {
            newSource.joinAll();
        }
        if ((creationOptions & 1) != 1) {
            for (Segment seg : newSource.getSegments()) {
                seg.text.clear();
            }
        }
        return this.create(this.defaultSource.clone(), targetLocale, overwriteExisting);
    }

    @Override
    public TextContainer create(TextContainer sourceText, LocaleId targetLocale, boolean overwriteExisting) {
        if (targetLocale == null) {
            return null;
        }
        if (this.sources == null) {
            this.sources = new ConcurrentHashMap(2);
        }
        if (!this.sources.containsKey(targetLocale) || overwriteExisting) {
            this.sourceCount += this.sources.put(targetLocale, sourceText) == null ? 1 : 0;
        }
        return this.sources.get(targetLocale);
    }

    @Override
    public TextContainer get(LocaleId targetLocale) {
        TextContainer theSource = null;
        if (this.sourceCount > 0 && targetLocale != null && this.sources.containsKey(targetLocale)) {
            theSource = this.sources.get(targetLocale);
        }
        return theSource != null ? theSource : this.defaultSource;
    }

    @Override
    public TextContainer set(LocaleId targetLocale, TextContainer textContainer) throws IllegalArgumentException {
        if (targetLocale == null) {
            throw new IllegalArgumentException("The target locale must not be null");
        }
        return this.put(targetLocale, textContainer);
    }

    private TextContainer put(LocaleId targetLocale, TextContainer theSource) {
        if (this.sources == null) {
            this.sources = new ConcurrentHashMap(2);
        }
        if (this.sources.put(targetLocale, theSource) == null) {
            ++this.sourceCount;
        }
        return this.sources.get(targetLocale);
    }

    @Override
    public void remove(LocaleId targetLocale) throws IllegalArgumentException {
        if (targetLocale == null) {
            throw new IllegalArgumentException("The target locale must not be null");
        }
        if (this.sources == null) {
            return;
        }
        if (this.sources.remove(targetLocale) != null) {
            --this.sourceCount;
        }
    }

    @Override
    public boolean hasVariant(LocaleId targetLocale) throws IllegalArgumentException {
        if (targetLocale == null) {
            throw new IllegalArgumentException("The target locale must not be null");
        }
        return this.sources == null ? false : this.sources.containsKey(targetLocale);
    }

    @Override
    public int count() {
        return this.sourceCount;
    }

    @Override
    public boolean isEmpty() {
        return this.sourceCount == 0;
    }

    @Override
    public TextFragment setContent(LocaleId targetLocale, TextFragment content) throws IllegalArgumentException {
        TextContainer theSource;
        if (targetLocale == null) {
            throw new IllegalArgumentException("targetLocale should not be null");
        }
        if (this.sources == null) {
            this.sources = new ConcurrentHashMap(2);
        }
        if (this.sources.containsKey(targetLocale)) {
            theSource = this.get(targetLocale);
            theSource.setContent(content);
        } else {
            theSource = this.put(targetLocale, new TextContainer(content));
        }
        return theSource.getSegments().getFirstContent();
    }

    @Override
    public ISegments getSegments(LocaleId targetLocale) {
        return this.get(targetLocale).getSegments();
    }

    @Override
    public Segment getSegment(LocaleId targetLocale, String segId, boolean createIfNeeded) {
        Segment seg = this.getSegments(targetLocale).get(segId);
        if (seg == null && createIfNeeded) {
            seg = new Segment(segId);
            this.get(targetLocale).getSegments().append(seg);
        }
        return seg;
    }

    @Override
    public Set<LocaleId> getLocales() {
        return this.sources == null ? new HashSet() : this.sources.keySet();
    }

    @Override
    public Property getProperty(LocaleId targetLocale, String name) {
        return this.get(targetLocale).getProperty(name);
    }

    @Override
    public Property setProperty(LocaleId targetLocale, Property property) {
        return this.get(targetLocale).setProperty(property);
    }

    @Override
    public void removeProperty(LocaleId targetLocale, String name) {
        this.get(targetLocale).removeProperty(name);
    }

    @Override
    public Set<String> getPropertyNames(LocaleId targetLocale) {
        return this.get(targetLocale).getPropertyNames();
    }

    @Override
    public boolean hasProperty(LocaleId targetLocale, String name) {
        return this.get(targetLocale).hasProperty(name);
    }

    @Override
    public void propagateProperty(LocaleId from, String propertyName, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        this.propagateProperty(from, null, propertyName, overwriteExisting);
        for (LocaleId loc : this.getLocales()) {
            this.propagateProperty(from, loc, propertyName, overwriteExisting);
        }
    }

    @Override
    public void propagateProperty(LocaleId from, LocaleId to, String propertyName, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        if (from == null ? from == to : from.equals(to)) {
            return;
        }
        Property p = this.getProperty(from, propertyName);
        if (p != null && (overwriteExisting || !this.hasProperty(to, propertyName))) {
            this.setProperty(to, p);
        }
    }

    @Override
    public void propagateAllProperties(LocaleId from, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        this.propagateAllProperties(from, null, overwriteExisting);
        for (LocaleId loc : this.getLocales()) {
            this.propagateAllProperties(from, loc, overwriteExisting);
        }
    }

    @Override
    public void propagateAllProperties(LocaleId from, LocaleId to, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        if (from == null ? from == to : from.equals(to)) {
            return;
        }
        for (String propName : this.getPropertyNames(from)) {
            this.propagateProperty(from, to, propName, overwriteExisting);
        }
    }

    @Override
    public <A extends IAnnotation> void propagateAnnotation(LocaleId from, Class<A> type, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        this.propagateAnnotation(from, null, type, overwriteExisting);
        for (LocaleId loc : this.getLocales()) {
            this.propagateAnnotation(from, loc, type, overwriteExisting);
        }
    }

    @Override
    public <A extends IAnnotation> void propagateAnnotation(LocaleId from, LocaleId to, Class<A> type, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        if (from == null ? from == to : from.equals(to)) {
            return;
        }
        A fromA = this.get(from).getAnnotation(type);
        TextContainer toSource = this.get(to);
        if (fromA != null && (overwriteExisting || toSource.getAnnotation(type) == null)) {
            toSource.setAnnotation((IAnnotation)fromA);
        }
    }

    @Override
    public void propagateAllAnnotations(LocaleId from, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        this.propagateAllAnnotations(from, null, overwriteExisting);
        for (LocaleId loc : this.getLocales()) {
            this.propagateAllAnnotations(from, loc, overwriteExisting);
        }
    }

    @Override
    public void propagateAllAnnotations(LocaleId from, LocaleId to, boolean overwriteExisting) {
        if (this.sources == null) {
            return;
        }
        if (from == null ? from == to : from.equals(to)) {
            return;
        }
        for (IAnnotation annot : this.get(from).getAnnotations()) {
            this.propagateAnnotation(from, to, annot.getClass(), overwriteExisting);
        }
    }

    @Override
    public Iterator<TextContainer> iterator() {
        return new Iterator<TextContainer>(){
            private boolean removedParentContainer = false;
            private Iterator<TextContainer> iter = VariantSources.access$000(VariantSources.this).values().iterator();

            @Override
            public boolean hasNext() {
                return this.removedParentContainer ? this.iter.hasNext() : true;
            }

            @Override
            public TextContainer next() {
                return this.removedParentContainer ? this.iter.next() : VariantSources.this.defaultSource;
            }

            @Override
            public void remove() {
                if (!this.removedParentContainer) {
                    this.removedParentContainer = true;
                } else {
                    this.iter.remove();
                }
            }
        };
    }

    public TextContainer getDefaultSource() {
        return this.defaultSource;
    }

    static /* synthetic */ ConcurrentHashMap access$000(VariantSources x0) {
        return x0.sources;
    }
}

