/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.mif;

import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.filters.InlineCodeFinder;

public class Parameters
extends StringParameters {
    private static final String EXTRACTBODYPAGES = "extractBodyPages";
    private static final String EXTRACTREFERENCEPAGES = "extractReferencePages";
    private static final String EXTRACTMASTERPAGES = "extractMasterPages";
    private static final String EXTRACTHIDDENPAGES = "extractHiddenPages";
    private static final String USECODEFINDER = "useCodeFinder";
    private static final String CODEFINDERRULES = "codeFinderRules";
    private static final String EXTRACTVARIABLES = "extractVariables";
    private static final String EXTRACTINDEXMARKERS = "extractIndexMarkers";
    private static final String EXTRACTLINKS = "extractLinks";
    private InlineCodeFinder codeFinder;

    public boolean getUseCodeFinder() {
        return this.getBoolean(USECODEFINDER);
    }

    public void setUseCodeFinder(boolean useCodeFinder) {
        this.setBoolean(USECODEFINDER, useCodeFinder);
    }

    public InlineCodeFinder getCodeFinder() {
        return this.codeFinder;
    }

    public String getCodeFinderData() {
        return this.codeFinder.toString();
    }

    public void setCodeFinderData(String data) {
        this.codeFinder.fromString(data);
    }

    public boolean getExtractReferencePages() {
        return this.getBoolean(EXTRACTREFERENCEPAGES);
    }

    public void setExtractReferencePages(boolean extractReferencePages) {
        this.setBoolean(EXTRACTREFERENCEPAGES, extractReferencePages);
    }

    public boolean getExtractMasterPages() {
        return this.getBoolean(EXTRACTMASTERPAGES);
    }

    public void setExtractMasterPages(boolean extractMasterPages) {
        this.setBoolean(EXTRACTMASTERPAGES, extractMasterPages);
    }

    public boolean getExtractHiddenPages() {
        return this.getBoolean(EXTRACTHIDDENPAGES);
    }

    public void setExtractHiddenPages(boolean extractHiddenPages) {
        this.setBoolean(EXTRACTHIDDENPAGES, extractHiddenPages);
    }

    public boolean getExtractBodyPages() {
        return this.getBoolean(EXTRACTBODYPAGES);
    }

    public void setExtractBodyPages(boolean extractBodyPages) {
        this.setBoolean(EXTRACTBODYPAGES, extractBodyPages);
    }

    public boolean getExtractVariables() {
        return this.getBoolean(EXTRACTVARIABLES);
    }

    public void setExtractVariables(boolean extractVariables) {
        this.setBoolean(EXTRACTVARIABLES, extractVariables);
    }

    public boolean getExtractIndexMarkers() {
        return this.getBoolean(EXTRACTINDEXMARKERS);
    }

    public void setExtractIndexMarkers(boolean extractIndexMarkers) {
        this.setBoolean(EXTRACTINDEXMARKERS, extractIndexMarkers);
    }

    public boolean getExtractLinks() {
        return this.getBoolean(EXTRACTLINKS);
    }

    public void setExtractLinks(boolean extractLinks) {
        this.setBoolean(EXTRACTLINKS, extractLinks);
    }

    @Override
    public void reset() {
        super.reset();
        this.setExtractBodyPages(true);
        this.setExtractMasterPages(true);
        this.setExtractReferencePages(true);
        this.setExtractHiddenPages(true);
        this.setExtractVariables(true);
        this.setExtractIndexMarkers(true);
        this.setExtractLinks(false);
        this.setUseCodeFinder(true);
        this.codeFinder = new InlineCodeFinder();
        this.codeFinder.setSample("text <$varName> text");
        this.codeFinder.setUseAllRulesWhenTesting(true);
        this.codeFinder.addRule("<\\$.*?>");
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        this.codeFinder.fromString(this.buffer.getGroup(CODEFINDERRULES, ""));
    }

    @Override
    public String toString() {
        this.buffer.setGroup(CODEFINDERRULES, this.codeFinder.toString());
        return super.toString();
    }
}

