/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.openxml;

import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import net.sf.okapi.filters.openxml.Relationships;

public class Presentation {
    private XMLInputFactory factory;
    private Relationships rels;
    static final String PRESML_NS = "http://schemas.openxmlformats.org/presentationml/2006/main";
    static final String RELS_NS = "http://schemas.openxmlformats.org/officeDocument/2006/relationships";
    static final QName SLIDE_ID = new QName("http://schemas.openxmlformats.org/presentationml/2006/main", "sldId");
    static final QName REL_ID_ATTR = new QName("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "id");
    private List<String> slidePartNames = new ArrayList<String>();

    public Presentation(XMLInputFactory factory, Relationships rels) {
        this.factory = factory;
        this.rels = rels;
    }

    public List<String> getSlidePartNames() {
        return this.slidePartNames;
    }

    public void parseFromXML(Reader reader) throws XMLStreamException {
        XMLEventReader eventReader = this.factory.createXMLEventReader(reader);
        while (eventReader.hasNext()) {
            Attribute id;
            StartElement el;
            XMLEvent e = eventReader.nextEvent();
            if (!e.isStartElement() || !(el = e.asStartElement()).getName().equals(SLIDE_ID) || (id = el.getAttributeByName(REL_ID_ATTR)) == null) continue;
            Relationships.Rel rel = this.rels.getRelById(id.getValue());
            if (rel == null) {
                throw new IllegalStateException("Presentation refers to non-existent slide ID " + id.getValue());
            }
            this.slidePartNames.add(rel.target);
        }
    }
}

