/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.filters.wiki;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.sf.okapi.common.BaseParameters;
import net.sf.okapi.filters.wiki.WikiFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class Parameters
extends BaseParameters {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String WIKI_PARAMETERS = "wikiConfiguration.yml";
    private Yaml yaml = new Yaml();
    private Map<String, Object> config;
    private IdentityHashMap<Pattern, Pattern> customCodes;
    private boolean preserveWhitespace = false;

    public Parameters() {
        this.reset();
    }

    @Override
    public void reset() {
        this.config = (Map)this.yaml.load(WikiFilter.class.getResourceAsStream(WIKI_PARAMETERS));
        this.initialize();
    }

    private void initialize() {
        Object whitespace = this.config.get("preserve_whitespace");
        if (whitespace != null) {
            this.preserveWhitespace = (Boolean)whitespace;
        }
        this.customCodes = new IdentityHashMap();
        Object custom = this.config.get("custom_codes");
        if (custom != null) {
            for (HashMap c : (ArrayList)custom) {
                try {
                    Object endRegex;
                    Object phRegex = c.get("pattern");
                    if (phRegex != null) {
                        this.customCodes.put(Pattern.compile((String)phRegex), null);
                        continue;
                    }
                    Object startRegex = c.get("start_pattern");
                    if (!(startRegex != null & (endRegex = c.get("end_pattern")) != null)) continue;
                    this.customCodes.put(Pattern.compile((String)startRegex), Pattern.compile((String)endRegex));
                }
                catch (PatternSyntaxException ex) {
                    this.LOGGER.warn("Regex pattern was invalid: " + ex.getPattern());
                }
                catch (NullPointerException ex) {
                    this.LOGGER.warn("User-supplied custom regex for the Wiki filter was null. Make sure to enclose it in double-quotes in the config file.");
                }
            }
        }
    }

    @Override
    public String toString() {
        return this.yaml.dump(this.config);
    }

    @Override
    public void fromString(String data) {
        this.config = (Map)this.yaml.load(data);
        this.initialize();
    }

    public boolean isPreserveWhitespace() {
        return this.preserveWhitespace;
    }

    public IdentityHashMap<Pattern, Pattern> getCustomCodePatterns() {
        return this.customCodes;
    }

    @Override
    public boolean getBoolean(String name) {
        return false;
    }

    @Override
    public void setBoolean(String name, boolean value) {
    }

    @Override
    public String getString(String name) {
        return null;
    }

    @Override
    public void setString(String name, String value) {
    }

    @Override
    public int getInteger(String name) {
        return 0;
    }

    @Override
    public void setInteger(String name, int value) {
    }
}

