/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v1;

import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.common.ISkeleton;
import net.sf.okapi.common.annotation.IAnnotation;
import net.sf.okapi.common.resource.BaseNameable;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.lib.beans.v1.AnnotationsBean;
import net.sf.okapi.lib.beans.v1.PropertyBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class BaseNameableBean
extends PersistenceBean<BaseNameable> {
    private String id;
    private String name;
    private String type;
    private FactoryBean skeleton = new FactoryBean();
    private String mimeType;
    private boolean isTranslatable;
    private boolean preserveWS;
    private List<PropertyBean> properties = new ArrayList<PropertyBean>();
    private AnnotationsBean annotations = new AnnotationsBean();
    private List<PropertyBean> sourceProperties = new ArrayList<PropertyBean>();

    @Override
    protected BaseNameable createObject(IPersistenceSession session) {
        return new BaseNameable();
    }

    @Override
    protected void fromObject(BaseNameable obj, IPersistenceSession session) {
        PropertyBean propBean;
        this.id = obj.getId();
        this.name = obj.getName();
        this.type = obj.getType();
        this.skeleton.set(obj.getSkeleton(), session);
        this.mimeType = obj.getMimeType();
        this.isTranslatable = obj.isTranslatable();
        this.preserveWS = obj.preserveWhitespaces();
        for (String propName : obj.getPropertyNames()) {
            propBean = new PropertyBean();
            propBean.set(obj.getProperty(propName), session);
            this.properties.add(propBean);
        }
        this.annotations.set(obj.getAnnotations(), session);
        for (String propName : obj.getSourcePropertyNames()) {
            propBean = new PropertyBean();
            propBean.set(obj.getSourceProperty(propName), session);
            this.sourceProperties.add(propBean);
        }
    }

    @Override
    protected void setObject(BaseNameable obj, IPersistenceSession session) {
        obj.setId(this.id);
        obj.setName(this.name);
        obj.setType(this.type);
        obj.setSkeleton(this.skeleton.get(ISkeleton.class, session));
        obj.setMimeType(this.mimeType);
        obj.setIsTranslatable(this.isTranslatable);
        obj.setPreserveWhitespaces(this.preserveWS);
        for (PropertyBean prop : this.properties) {
            obj.setProperty(prop.get(Property.class, session));
        }
        for (FactoryBean annotationBean : this.annotations.getItems()) {
            obj.setAnnotation(annotationBean.get(IAnnotation.class, session));
        }
        for (PropertyBean prop : this.sourceProperties) {
            obj.setSourceProperty(prop.get(Property.class, session));
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public boolean isTranslatable() {
        return this.isTranslatable;
    }

    public void setTranslatable(boolean isTranslatable) {
        this.isTranslatable = isTranslatable;
    }

    public boolean isPreserveWS() {
        return this.preserveWS;
    }

    public void setPreserveWS(boolean preserveWS) {
        this.preserveWS = preserveWS;
    }

    public List<PropertyBean> getProperties() {
        return this.properties;
    }

    public void setProperties(List<PropertyBean> properties) {
        this.properties = properties;
    }

    public List<PropertyBean> getSourceProperties() {
        return this.sourceProperties;
    }

    public void setSourceProperties(List<PropertyBean> sourceProperties) {
        this.sourceProperties = sourceProperties;
    }

    public FactoryBean getSkeleton() {
        return this.skeleton;
    }

    public void setSkeleton(FactoryBean skeleton) {
        this.skeleton = skeleton;
    }

    public AnnotationsBean getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(AnnotationsBean annotations) {
        this.annotations = annotations;
    }
}

