/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.beans.v2;

import java.util.Hashtable;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.encoder.EncoderManager;
import net.sf.okapi.common.encoder.IEncoder;
import net.sf.okapi.lib.beans.v1.ParametersBean;
import net.sf.okapi.lib.persistence.IPersistenceSession;
import net.sf.okapi.lib.persistence.PersistenceBean;
import net.sf.okapi.lib.persistence.beans.FactoryBean;

public class EncoderManagerBean
extends PersistenceBean<EncoderManager> {
    private Hashtable<String, String> mimeMap = new Hashtable();
    private Hashtable<String, FactoryBean> encoders = new Hashtable();
    private String mimeType;
    private FactoryBean encoder = new FactoryBean();
    private String defEncoding;
    private String defLineBreak;
    private ParametersBean defParams = new ParametersBean();

    @Override
    protected EncoderManager createObject(IPersistenceSession session) {
        return new EncoderManager();
    }

    @Override
    protected void setObject(EncoderManager obj, IPersistenceSession session) {
        for (String mimeType : this.mimeMap.keySet()) {
            obj.setMapping(mimeType, this.mimeMap.get(mimeType));
        }
        for (String mimeType : this.encoders.keySet()) {
            obj.setMapping(mimeType, this.encoders.get(mimeType).get(IEncoder.class, session));
        }
        if (this.defLineBreak != null) {
            obj.setDefaultOptions(this.defParams.get(IParameters.class, session), this.defEncoding, this.defLineBreak);
        }
        obj.updateEncoder(this.mimeType);
    }

    @Override
    protected void fromObject(EncoderManager obj, IPersistenceSession session) {
        for (String mimeType : obj.getMimeMap().keySet()) {
            this.mimeMap.put(mimeType, obj.getMimeMap().get(mimeType));
        }
        for (String mimeType : obj.getEncoders().keySet()) {
            FactoryBean encoder = new FactoryBean();
            encoder.set(obj.getEncoders().get(mimeType), session);
            this.encoders.put(mimeType, encoder);
        }
        this.encoder.set(obj.getEncoder(), session);
        this.defEncoding = obj.getEncoding();
        this.defLineBreak = obj.getDefLineBreak();
        this.defParams.set(obj.getParameters(), session);
    }

    public Hashtable<String, String> getMimeMap() {
        return this.mimeMap;
    }

    public void setMimeMap(Hashtable<String, String> mimeMap) {
        this.mimeMap = mimeMap;
    }

    public Hashtable<String, FactoryBean> getEncoders() {
        return this.encoders;
    }

    public void setEncoders(Hashtable<String, FactoryBean> encoders) {
        this.encoders = encoders;
    }

    public final String getMimeType() {
        return this.mimeType;
    }

    public final void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public FactoryBean getEncoder() {
        return this.encoder;
    }

    public void setEncoder(FactoryBean encoder) {
        this.encoder = encoder;
    }

    public String getDefEncoding() {
        return this.defEncoding;
    }

    public void setDefEncoding(String defEncoding) {
        this.defEncoding = defEncoding;
    }

    public String getDefLineBreak() {
        return this.defLineBreak;
    }

    public void setDefLineBreak(String defLineBreak) {
        this.defLineBreak = defLineBreak;
    }

    public ParametersBean getDefParams() {
        return this.defParams;
    }

    public void setDefParams(ParametersBean defParams) {
        this.defParams = defParams;
    }
}

