/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.concurrent;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.pipeline.ICallableStep;
import net.sf.okapi.common.pipeline.IPipelineStep;
import net.sf.okapi.lib.concurrent.SortableEvent;

class CallableStep
implements ICallableStep<SortableEvent> {
    private IPipelineStep step;
    private SortableEvent currentEvent;

    public CallableStep(IPipelineStep step) {
        this.step = step;
    }

    @Override
    public Event processNow(Event event) {
        return this.step.handleEvent(event);
    }

    @Override
    public SortableEvent call() throws Exception {
        Event e = this.step.handleEvent(this.currentEvent);
        return new SortableEvent(e, this.currentEvent.getOrder());
    }

    @Override
    public IParameters getParameters() {
        return this.step.getParameters();
    }

    @Override
    public void setParameters(IParameters params) {
        this.step.setParameters(params);
    }

    @Override
    public String getName() {
        return String.format("%s (Callable)", this.step.getName());
    }

    @Override
    public String getDescription() {
        return String.format("Callable Wrapper for: %s", this.step.getName());
    }

    @Override
    public String getHelpLocation() {
        return this.step.getHelpLocation();
    }

    @Override
    public Event handleEvent(Event event) {
        this.currentEvent = (SortableEvent)event;
        return this.currentEvent;
    }

    @Override
    public boolean isDone() {
        return this.step.isDone();
    }

    @Override
    public void destroy() {
        this.step.destroy();
    }

    @Override
    public void cancel() {
        this.step.cancel();
    }

    @Override
    public boolean isLastOutputStep() {
        return this.step.isLastOutputStep();
    }

    @Override
    public void setLastOutputStep(boolean isLastStep) {
        this.step.setLastOutputStep(isLastStep);
    }

    @Override
    public IPipelineStep getMainStep() {
        return this.step;
    }
}

