/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.reporting;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.okapi.common.ListUtil;
import net.sf.okapi.common.RegexUtil;
import net.sf.okapi.common.StreamUtil;
import net.sf.okapi.common.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReportGenerator {
    private static final String FIELD_REGEX = "\\[([A-Z_]+[0-9]*)\\]";
    private static final String FIELD_LEAD_REGEX = "([ \\t]*)\\[([A-Z_]+)\\]";
    private static final String TABLE_REGEX = "([ \\t]*)\\[(.*\\[.+\\][\\r\\n \\t,;]*)\\]";
    private static final String WS_REGEX = "[ \\t]+";
    private String template;
    private String lineBreak = "\n";
    private Pattern fieldPattern = RegexUtil.getPattern("\\[([A-Z_]+[0-9]*)\\]");
    private Pattern fieldLeadPattern = RegexUtil.getPattern("([ \\t]*)\\[([A-Z_]+)\\]");
    private Pattern tablePattern = RegexUtil.getPattern("([ \\t]*)\\[(.*\\[.+\\][\\r\\n \\t,;]*)\\]");
    private Pattern wsPattern = RegexUtil.getPattern("[ \\t]+");
    private Hashtable<String, String> simpleFields = new Hashtable();
    private Hashtable<String, String> simpleFieldLeads = new Hashtable();
    private Hashtable<String, LinkedList<String>> multiFields = new Hashtable();
    private StringBuilder sb;
    private boolean multiItemReport;
    private boolean htmlReport;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public ReportGenerator(String template) {
        this.setTemplate(template);
        this.sb = new StringBuilder();
    }

    public ReportGenerator(InputStream templateStream) {
        this(StreamUtil.streamUtf8AsString(templateStream));
    }

    private boolean isSimpleField(String fieldName) {
        return this.simpleFields.containsKey(fieldName);
    }

    private boolean isMultiField(String fieldName) {
        return this.multiFields.containsKey(fieldName);
    }

    private boolean isCompoundField(String fieldName) {
        return this.isSimpleField(fieldName) && fieldName.indexOf("[") != -1 && fieldName.indexOf("]") != -1;
    }

    public void setField(String fieldName, String value) {
        if (!"0".equals(value)) {
            this.sb.append(fieldName);
            this.sb.append(" = ");
            this.sb.append(value);
            this.sb.append("\n");
        }
        if (this.isSimpleField(fieldName)) {
            this.simpleFields.put(fieldName, value);
        } else if (this.isMultiField(fieldName)) {
            LinkedList<String> list = this.multiFields.get(fieldName);
            if (list == null) {
                list = new LinkedList();
            }
            list.add(value);
        }
    }

    public void setField(String fieldName, long value) {
        this.setField(fieldName, Long.toString(value));
    }

    public void setField(String fieldName, double value) {
        DecimalFormat df = new DecimalFormat();
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(dfs);
        df.setMinimumFractionDigits(2);
        df.setMaximumFractionDigits(2);
        this.setField(fieldName, df.format(value));
    }

    public void setField(String fieldName, int value) {
        this.setField(fieldName, Integer.toString(value));
    }

    public void setField(String fieldName, boolean value) {
        this.setField(fieldName, Boolean.toString(value));
    }

    private void registerFields(String st, boolean isMultiple) {
        Matcher matcher;
        while ((matcher = this.fieldPattern.matcher(st)).find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            int start2 = matcher.start(1);
            int end2 = matcher.end(1);
            String field = st.substring(start, end);
            String fieldName = st.substring(start2, end2);
            st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, "");
            this.registerField(fieldName, isMultiple);
        }
    }

    private void registerFields() {
        Matcher matcher;
        String st = this.template;
        while ((matcher = this.tablePattern.matcher(st)).find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            int start1 = matcher.start(1);
            int end1 = matcher.end(1);
            int start2 = matcher.start(2);
            int end2 = matcher.end(2);
            String tableField = st.substring(start, end);
            String table = st.substring(start1, end1) + st.substring(start2, end2);
            this.registerField(table, false);
            st = RegexUtil.replaceAll(st, RegexUtil.escape(tableField), 0, "");
            this.registerFields(table, true);
        }
        this.registerFields(st, false);
        this.collectSimpleFieldLeads();
    }

    private void collectSimpleFieldLeads() {
        Matcher matcher;
        String st = this.template;
        while ((matcher = this.fieldLeadPattern.matcher(st)).find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            int start1 = matcher.start(1);
            int end1 = matcher.end(1);
            int start2 = matcher.start(2);
            int end2 = matcher.end(2);
            String field = st.substring(start, end);
            String fieldLead = st.substring(start1, end1);
            String fieldName = st.substring(start2, end2);
            st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, "");
            if (!this.simpleFields.containsKey(fieldName)) continue;
            this.simpleFieldLeads.put(fieldName, fieldLead);
        }
    }

    private void registerField(String fieldName, boolean isMultiple) {
        if (isMultiple) {
            this.multiFields.put(fieldName, new LinkedList());
        } else {
            this.simpleFields.put(fieldName, "");
        }
    }

    public String generate() {
        int end;
        int start;
        Matcher matcher;
        String st = this.template;
        while ((matcher = this.tablePattern.matcher(st)).find()) {
            start = matcher.start(0);
            end = matcher.end(0);
            int start1 = matcher.start(1);
            int end1 = matcher.end(1);
            int start2 = matcher.start(2);
            int end2 = matcher.end(2);
            String field = st.substring(start, end);
            String fieldName = st.substring(start1, end1) + st.substring(start2, end2);
            String value = this.getData(fieldName);
            if (!Util.isEmpty(value)) {
                st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, value);
                continue;
            }
            st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, st.substring(start1, end1) + "{?" + st.substring(start2, end2) + "}");
        }
        while ((matcher = this.fieldPattern.matcher(st)).find()) {
            start = matcher.start(0);
            end = matcher.end(0);
            int start2 = matcher.start(1);
            int end2 = matcher.end(1);
            String field = st.substring(start, end);
            String fieldName = st.substring(start2, end2);
            String value = this.getData(fieldName);
            if (!Util.isEmpty(value)) {
                value = value.replaceAll("\n", "\n" + this.simpleFieldLeads.get(fieldName));
                st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, value);
                continue;
            }
            st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, "[?" + fieldName + "]");
        }
        this.logger.debug(this.sb.toString());
        return st;
    }

    public void reset() {
        this.sb = new StringBuilder();
        for (String fieldName : this.simpleFields.keySet()) {
            this.simpleFields.put(fieldName, "");
        }
        for (String fieldName : this.multiFields.keySet()) {
            List list = this.multiFields.get(fieldName);
            list.clear();
        }
    }

    private String getData(String fieldName) {
        String st = "";
        if (this.isCompoundField(fieldName)) {
            st = this.buildTable(fieldName);
        } else if (this.simpleFields.containsKey(fieldName)) {
            st = this.simpleFields.get(fieldName);
        }
        return st;
    }

    public String getField(String fieldName) {
        return this.simpleFields.get(fieldName);
    }

    public List<String> getMultiField(String multiFieldName) {
        return this.multiFields.get(multiFieldName);
    }

    public Set<String> getFieldNames() {
        return this.simpleFields.keySet();
    }

    public Set<String> getMultiFieldNames() {
        return this.multiFields.keySet();
    }

    private String buildTable(String tableTemplate) {
        List column;
        String[] columnNames = this.extractFields(tableTemplate);
        LinkedList<List> columns = new LinkedList<List>();
        int numRows = 0;
        for (String columnName : columnNames) {
            column = this.multiFields.get(columnName);
            columns.add(column);
            numRows = Math.max(numRows, column.size());
        }
        for (String columnName : columnNames) {
            column = this.multiFields.get(columnName);
            for (int i = column.size(); i < numRows; ++i) {
                column.add("[?" + columnName + "]");
            }
        }
        String st = "";
        if (numRows > 0) {
            st = this.fillRow(tableTemplate, 0);
            for (int i = 1; i < numRows; ++i) {
                st = st + this.lineBreak + this.fillRow(tableTemplate, i);
            }
        }
        return st;
    }

    private String fillRow(String tableTemplate, int rowIndex) {
        Matcher matcher;
        String st = tableTemplate;
        Matcher m = this.wsPattern.matcher(st);
        String leadingWhitespace = null;
        if (m.find()) {
            leadingWhitespace = m.group();
        }
        while ((matcher = this.fieldPattern.matcher(st)).find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            int start2 = matcher.start(1);
            int end2 = matcher.end(1);
            String field = st.substring(start, end);
            String fieldName = st.substring(start2, end2);
            List column = this.multiFields.get(fieldName);
            st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, (String)column.get(rowIndex));
            st = st.replaceAll("\n", "\n" + leadingWhitespace);
        }
        return st;
    }

    private String[] extractFields(String tableTemplate) {
        Matcher matcher;
        LinkedList<String> list = new LinkedList<String>();
        String st = tableTemplate;
        while ((matcher = this.fieldPattern.matcher(st)).find()) {
            int start = matcher.start(0);
            int end = matcher.end(0);
            int start2 = matcher.start(1);
            int end2 = matcher.end(1);
            String field = st.substring(start, end);
            String fieldName = st.substring(start2, end2);
            st = RegexUtil.replaceAll(st, RegexUtil.escape(field), 0, "");
            list.add(fieldName);
        }
        return ListUtil.stringListAsArray(list);
    }

    public String getLineBreak() {
        return this.lineBreak;
    }

    public void setLineBreak(String lineBreak) {
        this.lineBreak = lineBreak;
    }

    public String getTemplate() {
        return this.template;
    }

    public void setTemplate(String template) {
        this.template = template;
        if (Util.isEmpty(template)) {
            this.logger.warn("Scoping Report template is not set.");
            return;
        }
        this.registerFields();
        this.multiItemReport = this.multiFields.size() > 0;
        boolean bl = this.htmlReport = template.indexOf("<html") != -1 && template.indexOf("<body") != -1;
        if (this.htmlReport) {
            this.setLineBreak("<br>");
        }
    }

    protected boolean isMultiItemReport() {
        return this.multiItemReport;
    }

    protected boolean isHtmlReport() {
        return this.htmlReport;
    }
}

