/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.lib.transifex;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;
import net.sf.okapi.common.uidescription.TextInputPart;

public class Parameters
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String SERVER = "server";
    private static final String PROJECTID = "projectId";
    private static final String USER = "user";
    private static final String PASSWORD = "password";

    public Parameters() {
    }

    public Parameters(String initialData) {
        super(initialData);
    }

    @Override
    public void reset() {
        super.reset();
        this.setServer("http://www.transifex.net/");
        this.setProjectId("");
        this.setUser("");
        this.setPassword("");
    }

    public String getServer() {
        return this.getString(SERVER);
    }

    public void setServer(String server) {
        if (server.endsWith("\\")) {
            server = server.substring(0, server.length() - 1) + "/";
        } else if (!server.endsWith("/")) {
            server = server + "/";
        }
        this.setString(SERVER, server);
    }

    public String getProjectId() {
        return this.getString(PROJECTID);
    }

    public void setProjectId(String projectId) {
        this.setString(PROJECTID, projectId);
    }

    public String getUser() {
        return this.getString(USER);
    }

    public void setUser(String user) {
        this.setString(USER, user);
    }

    public String getPassword() {
        return this.getString(PASSWORD);
    }

    public void setPassword(String password) {
        this.setString(PASSWORD, password);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(SERVER, "Server URL", "Full URL of the server (e.g. http://www.transifex.net/)");
        desc.add(USER, "User name", "User name to login");
        desc.add(PASSWORD, "Password", "Password to login");
        desc.add(PROJECTID, "Project ID", "Identifier of the project (case sensitive)");
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Transifex Settings");
        desc.addTextInputPart(paramsDesc.get(SERVER));
        desc.addTextInputPart(paramsDesc.get(USER));
        TextInputPart tip = desc.addTextInputPart(paramsDesc.get(PASSWORD));
        tip.setPassword(true);
        desc.addTextInputPart(paramsDesc.get(PROJECTID));
        return desc;
    }
}

