/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.common.codesimplifier;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.UsingParameters;
import net.sf.okapi.common.pipeline.BasePipelineStep;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.common.skeleton.GenericSkeleton;
import net.sf.okapi.steps.common.codesimplifier.Parameters;

@UsingParameters(value=Parameters.class)
public class CodeSimplifierStep
extends BasePipelineStep {
    private Parameters params = new Parameters();

    @Override
    public String getDescription() {
        return "Merges adjacent inline codes in the source part of a text unit. Also where possible, moves leading and trailing codes of the source to the skeleton. Expects: filter events. Sends back: filter events.";
    }

    @Override
    public String getName() {
        return "Inline Codes Simplifier";
    }

    @Override
    public IParameters getParameters() {
        return this.params;
    }

    @Override
    public void setParameters(IParameters params) {
        this.params = (Parameters)params;
    }

    @Override
    protected Event handleTextUnit(Event event) {
        ITextUnit tu = event.getTextUnit();
        TextUnitUtil.simplifyCodes(tu, this.params.getRemoveLeadingTrailingCodes() && tu.getSkeleton() instanceof GenericSkeleton);
        return super.handleTextUnit(event);
    }
}

