/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.inconsistencycheck;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.XMLWriter;
import net.sf.okapi.common.filterwriter.GenericContent;
import net.sf.okapi.common.resource.TextFragment;
import net.sf.okapi.common.resource.TextUnitUtil;
import net.sf.okapi.steps.inconsistencycheck.Duplicate;
import net.sf.okapi.steps.inconsistencycheck.Parameters;

public class InconsistencyCheck {
    private Parameters params = new Parameters();
    private Map<String, Group> trgDifferences;
    private Map<String, Group> srcDifferences;
    private GenericContent fmt = new GenericContent();
    private XMLWriter writer = null;

    public InconsistencyCheck() {
        this.trgDifferences = new HashMap<String, Group>();
        this.srcDifferences = new HashMap<String, Group>();
    }

    public void reset(boolean includeXml) {
        if (includeXml) {
            this.writer.close();
            this.writer = null;
        }
        this.trgDifferences.clear();
        this.srcDifferences.clear();
    }

    public Parameters getParameters() {
        return this.params;
    }

    public void setParameters(Parameters params) {
        this.params = params;
    }

    public void store(String docId, String subDocId, String tuId, String segId, TextFragment srcTf, TextFragment trgTf) {
        this.addToMap(this.trgDifferences, docId, subDocId, tuId, segId, srcTf, trgTf);
        this.addToMap(this.srcDifferences, docId, subDocId, tuId, segId, trgTf, srcTf);
    }

    private void detectIssues() {
        this.computeIssues(this.trgDifferences);
        this.computeIssues(this.srcDifferences);
    }

    public void generateReport(String reportPath, boolean isEndBatch) {
        this.detectIssues();
        this.generateXMLReport(reportPath, isEndBatch);
    }

    private String toDisplayFormat(TextFragment tf) {
        String displayOption = this.params.getDisplayOption();
        if (displayOption.equals("original")) {
            return tf.toText();
        }
        if (displayOption.equals("generic")) {
            return this.fmt.setContent(tf).toString();
        }
        return TextUnitUtil.removeCodes(tf.getCodedText());
    }

    private String toCompareFormat(TextFragment tf) {
        return TextUnitUtil.removeCodes(tf.getCodedText());
    }

    private void addToMap(Map<String, Group> map, String docId, String subDocId, String tuId, String segId, TextFragment keyTf, TextFragment dataTf) {
        Duplicate dup = new Duplicate(docId, subDocId, tuId, segId, this.toCompareFormat(dataTf), this.toDisplayFormat(dataTf));
        String key = this.toCompareFormat(keyTf);
        Group grp = map.get(key);
        if (grp == null) {
            grp = new Group(this.toDisplayFormat(keyTf));
            map.put(key, grp);
        }
        grp.entries.add(dup);
    }

    private void computeIssues(Map<String, Group> map) {
        Iterator<Group> iter = map.values().iterator();
        while (iter.hasNext()) {
            Group group = iter.next();
            List<Duplicate> list = group.entries;
            if (list.size() < 2) {
                iter.remove();
                continue;
            }
            boolean keep = false;
            block1: for (int i = 0; i < list.size() && !keep; ++i) {
                String text1 = list.get(i).getText();
                for (int j = i + 1; j < list.size(); ++j) {
                    String text2 = list.get(j).getText();
                    if (text1.equals(text2)) continue;
                    keep = true;
                    continue block1;
                }
            }
            if (keep) continue;
            iter.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateXMLReport(String finalPath, boolean isEndBatch) {
        try {
            if (this.writer == null) {
                this.writeXmlStart(finalPath);
            }
            this.writeIssues(this.writer, this.trgDifferences, true);
            this.writeIssues(this.writer, this.srcDifferences, false);
            if (isEndBatch) {
                this.writeXmlEnd();
            } else {
                this.reset(false);
            }
        }
        finally {
            if (isEndBatch && this.writer != null) {
                this.writer.close();
                if (this.params.isAutoOpen()) {
                    Util.openURL(new File(finalPath).getAbsolutePath());
                }
            }
        }
    }

    private void writeXmlStart(String finalPath) {
        this.writer = new XMLWriter(finalPath);
        this.writer.writeStartDocument();
        this.writer.writeStartElement("inconsistencyCheck");
        if (this.params.getCheckPerFile()) {
            this.writer.writeAttributeString("perFile", "true");
        } else {
            this.writer.writeAttributeString("perFile", "false");
        }
        this.writer.writeLineBreak();
    }

    private void writeIssues(XMLWriter writer, Map<String, Group> map, boolean isKeyTheSource) {
        for (String key : map.keySet()) {
            writer.writeStartElement(isKeyTheSource ? "targetDifferences" : "sourceDifferences");
            writer.writeLineBreak();
            Group grp = map.get(key);
            writer.writeElementString(isKeyTheSource ? "source" : "target", grp.keyDisplay);
            writer.writeLineBreak();
            for (Duplicate dup : grp.entries) {
                writer.writeStartElement("issue");
                writer.writeAttributeString("seg", dup.getSegId());
                writer.writeAttributeString("tu", dup.getTuId());
                writer.writeAttributeString("subDoc", dup.getSubDocId());
                writer.writeAttributeString("doc", dup.getDocId());
                writer.writeString(dup.getDisplay());
                writer.writeEndElementLineBreak();
            }
            writer.writeEndElementLineBreak();
        }
    }

    private void writeXmlEnd() {
        this.writer.writeEndElementLineBreak();
        this.writer.writeEndDocument();
    }

    class Group {
        String keyDisplay;
        List<Duplicate> entries;

        public Group(String keyDisplay) {
            this.keyDisplay = keyDisplay;
            this.entries = new ArrayList<Duplicate>();
        }
    }
}

