/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import net.sf.okapi.common.ParametersDescription;
import net.sf.okapi.common.StringParameters;
import net.sf.okapi.common.uidescription.CheckboxPart;
import net.sf.okapi.common.uidescription.EditorDescription;
import net.sf.okapi.common.uidescription.IEditorDescriptionProvider;

public class Options
extends StringParameters
implements IEditorDescriptionProvider {
    private static final String PLACEHOLDERMODE = "placeholderMode";
    private static final String INCLUDENOTRANSLATE = "includeNoTranslate";
    private static final String SETAPPROVEDASNOTRANSLATE = "setApprovedAsNoTranslate";
    private static final String COPYSOURCE = "copySource";
    private static final String INCLUDEALTTRANS = "includeAltTrans";
    private static final String INCLUDECODEATTRS = "includeCodeAttrs";
    private static final String INCLUDEITS = "includeIts";
    private static final String USESKELETON = "useSkeleton";

    @Override
    public void reset() {
        super.reset();
        this.setPlaceholderMode(true);
        this.setIncludeNoTranslate(true);
        this.setSetApprovedAsNoTranslate(false);
        this.setCopySource(true);
        this.setIncludeAltTrans(true);
        this.setIncludeCodeAttrs(false);
        this.setIncludeIts(true);
        this.setUseSkeleton(false);
    }

    @Override
    public void fromString(String data) {
        super.fromString(data);
        if (!this.getIncludeNoTranslate()) {
            this.setSetApprovedAsNoTranslate(false);
        }
    }

    public void setUseSkeleton(boolean useSkeleton) {
        this.setBoolean(USESKELETON, useSkeleton);
    }

    public boolean getUseSkeleton() {
        return this.getBoolean(USESKELETON);
    }

    public boolean getPlaceholderMode() {
        return this.getBoolean(PLACEHOLDERMODE);
    }

    public void setPlaceholderMode(boolean placeholderMode) {
        this.setBoolean(PLACEHOLDERMODE, placeholderMode);
    }

    public boolean getIncludeNoTranslate() {
        return this.getBoolean(INCLUDENOTRANSLATE);
    }

    public void setIncludeNoTranslate(boolean includeNoTranslate) {
        this.setBoolean(INCLUDENOTRANSLATE, includeNoTranslate);
    }

    public boolean getSetApprovedAsNoTranslate() {
        return this.getBoolean(SETAPPROVEDASNOTRANSLATE);
    }

    public void setSetApprovedAsNoTranslate(boolean setApprovedAsNoTranslate) {
        this.setBoolean(SETAPPROVEDASNOTRANSLATE, setApprovedAsNoTranslate);
    }

    public boolean getCopySource() {
        return this.getBoolean(COPYSOURCE);
    }

    public void setCopySource(boolean copySource) {
        this.setBoolean(COPYSOURCE, copySource);
    }

    public boolean getIncludeAltTrans() {
        return this.getBoolean(INCLUDEALTTRANS);
    }

    public void setIncludeAltTrans(boolean includeAltTrans) {
        this.setBoolean(INCLUDEALTTRANS, includeAltTrans);
    }

    public boolean getIncludeCodeAttrs() {
        return this.getBoolean(INCLUDECODEATTRS);
    }

    public void setIncludeCodeAttrs(boolean includeCodeAttrs) {
        this.setBoolean(INCLUDECODEATTRS, includeCodeAttrs);
    }

    public boolean getIncludeIts() {
        return this.getBoolean(INCLUDEITS);
    }

    public void setIncludeIts(boolean includeIts) {
        this.setBoolean(INCLUDEITS, includeIts);
    }

    @Override
    public ParametersDescription getParametersDescription() {
        ParametersDescription desc = new ParametersDescription(this);
        desc.add(PLACEHOLDERMODE, "Use <g></g> and <x/> notation", null);
        desc.add(INCLUDENOTRANSLATE, "Include non-translatable text units", null);
        desc.add(SETAPPROVEDASNOTRANSLATE, "Set approved entries as non-translatable", null);
        desc.add(COPYSOURCE, "Copy source text in target if no target is available", null);
        desc.add(INCLUDEALTTRANS, "Include <alt-trans> elements", null);
        desc.add(INCLUDECODEATTRS, "Include extended code attributes when available", null);
        desc.add(INCLUDEITS, "Include ITS markup when available", null);
        desc.add(USESKELETON, "Use the JSON skeleton for merging back", null);
        return desc;
    }

    @Override
    public EditorDescription createEditorDescription(ParametersDescription paramsDesc) {
        EditorDescription desc = new EditorDescription("Generic XLIFF Package", true, false);
        CheckboxPart cbp1 = desc.addCheckboxPart(paramsDesc.get(INCLUDENOTRANSLATE));
        CheckboxPart cbp2 = desc.addCheckboxPart(paramsDesc.get(SETAPPROVEDASNOTRANSLATE));
        cbp2.setMasterPart(cbp1, true);
        desc.addCheckboxPart(paramsDesc.get(PLACEHOLDERMODE));
        desc.addCheckboxPart(paramsDesc.get(COPYSOURCE));
        desc.addCheckboxPart(paramsDesc.get(INCLUDEALTTRANS));
        desc.addCheckboxPart(paramsDesc.get(INCLUDECODEATTRS));
        desc.addCheckboxPart(paramsDesc.get(INCLUDEITS));
        desc.addCheckboxPart(paramsDesc.get(USESKELETON));
        return desc;
    }
}

