/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.steps.rainbowkit.xliff;

import net.sf.okapi.common.Event;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filterwriter.XLIFFWriter;
import net.sf.okapi.common.filterwriter.XLIFFWriterParameters;
import net.sf.okapi.common.resource.StartDocument;
import net.sf.okapi.filters.rainbowkit.MergingInfo;
import net.sf.okapi.lib.tkit.writer.BeanEventWriter;
import net.sf.okapi.lib.tkit.writer.Parameters;
import net.sf.okapi.steps.rainbowkit.common.BasePackageWriter;
import net.sf.okapi.steps.rainbowkit.xliff.Options;

public class XLIFFPackageWriter
extends BasePackageWriter {
    protected XLIFFWriter writer;
    private Options options;
    private boolean preSegmented = false;
    private boolean forOmegat = false;
    private String rawDocPath;
    private String skelPath;
    private BeanEventWriter skeletonWriter = null;
    private Parameters skeletonWriterParams = null;

    public XLIFFPackageWriter() {
        super("xliff");
    }

    public boolean getPreSegmented() {
        return this.preSegmented;
    }

    public void setForOmegat(boolean forOmegat) {
        this.forOmegat = forOmegat;
    }

    @Override
    public Event handleEvent(Event event) {
        switch (event.getEventType()) {
            case START_BATCH: {
                this.processStartBatch();
                break;
            }
            case END_BATCH: {
                this.processEndBatch();
                break;
            }
            case START_BATCH_ITEM: {
                this.processStartBatchItem();
                break;
            }
            case END_BATCH_ITEM: {
                this.processEndBatchItem();
                break;
            }
            case START_DOCUMENT: {
                this.processStartDocument(event);
                break;
            }
            case END_DOCUMENT: {
                this.processEndDocument(event);
                break;
            }
            case START_SUBDOCUMENT: {
                this.processStartSubDocument(event);
                break;
            }
            case END_SUBDOCUMENT: {
                this.processEndSubDocument(event);
                break;
            }
            case DOCUMENT_PART: {
                this.processDocumentPart(event);
                break;
            }
            case START_GROUP: {
                this.processStartGroup(event);
                break;
            }
            case END_GROUP: {
                this.processEndGroup(event);
                break;
            }
            case TEXT_UNIT: {
                this.processTextUnit(event);
                break;
            }
            case NO_OP: {
                return event;
            }
            case START_SUBFILTER: 
            case END_SUBFILTER: 
            case PIPELINE_PARAMETERS: 
            case RAW_DOCUMENT: 
            case CANCELED: 
            case CUSTOM: 
            case MULTI_EVENT: {
                event = super.handleEvent(event);
            }
        }
        if (this.skeletonWriter != null) {
            this.skeletonWriter.handleEvent(event);
        }
        return event;
    }

    @Override
    protected void processStartBatch() {
        this.skelPath = null;
        this.manifest.setSubDirectories("original", "work", "work", "done", null, "skeleton", false);
        this.options = new Options();
        if (!Util.isEmpty(this.params.getWriterOptions())) {
            this.options.fromString(this.params.getWriterOptions());
        }
        if (this.forOmegat) {
            this.options.setCopySource(true);
            this.options.setIncludeAltTrans(false);
            this.options.setIncludeCodeAttrs(true);
            this.options.setUseSkeleton(false);
        }
        this.setTMXInfo(true, null, this.options.getPlaceholderMode(), true, false);
        super.processStartBatch();
    }

    @Override
    protected void processStartDocument(Event event) {
        super.processStartDocument(event);
        this.writer = new XLIFFWriter();
        this.writer.setOptions(this.manifest.getTargetLocale(), "UTF-8");
        MergingInfo item = this.manifest.getItem(this.docId);
        this.rawDocPath = this.manifest.getTempSourceDirectory() + item.getRelativeInputPath() + ".xlf";
        this.writer.setOutput(this.rawDocPath);
        XLIFFWriterParameters paramsXliff = (XLIFFWriterParameters)this.writer.getParameters();
        if (this.forOmegat) {
            paramsXliff.setUseSourceForTranslated(true);
        }
        paramsXliff.setPlaceholderMode(this.options.getPlaceholderMode());
        paramsXliff.setCopySource(this.options.getCopySource());
        paramsXliff.setIncludeAltTrans(this.options.getIncludeAltTrans());
        paramsXliff.setSetApprovedAsNoTranslate(this.options.getSetApprovedAsNoTranslate());
        paramsXliff.setIncludeNoTranslate(this.options.getIncludeNoTranslate());
        paramsXliff.setIncludeCodeAttrs(this.options.getIncludeCodeAttrs());
        paramsXliff.setIncludeIts(this.options.getIncludeIts());
        if (this.options.getUseSkeleton()) {
            this.skeletonWriterParams = new Parameters();
            this.skeletonWriterParams.setMessage(this.params.getMessage());
            this.skeletonWriterParams.setRemoveTarget(!event.getStartDocument().isMultilingual());
            this.skelPath = this.manifest.getTempSkelDirectory() + item.getRelativeInputPath() + ".skl";
            item.setUseSkeleton(true);
            this.skeletonWriter = new BeanEventWriter();
            this.skeletonWriter.setParameters(this.skeletonWriterParams);
            this.skeletonWriter.setOptions(this.manifest.getTargetLocale(), "UTF-8");
            this.skeletonWriter.setOutput(this.skelPath);
        }
        StartDocument sd = event.getStartDocument();
        this.writer.create(this.rawDocPath, null, this.manifest.getSourceLocale(), this.manifest.getTargetLocale(), sd.getMimeType(), item.getRelativeInputPath(), null);
    }

    @Override
    protected Event processEndDocument(Event event) {
        if (this.writer != null) {
            this.writer.handleEvent(event);
            this.writer.close();
            this.writer = null;
        }
        if (this.params.getSendOutput()) {
            return super.creatRawDocumentEventSet(this.rawDocPath, "UTF-8", this.manifest.getSourceLocale(), this.manifest.getTargetLocale());
        }
        return event;
    }

    @Override
    protected void processStartSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndSubDocument(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processStartGroup(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processEndGroup(Event event) {
        this.writer.handleEvent(event);
    }

    @Override
    protected void processTextUnit(Event event) {
        event = this.writer.handleEvent(event);
        this.writeTMXEntries(event.getTextUnit());
        if (!this.preSegmented) {
            this.preSegmented = event.getTextUnit().getSource().hasBeenSegmented();
        }
    }

    @Override
    public void close() {
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
        if (this.skeletonWriter != null) {
            this.skeletonWriter.close();
            this.skeletonWriter = null;
        }
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }
}

