/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.alignment;

import net.sf.okapi.applications.rainbow.lib.SegmentationPanel;
import net.sf.okapi.applications.rainbow.lib.Utils;
import net.sf.okapi.applications.rainbow.utilities.alignment.Parameters;
import net.sf.okapi.common.ConfigurationString;
import net.sf.okapi.common.IContext;
import net.sf.okapi.common.IHelp;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.IParametersEditor;
import net.sf.okapi.common.ui.Dialogs;
import net.sf.okapi.common.ui.OKCancelPanel;
import net.sf.okapi.common.ui.UIUtil;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class Editor
implements IParametersEditor {
    private Shell shell;
    private boolean result = false;
    private OKCancelPanel pnlActions;
    private Parameters params;
    private Button chkCreateTMX;
    private Text edTMXPath;
    private Button btGetTMXPath;
    private Button chkCreateTMXForUnknown;
    private Text edTMXForUnknownPath;
    private Button btGetTMXForUnknownPath;
    private Button chkUseTradosWorkarounds;
    private Button chkUseExclusion;
    private Text edExclusion;
    private Button chkCreateTM;
    private Text edTMPath;
    private Button btGetTMPath;
    private Button chkCheckSingleSegUnit;
    private Button chkUseAutoCorrection;
    private Button chkCreateAttributes;
    private Text edAttributes;
    private SegmentationPanel pnlSegmentation;
    private boolean inInit = true;
    private IHelp help;
    private String projectDir;
    private Text edMTKey;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean edit(IParameters p_Options, boolean readOnly, IContext context) {
        boolean bRes = false;
        try {
            this.shell = null;
            this.help = (IHelp)context.getObject("help");
            this.projectDir = context.getString("projDir");
            this.params = (Parameters)p_Options;
            this.shell = new Shell((Shell)context.getObject("shell"), 65648);
            this.create((Shell)context.getObject("shell"), readOnly);
            boolean bl = this.showDialog();
            return bl;
        }
        catch (Exception e) {
            Dialogs.showError(this.shell, e.getLocalizedMessage(), null);
            bRes = false;
        }
        finally {
            if (this.shell != null) {
                this.shell.dispose();
            }
        }
        return bRes;
    }

    @Override
    public IParameters createParameters() {
        return new Parameters();
    }

    private void create(Shell parent, boolean readOnly) {
        this.shell.setText("ID-Based Alignment");
        if (parent != null) {
            UIUtil.inheritIcon(this.shell, parent);
        }
        GridLayout layTmp = new GridLayout();
        layTmp.marginBottom = 0;
        layTmp.verticalSpacing = 0;
        this.shell.setLayout((Layout)layTmp);
        TabFolder tfTmp = new TabFolder((Composite)this.shell, 0);
        tfTmp.setLayoutData((Object)new GridData(1808));
        Composite cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        TabItem tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Options");
        tiTmp.setControl((Control)cmpTmp);
        Group grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("Segmentation");
        grpTmp.setLayout((Layout)new GridLayout());
        GridData gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        this.pnlSegmentation = new SegmentationPanel((Composite)grpTmp, 0, "Segment the extracted text using the following SRX rules:", this.help, this.projectDir);
        this.pnlSegmentation.setLayoutData(new GridData(768));
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("Verification and Correction");
        grpTmp.setLayout((Layout)new GridLayout());
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        this.chkCheckSingleSegUnit = UIUtil.createGridButton((Composite)grpTmp, 32, "Verify in-line codes for text units with a single segment", -1, 2);
        this.chkUseAutoCorrection = UIUtil.createGridButton((Composite)grpTmp, 32, "Use auto-correction automatically", -1, 2);
        Label stMT = new Label((Composite)grpTmp, 0);
        stMT.setText("API key for Google MT (leave empty to not use):");
        this.edMTKey = new Text((Composite)grpTmp, 2048);
        this.edMTKey.setLayoutData((Object)new GridData(768));
        this.edMTKey.setEchoChar('*');
        cmpTmp = new Composite((Composite)tfTmp, 0);
        cmpTmp.setLayout((Layout)new GridLayout());
        tiTmp = new TabItem(tfTmp, 0);
        tiTmp.setText("Output");
        tiTmp.setControl((Control)cmpTmp);
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("TMX Output");
        grpTmp.setLayout((Layout)new GridLayout(2, false));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        this.chkCreateTMX = new Button((Composite)grpTmp, 32);
        this.chkCreateTMX.setText("Create a TMX document with the aligned entries:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkCreateTMX.setLayoutData((Object)gdTmp);
        this.chkCreateTMX.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateTMXOptions();
            }
        });
        this.edTMXPath = new Text((Composite)grpTmp, 2048);
        this.edTMXPath.setLayoutData((Object)new GridData(768));
        this.btGetTMXPath = new Button((Composite)grpTmp, 8);
        this.btGetTMXPath.setText("...");
        this.btGetTMXPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = Dialogs.browseFilenamesForSave(Editor.this.shell, "TMX File", null, null, "TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
                Utils.checkProjectDirAfterPick(path, Editor.this.edTMXPath, Editor.this.projectDir);
            }
        });
        this.chkCreateTMXForUnknown = new Button((Composite)grpTmp, 32);
        this.chkCreateTMXForUnknown.setText("Create a TMX document with the source entries not found:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkCreateTMXForUnknown.setLayoutData((Object)gdTmp);
        this.chkCreateTMXForUnknown.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateTMXOptions();
            }
        });
        this.edTMXForUnknownPath = new Text((Composite)grpTmp, 2048);
        this.edTMXForUnknownPath.setLayoutData((Object)new GridData(768));
        this.btGetTMXForUnknownPath = new Button((Composite)grpTmp, 8);
        this.btGetTMXForUnknownPath.setText("...");
        this.btGetTMXForUnknownPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = Dialogs.browseFilenamesForSave(Editor.this.shell, "TMX File", null, null, "TMX Documents (*.tmx)\tAll Files (*.*)", "*.tmx\t*.*");
                Utils.checkProjectDirAfterPick(path, Editor.this.edTMXForUnknownPath, Editor.this.projectDir);
            }
        });
        this.chkUseTradosWorkarounds = new Button((Composite)grpTmp, 32);
        this.chkUseTradosWorkarounds.setText("Generate Trados workarounds");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseTradosWorkarounds.setLayoutData((Object)gdTmp);
        this.chkUseExclusion = new Button((Composite)grpTmp, 32);
        this.chkUseExclusion.setText("Exclude segments where the source text matches this regular expression:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkUseExclusion.setLayoutData((Object)gdTmp);
        this.chkUseExclusion.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.edExclusion.setEnabled(Editor.this.chkUseExclusion.getSelection());
            }
        });
        this.edExclusion = new Text((Composite)grpTmp, 2048);
        gdTmp = new GridData(768);
        gdTmp.horizontalSpan = 2;
        this.edExclusion.setLayoutData((Object)gdTmp);
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("SimpleTM Output");
        grpTmp.setLayout((Layout)new GridLayout(2, false));
        gdTmp = new GridData(768);
        grpTmp.setLayoutData((Object)gdTmp);
        this.chkCreateTM = new Button((Composite)grpTmp, 32);
        this.chkCreateTM.setText("Create a SimpleTM database with the following path:");
        gdTmp = new GridData();
        gdTmp.horizontalSpan = 2;
        this.chkCreateTM.setLayoutData((Object)gdTmp);
        this.chkCreateTM.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.updateTMOptions();
            }
        });
        this.edTMPath = new Text((Composite)grpTmp, 2048);
        this.edTMPath.setLayoutData((Object)new GridData(768));
        this.btGetTMPath = new Button((Composite)grpTmp, 8);
        this.btGetTMPath.setText("...");
        this.btGetTMPath.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String path = Dialogs.browseFilenamesForSave(Editor.this.shell, "Simple TM File", null, null, "Simple TMs (*.h2.db)\tAll Files (*.*)", "*.h2.db\t*.*");
                Utils.checkProjectDirAfterPick(path, Editor.this.edTMPath, Editor.this.projectDir);
            }
        });
        grpTmp = new Group(cmpTmp, 0);
        grpTmp.setText("Attributes");
        grpTmp.setLayout((Layout)new GridLayout());
        gdTmp = new GridData(1808);
        grpTmp.setLayoutData((Object)gdTmp);
        this.chkCreateAttributes = new Button((Composite)grpTmp, 32);
        this.chkCreateAttributes.setText("Use the following attributes (one per line in the format name=value):");
        this.chkCreateAttributes.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.edAttributes.setEnabled(Editor.this.chkCreateAttributes.getSelection());
            }
        });
        this.edAttributes = new Text((Composite)grpTmp, 2562);
        gdTmp = new GridData(1808);
        gdTmp.heightHint = 100;
        this.edAttributes.setLayoutData((Object)gdTmp);
        SelectionAdapter OKCancelActions = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Editor.this.result = false;
                if (e.widget.getData().equals("h")) {
                    if (Editor.this.help != null) {
                        Editor.this.help.showWiki("Rainbow - ID-Based Alignment");
                    }
                    return;
                }
                if (e.widget.getData().equals("o")) {
                    if (!Editor.this.saveData()) {
                        return;
                    }
                    Editor.this.result = true;
                }
                Editor.this.shell.close();
            }
        };
        this.pnlActions = new OKCancelPanel((Composite)this.shell, 0, OKCancelActions, true, "Execute");
        this.pnlActions.setLayoutData(new GridData(768));
        this.pnlActions.btOK.setEnabled(!readOnly);
        if (!readOnly) {
            this.shell.setDefaultButton(this.pnlActions.btOK);
        }
        this.shell.pack();
        this.shell.setMinimumSize(this.shell.getSize());
        Point startSize = this.shell.getMinimumSize();
        if (startSize.x < 600) {
            startSize.x = 600;
        }
        this.shell.setSize(startSize);
        this.setData();
        this.inInit = false;
        Dialogs.centerWindow(this.shell, parent);
    }

    private boolean showDialog() {
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return this.result;
    }

    private void setData() {
        this.pnlSegmentation.setData(this.params.getSegment(), this.params.getSourceSrxPath(), this.params.getTargetSrxPath());
        this.chkCheckSingleSegUnit.setSelection(this.params.getCheckSingleSegUnit());
        this.chkUseAutoCorrection.setSelection(this.params.getUseAutoCorrection());
        this.chkCreateTMX.setSelection(this.params.getCreateTMX());
        this.edTMXPath.setText(this.params.getTmxPath());
        this.chkCreateTMXForUnknown.setSelection(this.params.getCreateTMXForUnknown());
        this.edTMXForUnknownPath.setText(this.params.getTmxForUnknownPath());
        this.edTMPath.setText(this.params.getTmPath());
        this.chkUseTradosWorkarounds.setSelection(this.params.getUseTradosWorkarounds());
        this.chkUseExclusion.setSelection(this.params.getUseExclusion());
        this.edExclusion.setText(this.params.getExclusion());
        this.updateTMXOptions();
        this.chkCreateTM.setSelection(this.params.getCreateTM());
        this.edTMPath.setEnabled(this.chkCreateTM.getSelection());
        this.btGetTMPath.setEnabled(this.chkCreateTM.getSelection());
        this.updateTMOptions();
        this.chkCreateAttributes.setSelection(this.params.getCreateAttributes());
        ConfigurationString tmp = new ConfigurationString(this.params.getAttributes());
        this.edAttributes.setText(tmp.toString());
        this.edAttributes.setEnabled(this.chkCreateAttributes.getSelection());
        this.edMTKey.setText(this.params.getMtKey());
    }

    private void updateTMXOptions() {
        this.edTMXPath.setEnabled(this.chkCreateTMX.getSelection());
        this.btGetTMXPath.setEnabled(this.chkCreateTMX.getSelection());
        this.edTMXForUnknownPath.setEnabled(this.chkCreateTMXForUnknown.getSelection());
        this.btGetTMXForUnknownPath.setEnabled(this.chkCreateTMXForUnknown.getSelection());
        this.chkUseTradosWorkarounds.setEnabled(this.chkCreateTMX.getSelection() || this.chkCreateTMXForUnknown.getSelection());
        this.edExclusion.setEnabled(this.chkUseExclusion.getSelection());
    }

    private void updateTMOptions() {
        this.edTMPath.setEnabled(this.chkCreateTM.getSelection());
        this.btGetTMPath.setEnabled(this.chkCreateTM.getSelection());
    }

    private boolean saveData() {
        if (this.inInit) {
            return true;
        }
        boolean segment = this.pnlSegmentation.getSegment();
        if (segment) {
            if (this.pnlSegmentation.getSourceSRX().length() == 0) {
                Dialogs.showError(this.shell, "You must specify an SRX document for the source.", null);
                return false;
            }
            if (this.pnlSegmentation.getTargetSRX().length() == 0) {
                Dialogs.showError(this.shell, "You must specify an SRX document for the target.", null);
                return false;
            }
        }
        if (this.chkCreateTMX.getSelection() && this.edTMXPath.getText().length() == 0) {
            Dialogs.showError(this.shell, "You must specify the path of the TMX document.", null);
            return false;
        }
        if (this.chkCreateTMXForUnknown.getSelection() && this.edTMXForUnknownPath.getText().length() == 0) {
            Dialogs.showError(this.shell, "You must specify the path of the TMX document.", null);
            return false;
        }
        if (this.chkCreateTM.getSelection() && this.edTMPath.getText().length() == 0) {
            Dialogs.showError(this.shell, "You must specify the path of the SimpleTM database.", null);
            return false;
        }
        if (!(this.chkCreateTMX.getSelection() || this.chkCreateTMXForUnknown.getSelection() || this.chkCreateTM.getSelection())) {
            Dialogs.showError(this.shell, "You must specify at least one output.", null);
            return false;
        }
        this.params.setSegment(segment);
        if (segment) {
            this.params.setSourceSrxPath(this.pnlSegmentation.getSourceSRX());
            this.params.setTargetSrxPath(this.pnlSegmentation.getTargetSRX());
        }
        this.params.setCheckSingleSegUnit(this.chkCheckSingleSegUnit.getSelection());
        this.params.setUseAutoCorrection(this.chkUseAutoCorrection.getSelection());
        this.params.setCreateTMX(this.chkCreateTMX.getSelection());
        if (this.params.getCreateTMX()) {
            this.params.setTmxPath(this.edTMXPath.getText());
            this.params.setUseTradosWorkarounds(this.chkUseTradosWorkarounds.getSelection());
            this.params.setUseExclusion(this.chkUseExclusion.getSelection());
            if (this.params.getUseExclusion()) {
                this.params.setExclusion(this.edExclusion.getText());
            }
        }
        this.params.setCreateTMXForUnknown(this.chkCreateTMXForUnknown.getSelection());
        if (this.params.getCreateTMXForUnknown()) {
            this.params.setTmxForUnknownPath(this.edTMXForUnknownPath.getText());
        }
        if (this.params.getCreateTMX() || this.params.getCreateTMXForUnknown()) {
            this.params.setUseTradosWorkarounds(this.chkUseTradosWorkarounds.getSelection());
            this.params.setUseExclusion(this.chkUseExclusion.getSelection());
            if (this.params.getUseExclusion()) {
                this.params.setExclusion(this.edExclusion.getText());
            }
        }
        this.params.setCreateTM(this.chkCreateTM.getSelection());
        if (this.params.getCreateTM()) {
            this.params.setTmPath(this.edTMPath.getText());
        }
        this.params.setCreateAttributes(this.chkCreateAttributes.getSelection());
        if (this.params.getCreateAttributes()) {
            ConfigurationString tmp = new ConfigurationString(this.edAttributes.getText());
            this.params.setAttributes(tmp.toString());
        }
        this.params.setMtKey(this.edMTKey.getText().trim());
        return true;
    }
}

