/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.applications.rainbow.utilities.merging;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import net.sf.okapi.applications.rainbow.packages.IReader;
import net.sf.okapi.applications.rainbow.packages.Manifest;
import net.sf.okapi.applications.rainbow.packages.ManifestItem;
import net.sf.okapi.common.Event;
import net.sf.okapi.common.EventType;
import net.sf.okapi.common.IParameters;
import net.sf.okapi.common.LocaleId;
import net.sf.okapi.common.Range;
import net.sf.okapi.common.Util;
import net.sf.okapi.common.filters.DefaultFilters;
import net.sf.okapi.common.filters.FilterConfigurationMapper;
import net.sf.okapi.common.filters.IFilter;
import net.sf.okapi.common.filterwriter.IFilterWriter;
import net.sf.okapi.common.resource.Code;
import net.sf.okapi.common.resource.ITextUnit;
import net.sf.okapi.common.resource.Property;
import net.sf.okapi.common.resource.RawDocument;
import net.sf.okapi.common.resource.TextContainer;
import net.sf.okapi.filters.rtf.RTFFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Merger {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Manifest manifest;
    private IReader reader;
    private FilterConfigurationMapper mapper = new FilterConfigurationMapper();
    private IFilter inpFilter;
    private IFilterWriter outFilter;
    private RTFFilter rtfFilter;
    private LocaleId trgLoc;

    public Merger() {
        DefaultFilters.setMappings(this.mapper, false, true);
    }

    public void initialize(Manifest manifest) {
        if (this.reader != null) {
            this.reader.closeDocument();
            this.reader = null;
        }
        this.manifest = manifest;
        this.trgLoc = manifest.getTargetLanguage();
    }

    public void execute(int docId) {
        ManifestItem item = this.manifest.getItem(docId);
        if (!item.selected()) {
            return;
        }
        if (item.getPostProcessingType().equals("rtf")) {
            this.convertFromRTF(docId, item);
        } else {
            this.merge(docId, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void convertFromRTF(int docId, ManifestItem item) {
        OutputStreamWriter writer = null;
        try {
            String fileToConvert = this.manifest.getFileToMergePath(docId);
            if (this.rtfFilter == null) {
                this.rtfFilter = new RTFFilter();
            }
            this.logger.info("\nConverting: {}", (Object)fileToConvert);
            String lineBreak = "\r\n";
            File f = new File(fileToConvert);
            this.rtfFilter.open(new RawDocument(f.toURI(), "windows-1252", this.manifest.getTargetLanguage()));
            String outputFile = this.manifest.getFileToGeneratePath(docId);
            Util.createDirectories(outputFile);
            writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(outputFile)), item.getOutputEncoding());
            Util.writeBOMIfNeeded(writer, false, item.getOutputEncoding());
            StringBuilder buf = new StringBuilder();
            while (this.rtfFilter.getTextUntil(buf, -1, 0) == 0) {
                writer.write(buf.toString());
                writer.write(lineBreak);
            }
        }
        catch (Exception e) {
            Throwable e2 = e.getCause();
            this.logger.error("Conversion error. {}", (Object)(e2 != null ? e2.getMessage() : e.getMessage()), (Object)e);
        }
        finally {
            if (this.rtfFilter != null) {
                this.rtfFilter.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    this.logger.error("Conversion error when closing file. {}", (Object)e.getMessage(), (Object)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void merge(int docId, ManifestItem item) {
        try {
            String fileToMerge = this.manifest.getFileToMergePath(docId);
            if (this.reader == null) {
                this.reader = (IReader)Class.forName(this.manifest.getReaderClass()).newInstance();
            }
            this.logger.info("\nMerging: {}", (Object)fileToMerge);
            String originalFile = this.manifest.getRoot() + File.separator + this.manifest.getOriginalLocation() + File.separator + String.format("%d.ori", docId);
            String paramsFile = this.manifest.getRoot() + File.separator + this.manifest.getOriginalLocation() + File.separator + String.format("%d.fprm", docId);
            this.inpFilter = this.mapper.createFilter(item.getFilterID(), this.inpFilter);
            IParameters params = this.inpFilter.getParameters();
            if (params != null) {
                File file = new File(paramsFile);
                params.load(file.toURI(), false);
            }
            this.reader.openDocument(fileToMerge, this.manifest.getSourceLanguage(), this.manifest.getTargetLanguage());
            File f = new File(originalFile);
            this.inpFilter.open(new RawDocument(f.toURI(), item.getInputEncoding(), this.manifest.getSourceLanguage(), this.trgLoc));
            String outputFile = this.manifest.getFileToGeneratePath(docId);
            Util.createDirectories(outputFile);
            this.outFilter = this.inpFilter.createFilterWriter();
            this.outFilter.setOptions(this.trgLoc, item.getOutputEncoding());
            this.outFilter.setOutput(outputFile);
            while (this.inpFilter.hasNext()) {
                Event event = this.inpFilter.next();
                if (event.getEventType() == EventType.TEXT_UNIT) {
                    this.processTextUnit(event.getTextUnit());
                }
                this.outFilter.handleEvent(event);
            }
        }
        catch (Exception e) {
            Throwable e2 = e.getCause();
            this.logger.error("Merging error. {}", (Object)(e2 != null ? e2.getMessage() : e.getMessage()), (Object)e);
        }
        finally {
            if (this.reader != null) {
                this.reader.closeDocument();
                this.reader = null;
            }
            if (this.inpFilter != null) {
                this.inpFilter.close();
                this.inpFilter = null;
            }
            if (this.outFilter != null) {
                this.outFilter.close();
                this.outFilter = null;
            }
        }
    }

    private void processTextUnit(ITextUnit tu) {
        TextContainer srcCont;
        ITextUnit tuFromTrans;
        if (!tu.isTranslatable()) {
            return;
        }
        do {
            if (!this.reader.readItem()) {
                this.logger.warn("There is no more items in the package to merge with id=\"{}\".", (Object)tu.getId());
                return;
            }
            tuFromTrans = this.reader.getItem();
        } while (!tu.getId().equals(tuFromTrans.getId()));
        if (!tuFromTrans.hasTarget(this.trgLoc) && !tu.getSource().isEmpty()) {
            this.logger.warn("Item id=\"{}\": No translation provided; using source instead.", (Object)tu.getId());
            return;
        }
        boolean isTransApproved = false;
        Property prop = tuFromTrans.getTargetProperty(this.trgLoc, "approved");
        if (prop != null) {
            isTransApproved = prop.getValue().equals("yes");
        }
        if (this.manifest.useApprovedOnly() && !isTransApproved) {
            this.logger.warn("Item id='{}': Target is not approved; using source instead.", (Object)tu.getId());
            return;
        }
        TextContainer fromTrans = tuFromTrans.getTarget(this.trgLoc);
        if (fromTrans == null) {
            if (tuFromTrans.getSource().isEmpty()) {
                return;
            }
            this.logger.warn("Item id='{}': No target in XLIFF; using source instead.", (Object)tu.getId());
            return;
        }
        boolean mergeAsSegments = false;
        if (tu.getMimeType() != null && (tu.getMimeType().equals("application/x-ttx+xml") || tu.getMimeType().equals("application/x-xliff+xml"))) {
            mergeAsSegments = true;
        }
        ArrayList<Range> ranges = null;
        List<Range> srcRanges = null;
        if (mergeAsSegments) {
            ranges = new ArrayList<Range>();
            srcRanges = tuFromTrans.getSourceSegments().getRanges();
        }
        if (!fromTrans.contentIsOneSegment()) {
            fromTrans.getSegments().joinAll(ranges);
        }
        if (!tu.getSource().contentIsOneSegment()) {
            srcCont = tu.getSource().clone();
            srcCont.getSegments().joinAll();
        } else {
            srcCont = tu.getSource();
        }
        List<Code> transCodes = this.transferCodes(fromTrans, srcCont, tu);
        TextContainer trgCont = tu.createTarget(this.trgLoc, false, 7);
        if (!trgCont.contentIsOneSegment()) {
            trgCont.getSegments().joinAll();
        }
        if (this.manifest.updateApprovedFlag()) {
            trgCont.setProperty(new Property("approved", "yes"));
        }
        try {
            trgCont.getFirstContent().setCodedText(fromTrans.getCodedText(), transCodes, false);
            if (mergeAsSegments) {
                trgCont.getSegments().create(ranges);
                tu.getSource().getSegments().create(srcRanges);
            }
        }
        catch (RuntimeException e) {
            this.logger.error("Inline code error with item id=\"{}\".\n{}", (Object)tu.getId(), (Object)e.getLocalizedMessage());
            tu.setTarget(this.trgLoc, tu.getSource());
        }
    }

    private List<Code> transferCodes(TextContainer fromTrans, TextContainer srcCont, ITextUnit tu) {
        int i;
        List<Code> transCodes = fromTrans.getFirstContent().getCodes();
        List<Code> oriCodes = srcCont.getFirstContent().getCodes();
        if (transCodes.size() == 0 && oriCodes.size() == 0) {
            return transCodes;
        }
        int[] oriIndices = new int[oriCodes.size()];
        for (int i2 = 0; i2 < oriIndices.length; ++i2) {
            oriIndices[i2] = i2;
        }
        int done = 0;
        for (i = 0; i < transCodes.size(); ++i) {
            Code transCode = transCodes.get(i);
            transCode.setOuterData(null);
            Code oriCode = null;
            for (int j = 0; j < oriIndices.length; ++j) {
                if (oriIndices[j] == -1 || oriCodes.get(oriIndices[j]).getId() != transCode.getId()) continue;
                oriCode = oriCodes.get(oriIndices[j]);
                oriIndices[j] = -1;
                ++done;
                break;
            }
            if (oriCode == null) {
                if (transCode.hasData()) continue;
                this.logger.warn("The extra target code id='{}' does not have corresponding data (item id='{}', name='{}')", new Object[]{transCode.getId(), tu.getId(), tu.getName() == null ? "" : tu.getName()});
                continue;
            }
            if (oriCode.hasOuterData()) {
                transCode.setOuterData(oriCode.getOuterData());
            } else if (!transCode.hasData()) {
                transCode.setData(oriCode.getData());
            }
            transCode.setReferenceFlag(oriCode.hasReference());
        }
        if (oriCodes.size() > done) {
            for (i = 0; i < oriIndices.length; ++i) {
                Code code;
                if (oriIndices[i] == -1 || (code = oriCodes.get(oriIndices[i])).isDeleteable()) continue;
                this.logger.warn("The code id='{}' ({}) is missing in target (item id='{}', name='{}')", new Object[]{code.getId(), code.getData(), tu.getId(), tu.getName() == null ? "" : tu.getName()});
                this.logger.info("Source='{}'", (Object)tu.getSource().toString());
            }
        }
        return transCodes;
    }
}

