/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.filters;

import java.text.Collator;
import java.util.Iterator;
import java.util.Locale;
import net.sf.okapi.common.filters.FilterConfiguration;
import net.sf.okapi.common.filters.IFilterConfigurationMapper;
import net.sf.okapi.common.ui.filters.Res;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class FilterConfigurationsTableModel {
    static final int ID_COLINDEX = 1;
    private Table table;
    private IFilterConfigurationMapper mapper;

    FilterConfigurationsTableModel() {
    }

    void linkTable(Table newTable) {
        this.table = newTable;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.name"));
        SortListener sortListener = new SortListener();
        col.addListener(13, sortListener);
        this.table.setSortColumn(col);
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.id"));
        col.addListener(13, sortListener);
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.mimeType"));
        col.addListener(13, sortListener);
        col = new TableColumn(this.table, 0);
        col.setText(Res.getString("FilterConfigurationsTableModel.custom"));
        col.addListener(13, sortListener);
    }

    void setMapper(IFilterConfigurationMapper mapper) {
        this.mapper = mapper;
    }

    void updateTable(int selection, String selectedConfigId) {
        this.table.removeAll();
        if (this.mapper == null) {
            return;
        }
        Iterator iter = this.mapper.getAllConfigurations();
        while (iter.hasNext()) {
            FilterConfiguration config = (FilterConfiguration)iter.next();
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, config.name);
            item.setText(1, config.configId);
            item.setText(2, config.mimeType);
            item.setText(3, config.custom ? Res.getString("FilterConfigurationsTableModel.customFlag") : Res.getString("FilterConfigurationsTableModel.predefinedFlag"));
        }
        this.sortTableByColumn(this.table.getSortColumn());
        if (this.restoreSelection(selectedConfigId)) {
            return;
        }
        if (selection < 0 || selection > this.table.getItemCount() - 1) {
            selection = this.table.getItemCount() - 1;
        }
        if (this.table.getItemCount() > 0) {
            this.table.setSelection(selection);
        }
    }

    private void sortTableByColumn(TableColumn column) {
        Collator collator = Collator.getInstance(Locale.getDefault());
        int index = this.getColumnIndex(column);
        this.table.setSortColumn(column);
        TableItem[] tableItems = this.table.getItems();
        block0: for (int i = 1; i < tableItems.length; ++i) {
            String text1 = tableItems[i].getText(index);
            for (int j = 0; j < i; ++j) {
                String text2 = tableItems[j].getText(index);
                if (collator.compare(text1, text2) >= 0) continue;
                String[] fcData = new String[]{tableItems[i].getText(0), tableItems[i].getText(1), tableItems[i].getText(2), tableItems[i].getText(3)};
                tableItems[i].dispose();
                TableItem item = new TableItem(this.table, 0, j);
                item.setText(fcData);
                tableItems = this.table.getItems();
                continue block0;
            }
        }
    }

    private int getColumnIndex(TableColumn col) {
        TableColumn[] cols = this.table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            if (col != cols[i]) continue;
            return i;
        }
        throw new IllegalStateException("Unknown table column: " + col);
    }

    private boolean restoreSelection(String selectedConfigId) {
        if (selectedConfigId != null) {
            for (TableItem item : this.table.getItems()) {
                if (!item.getText(1).equals(selectedConfigId)) continue;
                this.table.setSelection(item);
                return true;
            }
        }
        return false;
    }

    class SortListener
    implements Listener {
        SortListener() {
        }

        @Override
        public void handleEvent(Event e) {
            TableColumn column = (TableColumn)e.widget;
            TableItem[] selections = FilterConfigurationsTableModel.this.table.getSelection();
            String selectedConfigId = selections.length > 0 ? selections[0].getText(1) : null;
            FilterConfigurationsTableModel.this.sortTableByColumn(column);
            FilterConfigurationsTableModel.this.restoreSelection(selectedConfigId);
        }
    }
}

