/*
 * Decompiled with CFR 0.152.
 */
package net.sf.okapi.common.ui.plugins;

import java.util.List;
import net.sf.okapi.common.ui.plugins.PluginInfo;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

class TableModel {
    private Table table;
    private boolean maxMode;

    TableModel(Table newTable, boolean maxMode) {
        this.table = newTable;
        this.maxMode = maxMode;
        TableColumn col = new TableColumn(this.table, 0);
        col.setText("Name");
        if (maxMode) {
            col = new TableColumn(this.table, 0);
            col.setText("Provider");
        } else {
            col = new TableColumn(this.table, 0);
            col.setText("Locked?");
        }
        col.pack();
    }

    void updateTable(List<PluginInfo> list, List<String> lockedPlugins, int index) {
        this.table.removeAll();
        for (PluginInfo info : list) {
            TableItem item = new TableItem(this.table, 0);
            item.setText(0, info.getName());
            if (this.maxMode) {
                item.setText(1, info.getProvider());
            } else if (lockedPlugins.contains(info.getName())) {
                item.setText(1, "Locked");
            }
            item.setData(info);
        }
        if (this.table.getItemCount() > 0) {
            if (index > -1) {
                if (index > this.table.getItemCount() - 1) {
                    index = this.table.getItemCount() - 1;
                }
            } else {
                index = 0;
            }
            this.table.setSelection(index);
        }
    }
}

